/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.util;

import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ListUtil {
    public static <T> List<T> convertList(List<? extends T> list) {
        return new ArrayList<T>(list);
    }

    public static List<Integer> createList(int[] array) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int val : array) {
            list.add(val);
        }
        return list;
    }

    @Nonnull
    public static <T> T randomItemFromList(@Nonnull List<T> list, @Nonnull T emptyEntry) {
        return (T)ListUtil.randomItemFromList(list, () -> emptyEntry);
    }

    @Nonnull
    public static <T> T randomItemFromList(@Nonnull List<T> list, @Nonnull Supplier<T> emptyEntry) {
        if (list.isEmpty()) {
            return emptyEntry.get();
        }
        int displayIndex = (int)(TimeUtil.getCurrentTime() / 2000L % (long)list.size());
        return list.get(displayIndex);
    }

    @Nonnull
    public static <T> T randomItemFromCollection(@Nonnull Collection<T> collection, @Nonnull T emptyEntry) {
        return (T)ListUtil.randomItemFromCollection(collection, () -> emptyEntry);
    }

    @Nonnull
    public static <T> T randomItemFromCollection(@Nonnull Collection<T> collection, @Nonnull Supplier<T> emptyEntry) {
        return ListUtil.randomItemFromList(collection.stream().toList(), emptyEntry);
    }

    @Nullable
    public static <T> T weightedRandomItemFromList(List<T> list, Function<T, Integer> weightGetter) {
        int totalWeight = 0;
        for (T entry : list) {
            totalWeight += weightGetter.apply(entry).intValue();
        }
        if (totalWeight <= 0) {
            return null;
        }
        int random = new Random().nextInt(totalWeight);
        int index = 0;
        while (index < list.size()) {
            T entry;
            if ((random -= weightGetter.apply(entry = list.get(index++)).intValue()) >= 0) continue;
            return entry;
        }
        return null;
    }
}

