/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.emergency_ejection;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.ejection.EjectionData;
import io.github.lightman314.lightmanscurrency.api.ejection.EjectionDataType;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.api.misc.icons.ItemIcon;
import io.github.lightman314.lightmanscurrency.api.misc.player.OwnerData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderState;
import io.github.lightman314.lightmanscurrency.common.menus.containers.NonEmptyContainer;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;

public class TraderEjectionData
extends EjectionData {
    public static final EjectionDataType TYPE = new Type();
    private IData data;

    public TraderEjectionData(long traderID, @Nonnull ItemStack item) {
        this.data = new PreSplitData(traderID, item);
    }

    private TraderEjectionData(@Nonnull IData data) {
        this.data = data;
    }

    @Override
    @Nonnull
    public OwnerData getOwner() {
        return this.data.getOwner(this);
    }

    @Override
    @Nonnull
    public Component getName() {
        return this.data.getName(this);
    }

    @Override
    @Nonnull
    public EjectionDataType getType() {
        return TYPE;
    }

    @Override
    @Nonnull
    public Container getContents() {
        return this.data.getContents();
    }

    @Override
    protected void saveAdditional(@Nonnull CompoundTag tag) {
        tag.m_128379_("Split", this.data.isSplit());
        this.data.saveAdditional(tag);
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty(this) || super.isEmpty();
    }

    @Override
    public boolean canSplit() {
        return this.data.isPreSplit();
    }

    public long getTraderID() {
        IData iData = this.data;
        if (iData instanceof PreSplitData) {
            PreSplitData d = (PreSplitData)iData;
            return d.traderID;
        }
        return -1L;
    }

    public void delete() {
        this.data = EmptyData.INSTANCE;
        this.setChanged();
    }

    @Override
    @Nonnull
    public List<Component> getSplitButtonTooltip() {
        IData iData = this.data;
        if (iData instanceof PreSplitData) {
            PreSplitData psd = (PreSplitData)iData;
            return Lists.newArrayList((Object[])new Component[]{LCText.TOOLTIP_EJECTION_SPLIT_TRADER.get(psd.item.m_41786_())});
        }
        return super.getSplitButtonTooltip();
    }

    @Override
    @Nonnull
    public IconData getSplitButtonIcon() {
        IData iData = this.data;
        if (iData instanceof PreSplitData) {
            PreSplitData psd = (PreSplitData)iData;
            return ItemIcon.ofItem(psd.item);
        }
        return super.getSplitButtonIcon();
    }

    @Override
    public void splitContents() {
        IData iData = this.data;
        if (iData instanceof PreSplitData) {
            PreSplitData psd = (PreSplitData)iData;
            if (!psd.contents.m_7983_()) {
                LightmansCurrency.LogDebug("Splitting Trader Data!");
                TraderData trader = psd.getTrader(this);
                if (trader == null || trader.getState() != TraderState.EJECTED) {
                    return;
                }
                ItemStack item = psd.item.m_41777_();
                item.m_41751_(null);
                SimpleContainer contents = InventoryUtil.buildInventory(trader.getContents(item));
                OwnerData owner = new OwnerData(IClientTracker.forClient());
                owner.copyFrom(trader.getOwner());
                this.data = new SplitData(owner, new NonEmptyContainer((Container)contents), (Component)trader.getName());
                if (this.isServer()) {
                    TraderAPI.getApi().DeleteTrader(trader);
                }
            }
        }
    }

    private static class PreSplitData
    implements IData {
        private final long traderID;
        private final ItemStack item;
        private final Container contents;

        private PreSplitData(long traderID, @Nonnull ItemStack item) {
            this.traderID = traderID;
            this.item = item.m_41777_();
            this.contents = InventoryUtil.buildInventory(item);
        }

        private TraderData getTrader(@Nonnull IClientTracker context) {
            return TraderAPI.getApi().GetTrader(context, this.traderID);
        }

        @Override
        @Nonnull
        public OwnerData getOwner(@Nonnull IClientTracker context) {
            TraderData trader = this.getTrader(context);
            return trader == null ? new OwnerData(context) : trader.getOwner();
        }

        @Override
        @Nonnull
        public Component getName(@Nonnull IClientTracker context) {
            TraderData trader = this.getTrader(context);
            return trader == null ? LCText.GUI_TRADER_DEFAULT_NAME.get(new Object[0]) : trader.getName();
        }

        @Override
        @Nonnull
        public Container getContents() {
            return this.contents;
        }

        @Override
        public boolean isEmpty(@Nonnull IClientTracker context) {
            TraderData trader = this.getTrader(context);
            return trader == null || trader.getState() != TraderState.EJECTED;
        }

        @Override
        public void saveAdditional(@Nonnull CompoundTag tag) {
            tag.m_128356_("TraderID", this.traderID);
            tag.m_128365_("Item", (Tag)this.item.m_41739_(new CompoundTag()));
        }

        @Nonnull
        private static PreSplitData load(@Nonnull CompoundTag tag) {
            long traderID = tag.m_128454_("TraderID");
            ItemStack item = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Item"));
            return new PreSplitData(traderID, item);
        }
    }

    private static interface IData {
        default public boolean isPreSplit() {
            return this instanceof PreSplitData;
        }

        default public boolean isSplit() {
            return this instanceof SplitData;
        }

        @Nonnull
        public OwnerData getOwner(@Nonnull IClientTracker var1);

        @Nonnull
        public Component getName(@Nonnull IClientTracker var1);

        @Nonnull
        public Container getContents();

        public boolean isEmpty(@Nonnull IClientTracker var1);

        public void saveAdditional(@Nonnull CompoundTag var1);
    }

    private static class EmptyData
    implements IData {
        private static final EmptyData INSTANCE = new EmptyData();

        private EmptyData() {
        }

        @Override
        @Nonnull
        public OwnerData getOwner(@Nonnull IClientTracker context) {
            return new OwnerData(context);
        }

        @Override
        @Nonnull
        public Component getName(@Nonnull IClientTracker context) {
            return EasyText.literal("NULL");
        }

        @Override
        @Nonnull
        public Container getContents() {
            return new NonEmptyContainer(new ArrayList<ItemStack>());
        }

        @Override
        public boolean isEmpty(@Nonnull IClientTracker context) {
            return true;
        }

        @Override
        public void saveAdditional(@Nonnull CompoundTag tag) {
            tag.m_128379_("Empty", true);
        }
    }

    private static class SplitData
    implements IData {
        private final OwnerData tempOwner;
        private OwnerData owner;
        private final NonEmptyContainer contents;
        private final Component name;

        private SplitData(@Nonnull OwnerData owner, @Nonnull NonEmptyContainer container, @Nonnull Component name) {
            this.tempOwner = owner;
            this.contents = container;
            this.name = name;
        }

        @Override
        @Nonnull
        public OwnerData getOwner(@Nonnull IClientTracker context) {
            if (this.owner == null) {
                this.owner = new OwnerData(context);
                this.owner.copyFrom(this.tempOwner);
            }
            return this.owner;
        }

        @Override
        @Nonnull
        public Component getName(@Nonnull IClientTracker context) {
            return this.name;
        }

        @Override
        @Nonnull
        public Container getContents() {
            return this.contents;
        }

        @Override
        public boolean isEmpty(@Nonnull IClientTracker context) {
            return false;
        }

        @Override
        public void saveAdditional(@Nonnull CompoundTag tag) {
            OwnerData o = this.owner == null ? this.tempOwner : this.owner;
            tag.m_128365_("Owner", (Tag)o.save());
            this.contents.save(tag, "Contents");
            tag.m_128359_("Name", Component.Serializer.m_130703_((Component)this.name));
        }

        @Nonnull
        public static SplitData load(@Nonnull CompoundTag tag) {
            OwnerData owner = new OwnerData(IClientTracker.forClient());
            owner.load(tag.m_128469_("Owner"));
            NonEmptyContainer contents = NonEmptyContainer.load(tag, "Contents");
            MutableComponent name = Component.Serializer.m_130701_((String)tag.m_128461_("Name"));
            return new SplitData(owner, contents, (Component)name);
        }
    }

    private static class Type
    extends EjectionDataType {
        private Type() {
        }

        @Override
        @Nonnull
        public EjectionData load(@Nonnull CompoundTag tag) {
            if (tag.m_128471_("Empty")) {
                return new TraderEjectionData(EmptyData.INSTANCE);
            }
            boolean split = tag.m_128471_("Split");
            IData data = split ? SplitData.load(tag) : PreSplitData.load(tag);
            return new TraderEjectionData(data);
        }
    }
}

