/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.events.BuildDefaultMoneyDataEvent;
import io.github.lightman314.lightmanscurrency.api.events.ChainDataReloadedEvent;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.api.money.coins.ICoinLike;
import io.github.lightman314.lightmanscurrency.api.money.coins.atm.ATMAPI;
import io.github.lightman314.lightmanscurrency.api.money.coins.atm.data.ATMData;
import io.github.lightman314.lightmanscurrency.api.money.coins.atm.data.ATMExchangeButtonData;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.ChainData;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.CoinInputType;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.coin.CoinEntry;
import io.github.lightman314.lightmanscurrency.api.money.coins.display.ValueDisplayAPI;
import io.github.lightman314.lightmanscurrency.api.money.coins.display.builtin.CoinDisplay;
import io.github.lightman314.lightmanscurrency.api.money.coins.display.builtin.NumberDisplay;
import io.github.lightman314.lightmanscurrency.api.money.coins.old_compat.OldCoinData;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.IWalletHandler;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.WalletCapability;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.data.SPacketSyncCoinData;
import io.github.lightman314.lightmanscurrency.util.FileUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.ResourceLocationException;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public final class CoinAPIImpl
extends CoinAPI {
    private static CoinAPIImpl instance;
    private static final Gson GSON;
    Map<String, ChainData> loadedChains = null;
    Map<ResourceLocation, ChainData> itemIdToChainMap = null;
    private final List<Comparator<ItemStack>> customSorters = new ArrayList<Comparator<ItemStack>>();
    private final List<BiPredicate<ItemStack, Boolean>> customCoinContainerFilters = new ArrayList<BiPredicate<ItemStack, Boolean>>();
    private boolean setup = false;

    public CoinAPIImpl() {
        instance = this;
    }

    @Override
    public boolean NoDataAvailable() {
        return this.loadedChains == null;
    }

    @Override
    public void Setup() {
        if (this.setup) {
            return;
        }
        this.setup = true;
        this.customCoinContainerFilters.add(this::IsCoin);
        this.customCoinContainerFilters.add((stack, side) -> {
            Item patt4153$temp = stack.m_41720_();
            if (patt4153$temp instanceof ICoinLike) {
                ICoinLike coin = (ICoinLike)patt4153$temp;
                return coin.isCoin((ItemStack)stack) && (side != false || !coin.isFromSideChain((ItemStack)stack));
            }
            return false;
        });
        MinecraftForge.EVENT_BUS.addListener(this::onServerStart);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, this::onJoinServer);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, this::generateDefaultCoins);
        ValueDisplayAPI.Setup();
        ATMAPI.Setup();
    }

    @Override
    public void ReloadCoinDataFromFile() {
        LightmansCurrency.LogInfo("Reloading Money Data");
        File mcl = new File("config/lightmanscurrency/MasterCoinList.json");
        if (!mcl.exists()) {
            LightmansCurrency.LogInfo("MasterCoinList.json does not exist. Creating a fresh copy.");
            this.createMoneyDataFile(mcl, this.generateDefaultMoneyData(), false);
        }
        try {
            JsonObject fileData = GsonHelper.m_13864_((String)Files.readString(mcl.toPath()));
            if (fileData.has("CoinEntries") && !fileData.has("Chains")) {
                this.loadDeprecatedData(GsonHelper.m_13933_((JsonObject)fileData, (String)"CoinEntries"));
            } else {
                this.loadMoneyDataFromJson(fileData);
            }
        }
        catch (JsonParseException | IOException | ResourceLocationException e) {
            LightmansCurrency.LogError("Error loading the Master Coin List. Using default values for now.", e);
            this.loadData(this.generateDefaultMoneyData());
        }
        this.SyncCoinDataWith(PacketDistributor.ALL.noArg());
    }

    public static void LoadEditedData(String customJson) {
        try {
            JsonObject json = GsonHelper.m_13864_((String)customJson);
            instance.loadMoneyDataFromJson(json);
            instance.createMoneyDataFile(new File("config/lightmanscurrency/MasterCoinList.json"), CoinAPIImpl.instance.loadedChains, false);
        }
        catch (JsonParseException | ResourceLocationException e) {
            LightmansCurrency.LogError("Error parsing custom json data!", e);
        }
    }

    private void loadData(Map<String, ChainData> dataMap) {
        ChainDataReloadedEvent.Pre event = new ChainDataReloadedEvent.Pre(dataMap);
        MinecraftForge.EVENT_BUS.post((Event)event);
        this.loadedChains = event.getChainMap();
        HashMap<ResourceLocation, ChainData> temp = new HashMap<ResourceLocation, ChainData>();
        for (ChainData chain : this.loadedChains.values()) {
            for (CoinEntry entry : chain.getAllEntries(true)) {
                ResourceLocation coinID = ForgeRegistries.ITEMS.getKey((Object)entry.getCoin());
                temp.put(coinID, chain);
            }
        }
        this.itemIdToChainMap = ImmutableMap.copyOf(temp);
        MinecraftForge.EVENT_BUS.post((Event)new ChainDataReloadedEvent.Post(this.loadedChains));
    }

    private void loadDeprecatedData(JsonArray oldArray) throws JsonSyntaxException, ResourceLocationException {
        HashMap<String, List> oldData = new HashMap<String, List>();
        for (int i = 0; i < oldArray.size(); ++i) {
            try {
                OldCoinData data = OldCoinData.parse(GsonHelper.m_13918_((JsonElement)oldArray.get(i), (String)("CoinEntries[" + i + "]")));
                if (oldData.containsKey(data.chain)) {
                    ((List)oldData.get(data.chain)).add(data);
                    continue;
                }
                ArrayList<OldCoinData> list = new ArrayList<OldCoinData>();
                list.add(data);
                oldData.put(data.chain, list);
                continue;
            }
            catch (JsonSyntaxException | ResourceLocationException e) {
                LightmansCurrency.LogError("Error parsing CoinEntries[" + i + "] entry!", e);
            }
        }
        HashMap<String, ChainData> tempMap = new HashMap<String, ChainData>();
        oldData.forEach((chain, dataList) -> {
            ChainData.Builder builder = ChainData.builder(chain, Component.m_237115_((String)("lightmanscurrency.money.chain." + chain)));
            CoinDisplay.Builder displayBuilder = CoinDisplay.builder();
            for (Object data : dataList) {
                MutableComponent plural;
                MutableComponent initial = ((OldCoinData)data).initialTranslation != null ? Component.m_237115_((String)((OldCoinData)data).initialTranslation) : null;
                MutableComponent mutableComponent = plural = ((OldCoinData)data).pluralTranslation != null ? Component.m_237115_((String)((OldCoinData)data).pluralTranslation) : null;
                if (initial == null && plural == null) continue;
                displayBuilder.defineFor((ItemLike)((OldCoinData)data).coinItem, (Component)initial, (Component)plural);
            }
            builder.withDisplay(displayBuilder.build());
            OldCoinData rootCoin = null;
            for (OldCoinData data : dataList) {
                if (data.worthOtherCoin != null || data.isHidden) continue;
                rootCoin = data;
                break;
            }
            dataList.remove(rootCoin);
            ChainData.Builder.ChainBuilder coreChain = builder.withCoreChain((ItemLike)rootCoin.coinItem);
            OldCoinData nextCoin = this.findNextInChain((List<OldCoinData>)dataList, rootCoin.coinItem, true);
            while (nextCoin != null) {
                coreChain.withCoin((ItemLike)nextCoin.coinItem, nextCoin.worthOtherCoinCount);
                dataList.remove(nextCoin);
                nextCoin = this.findNextInChain((List<OldCoinData>)dataList, nextCoin.coinItem, true);
            }
            for (CoinEntry entry : coreChain.getEntries()) {
                OldCoinData sideChainRoot = this.findNextInChain((List<OldCoinData>)dataList, entry.getCoin(), false);
                while (sideChainRoot != null) {
                    try {
                        dataList.remove(sideChainRoot);
                        ChainData.Builder.ChainBuilder sideChain = builder.withSideChain((ItemLike)sideChainRoot.coinItem, sideChainRoot.worthOtherCoinCount, (ItemLike)entry.getCoin());
                        nextCoin = this.findNextInChain((List<OldCoinData>)dataList, sideChainRoot.coinItem, false);
                        while (nextCoin != null) {
                            sideChain.withCoin((ItemLike)nextCoin.coinItem, nextCoin.worthOtherCoinCount);
                            dataList.remove(nextCoin);
                            nextCoin = this.findNextInChain((List<OldCoinData>)dataList, nextCoin.coinItem, false);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    sideChainRoot = this.findNextInChain((List<OldCoinData>)dataList, entry.getCoin(), false);
                }
            }
            if (!dataList.isEmpty()) {
                LightmansCurrency.LogWarning("Old MasterCoinList data could not be fully converted, likely due to multiple chain splits in a 'hidden' side-chain.");
            }
            if (chain.equals("main")) {
                ATMData.parseDeprecated(builder);
            }
            tempMap.put((String)chain, builder.build());
        });
        if (tempMap.isEmpty()) {
            throw new JsonSyntaxException("No valid chains could be converted to the new system!");
        }
        this.loadData(tempMap);
        LightmansCurrency.LogInfo("Old MasterCoinList data successfully converted to the new system! Replacing the old MasterCoinList.json file with the updated data.");
        this.createMoneyDataFile(new File("config/lightmanscurrency/MasterCoinList.json"), this.loadedChains, true);
    }

    private OldCoinData findNextInChain(List<OldCoinData> dataList, Item coin, boolean coreChainOnly) {
        for (OldCoinData data : dataList) {
            if (data.worthOtherCoin != coin || coreChainOnly && data.isHidden) continue;
            return data;
        }
        return null;
    }

    private void loadMoneyDataFromJson(JsonObject root) throws JsonSyntaxException, ResourceLocationException {
        ArrayList<CoinEntry> allEntries = new ArrayList<CoinEntry>();
        HashMap<String, ChainData> tempMap = new HashMap<String, ChainData>();
        JsonArray chainList = GsonHelper.m_13933_((JsonObject)root, (String)"Chains");
        for (int i = 0; i < chainList.size(); ++i) {
            String chainName = "UNDEFINED";
            try {
                JsonObject entry = GsonHelper.m_13918_((JsonElement)chainList.get(i), (String)("Chains[" + i + "]"));
                chainName = GsonHelper.m_13851_((JsonObject)entry, (String)"chain", null);
                ChainData chain = ChainData.fromJson(allEntries, entry);
                if (tempMap.containsKey(chain.chain)) {
                    throw new JsonSyntaxException("Multple '" + chain.chain + "' chains detected. Duplicate will be ignored!");
                }
                tempMap.put(chain.chain, chain);
                continue;
            }
            catch (JsonSyntaxException | ResourceLocationException e) {
                LightmansCurrency.LogError("Error loading Chain[" + i + "] (" + chainName + ") from the Master Coin List!", e);
            }
        }
        if (tempMap.isEmpty()) {
            throw new JsonSyntaxException("No valid coin chains were registered!");
        }
        if (!tempMap.containsKey("main")) {
            throw new JsonSyntaxException("At least 1 chain named 'main' must be present!");
        }
        this.loadData(tempMap);
    }

    private void createMoneyDataFile(File mcl, Map<String, ChainData> data, boolean hideEventChains) {
        File dir = new File(mcl.getParent());
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (dir.exists()) {
            try {
                mcl.createNewFile();
                JsonObject json = this.getDataJson(data, hideEventChains);
                FileUtil.writeStringToFile(mcl, GSON.toJson((JsonElement)json));
            }
            catch (IOException e) {
                LightmansCurrency.LogError("Error attempting to create 'MasterCoinList.json' file.", e);
            }
        }
    }

    private Map<String, ChainData> generateDefaultMoneyData() {
        BuildDefaultMoneyDataEvent event = new BuildDefaultMoneyDataEvent();
        try {
            MinecraftForge.EVENT_BUS.post((Event)event);
        }
        catch (RuntimeException e) {
            LightmansCurrency.LogError("Error generating default money data!", e);
            return new HashMap<String, ChainData>();
        }
        HashMap<String, ChainData> results = new HashMap<String, ChainData>();
        event.getFinalResult().forEach((chain, builder) -> results.put((String)chain, builder.build()));
        return results;
    }

    private void generateDefaultCoins(BuildDefaultMoneyDataEvent event) {
        ChainData.builder("main", LCText.COIN_CHAIN_MAIN).withCoreChain(ModItems.COIN_COPPER).withCoin(ModItems.COIN_IRON, 10).withCoin(ModItems.COIN_GOLD, 10).withCoin(ModItems.COIN_EMERALD, 10).withCoin(ModItems.COIN_DIAMOND, 10).withCoin(ModItems.COIN_NETHERITE, 10).back().withSideChain((Supplier<? extends ItemLike>)ModBlocks.COINPILE_COPPER, 9, (Supplier<? extends ItemLike>)ModItems.COIN_COPPER).withCoin((Supplier<? extends ItemLike>)ModBlocks.COINBLOCK_COPPER, 4).back().withSideChain((Supplier<? extends ItemLike>)ModBlocks.COINPILE_IRON, 9, (Supplier<? extends ItemLike>)ModItems.COIN_IRON).withCoin((Supplier<? extends ItemLike>)ModBlocks.COINBLOCK_IRON, 4).back().withSideChain((Supplier<? extends ItemLike>)ModBlocks.COINPILE_GOLD, 9, (Supplier<? extends ItemLike>)ModItems.COIN_GOLD).withCoin((Supplier<? extends ItemLike>)ModBlocks.COINBLOCK_GOLD, 4).back().withSideChain((Supplier<? extends ItemLike>)ModBlocks.COINPILE_EMERALD, 9, (Supplier<? extends ItemLike>)ModItems.COIN_EMERALD).withCoin((Supplier<? extends ItemLike>)ModBlocks.COINBLOCK_EMERALD, 4).back().withSideChain((Supplier<? extends ItemLike>)ModBlocks.COINPILE_DIAMOND, 9, (Supplier<? extends ItemLike>)ModItems.COIN_DIAMOND).withCoin((Supplier<? extends ItemLike>)ModBlocks.COINBLOCK_DIAMOND, 4).back().withSideChain((Supplier<? extends ItemLike>)ModBlocks.COINPILE_NETHERITE, 9, (Supplier<? extends ItemLike>)ModItems.COIN_NETHERITE).withCoin((Supplier<? extends ItemLike>)ModBlocks.COINBLOCK_NETHERITE, 4).back().withDisplay(CoinDisplay.easyDefine()).atmBuilder().accept(ATMExchangeButtonData::generateMain).back().apply(event, true);
        ChainData.builder("emeralds", LCText.COIN_CHAIN_EMERALDS).withCoreChain((ItemLike)Items.f_42616_).withCoin((ItemLike)Items.f_42110_, 9).back().withInputType(CoinInputType.DEFAULT).withDisplay(new NumberDisplay(LCText.COIN_CHAIN_EMERALDS_DISPLAY, LCText.COIN_CHAIN_EMERALDS_DISPLAY_WORDY, Items.f_42616_)).apply(event, true);
    }

    private JsonObject getDataJson(Map<String, ChainData> data, boolean hideEventChains) {
        JsonObject fileJson = new JsonObject();
        JsonArray chainArray = new JsonArray();
        for (ChainData chain : data.values()) {
            if (hideEventChains && chain.isEvent) continue;
            chainArray.add((JsonElement)chain.getAsJson());
        }
        fileJson.add("Chains", (JsonElement)chainArray);
        return fileJson;
    }

    @Override
    public ItemStack getEquippedWallet(Player player) {
        ItemStack wallet = ItemStack.f_41583_;
        IWalletHandler walletHandler = WalletCapability.lazyGetWalletHandler((Entity)player);
        if (walletHandler != null) {
            wallet = walletHandler.getWallet();
        }
        if (!WalletItem.validWalletStack(wallet)) {
            LightmansCurrency.LogDebug(player.m_7755_().getString() + "'s equipped wallet is not a valid WalletItem.");
            LightmansCurrency.LogDebug("Equipped wallet is of type " + wallet.m_41720_().getClass().getName());
            return ItemStack.f_41583_;
        }
        return wallet;
    }

    @Override
    @javax.annotation.Nullable
    public ChainData ChainData(String chain) {
        if (this.NoDataAvailable()) {
            return null;
        }
        return this.loadedChains.get(chain);
    }

    @Override
    public List<ChainData> AllChainData() {
        if (this.NoDataAvailable()) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(this.loadedChains.values());
    }

    @Override
    @Nullable
    public ChainData ChainDataOfCoin(ItemStack coin) {
        return this.ChainDataOfCoin(coin.m_41720_());
    }

    @Override
    @javax.annotation.Nullable
    public ChainData ChainDataOfCoin(Item coin) {
        if (this.NoDataAvailable()) {
            return null;
        }
        return this.itemIdToChainMap.get(ForgeRegistries.ITEMS.getKey((Object)coin));
    }

    @Override
    public boolean IsCoin(ItemStack coin, boolean allowSideChains) {
        return !coin.m_41619_() && this.IsCoin(coin.m_41720_(), allowSideChains);
    }

    @Override
    public boolean IsCoin(Item coin, boolean allowSideChains) {
        if (coin == Items.f_41852_) {
            return false;
        }
        ChainData chainData = this.ChainDataOfCoin(coin);
        if (chainData != null) {
            if (allowSideChains) {
                return true;
            }
            CoinEntry entry = chainData.findEntry(coin);
            if (entry != null) {
                return !entry.isSideChain();
            }
            return false;
        }
        return false;
    }

    @Override
    public void RegisterCoinContainerFilter(BiPredicate<ItemStack, Boolean> filter) {
        if (!this.customCoinContainerFilters.contains(filter)) {
            this.customCoinContainerFilters.add(filter);
        }
    }

    @Override
    public boolean IsAllowedInCoinContainer(ItemStack coin, boolean allowSideChains) {
        for (BiPredicate<ItemStack, Boolean> filter : this.customCoinContainerFilters) {
            if (!filter.test(coin, allowSideChains)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean IsAllowedInCoinContainer(Item coin, boolean allowSideChains) {
        return this.IsAllowedInCoinContainer(new ItemStack((ItemLike)coin), allowSideChains);
    }

    @Override
    public void CoinExchangeAllUp(Container container) {
        if (this.NoDataAvailable()) {
            return;
        }
        for (ChainData chain : this.AllChainData()) {
            List<CoinEntry> entryList = chain.getAllEntries(false, ChainData.SORT_LOWEST_VALUE_FIRST);
            for (CoinEntry entry : entryList) {
                this.CoinExchangeUp(container, entry.getCoin());
            }
            for (CoinEntry entry : entryList) {
                this.CoinExchangeUp(container, entry.getCoin());
            }
            for (CoinEntry entry : entryList) {
                this.CoinExchangeUp(container, entry.getCoin());
            }
        }
    }

    @Override
    public void CoinExchangeUp(Container container, Item smallCoin) {
        if (this.NoDataAvailable()) {
            return;
        }
        ChainData chain = this.ChainDataOfCoin(smallCoin);
        if (chain == null) {
            return;
        }
        Pair<CoinEntry, Integer> upperExchange = chain.getUpperExchange(smallCoin);
        if (upperExchange == null) {
            return;
        }
        Item largeCoin = ((CoinEntry)upperExchange.getFirst()).getCoin();
        int smallCoinCount = (Integer)upperExchange.getSecond();
        while (InventoryUtil.GetItemCount(container, smallCoin) >= smallCoinCount) {
            InventoryUtil.RemoveItemCount(container, smallCoin, smallCoinCount);
            ItemStack newCoinStack = new ItemStack((ItemLike)largeCoin, 1);
            if (InventoryUtil.PutItemStack(container, newCoinStack)) continue;
            InventoryUtil.TryPutItemStack(container, new ItemStack((ItemLike)smallCoin, smallCoinCount));
            return;
        }
    }

    @Override
    public void CoinExchangeAllDown(Container container) {
        if (this.NoDataAvailable()) {
            return;
        }
        for (ChainData chain : this.AllChainData()) {
            List<CoinEntry> entryList = chain.getAllEntries(false, ChainData.SORT_HIGHEST_VALUE_FIRST);
            for (CoinEntry entry : entryList) {
                this.CoinExchangeDown(container, entry.getCoin());
            }
            for (CoinEntry entry : entryList) {
                this.CoinExchangeDown(container, entry.getCoin());
            }
        }
    }

    @Override
    public void CoinExchangeDown(Container container, Item largeCoin) {
        if (this.NoDataAvailable()) {
            return;
        }
        ChainData chain = this.ChainDataOfCoin(largeCoin);
        if (chain == null) {
            return;
        }
        Pair<CoinEntry, Integer> lowerExchange = chain.getLowerExchange(largeCoin);
        if (lowerExchange == null) {
            return;
        }
        Item smallCoin = ((CoinEntry)lowerExchange.getFirst()).getCoin();
        int smallCoinCount = (Integer)lowerExchange.getSecond();
        while (InventoryUtil.GetItemCount(container, largeCoin) > 0) {
            InventoryUtil.RemoveItemCount(container, largeCoin, 1);
            ItemStack newCoinStack = new ItemStack((ItemLike)smallCoin, smallCoinCount);
            if (InventoryUtil.PutItemStack(container, newCoinStack)) continue;
            InventoryUtil.TryPutItemStack(container, new ItemStack((ItemLike)largeCoin, 1));
            return;
        }
    }

    @Override
    public void SortCoinsByValue(Container container) {
        InventoryUtil.MergeStacks(container);
        ArrayList<ItemStack> oldInventory = new ArrayList<ItemStack>();
        for (int i = 0; i < container.m_6643_(); ++i) {
            if (container.m_8020_(i).m_41619_()) continue;
            oldInventory.add(container.m_8020_(i));
        }
        container.m_6211_();
        oldInventory.sort(COIN_SORTER);
        int index = 0;
        while (!oldInventory.isEmpty()) {
            container.m_6836_(index++, (ItemStack)oldInventory.get(0));
            oldInventory.remove(0);
        }
    }

    @Override
    public void RegisterCustomSorter(Comparator<ItemStack> sorter) {
        if (!this.customSorters.contains(sorter)) {
            this.customSorters.add(sorter);
        }
    }

    private void onServerStart(ServerAboutToStartEvent event) {
        this.ReloadCoinDataFromFile();
    }

    private void onJoinServer(PlayerEvent.PlayerLoggedInEvent event) {
        LightmansCurrency.LogDebug("PlayerLoggedInEvent was called!");
        if (this.NoDataAvailable()) {
            this.ReloadCoinDataFromFile();
        }
        this.SyncCoinDataWith(LightmansCurrencyPacketHandler.getTarget(event.getEntity()));
    }

    @Override
    public void SyncCoinDataWith(PacketDistributor.PacketTarget target) {
        new SPacketSyncCoinData(this.getDataJson(this.loadedChains, false)).sendToTarget(target);
    }

    @Override
    public void HandleSyncPacket(SPacketSyncCoinData packet) {
        this.loadMoneyDataFromJson(packet.getJson());
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    }

    public static class CoinSorter
    implements Comparator<ItemStack> {
        @Override
        public int compare(ItemStack stack1, ItemStack stack2) {
            CoinEntry entry2;
            if (stack1.m_41720_() == stack2.m_41720_()) {
                return Integer.compare(stack2.m_41613_(), stack1.m_41613_());
            }
            ChainData chain1 = CoinAPI.getApi().ChainDataOfCoin(stack1);
            ChainData chain2 = CoinAPI.getApi().ChainDataOfCoin(stack2);
            if (chain1 == null && chain2 == null) {
                for (Comparator<ItemStack> custom : CoinAPIImpl.instance.customSorters) {
                    int result = custom.compare(stack1, stack2);
                    if (result == 0) continue;
                    return result;
                }
            }
            if (chain2 == null) {
                return -1;
            }
            if (chain1 == null) {
                return 1;
            }
            if (chain1 != chain2) {
                return chain2.getDisplayName().getString().compareToIgnoreCase(chain1.getDisplayName().getString());
            }
            CoinEntry entry1 = chain1.findEntry(stack1);
            if (entry1 == (entry2 = chain2.findEntry(stack2))) {
                return Integer.compare(stack2.m_41613_(), stack1.m_41613_());
            }
            return Long.compare(entry2.getCoreValue(), entry1.getCoreValue());
        }
    }
}

