/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.impl;

import io.github.lightman314.lightmanscurrency.LCRegistries;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.ejection.EjectionData;
import io.github.lightman314.lightmanscurrency.api.ejection.EjectionDataType;
import io.github.lightman314.lightmanscurrency.api.ejection.SafeEjectionAPI;
import io.github.lightman314.lightmanscurrency.common.data.types.EjectionDataCache;
import io.github.lightman314.lightmanscurrency.common.emergency_ejection.OldEjectionDataHelper;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SafeEjectionAPIImpl
extends SafeEjectionAPI {
    @Override
    public List<EjectionData> getAllData(boolean isClient) {
        return EjectionDataCache.TYPE.get(isClient).getData();
    }

    @Override
    public List<EjectionData> getDataForPlayer(Player player) {
        return this.getAllData(player.m_9236_().f_46443_).stream().filter(d -> d.canAccess(player) && !d.isEmpty()).toList();
    }

    @Override
    @Nullable
    public EjectionData parseData(CompoundTag tag) {
        if (!tag.m_128441_("type")) {
            return OldEjectionDataHelper.parseOldData(tag);
        }
        EjectionDataType type = (EjectionDataType)LCRegistries.EJECTION_DATA.getValue(VersionUtil.parseResource(tag.m_128461_("type")));
        if (type == null) {
            LightmansCurrency.LogWarning("Could not parse Ejection Data as no EjectionDataType was registered for '" + tag.m_128461_("type") + "'!");
            return null;
        }
        EjectionData data = type.load(tag);
        if (tag.m_128441_("ID")) {
            data.setID(tag.m_128454_("ID"));
        }
        return type.load(tag);
    }

    @Override
    public void handleEjection(Level level, BlockPos pos, EjectionData data) {
        if (level.f_46443_) {
            return;
        }
        EjectionDataCache d = EjectionDataCache.TYPE.get(false);
        if (d != null) {
            d.handleEjection(level, pos, data);
        }
    }
}

