/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.trader.auction;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IPeripheral;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.data.types.TraderDataCache;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.common.traders.auction.tradedata.AuctionTradeData;
import io.github.lightman314.lightmanscurrency.integration.computercraft.LCPeripheral;
import io.github.lightman314.lightmanscurrency.integration.computercraft.PeripheralMethod;
import io.github.lightman314.lightmanscurrency.integration.computercraft.data.LCLuaTable;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;

public class AuctionHousePeripheral
extends LCPeripheral {
    public static IPeripheral INSTANCE = new AuctionHousePeripheral();

    private AuctionHousePeripheral() {
    }

    public String getType() {
        return "lc_trader_auction";
    }

    public boolean equals(@Nullable IPeripheral other) {
        return other == INSTANCE;
    }

    private AuctionHouseTrader getTrader() throws LuaException {
        if (!((Boolean)LCConfig.SERVER.auctionHouseEnabled.get()).booleanValue()) {
            throw new LuaException("Auction House is disabled!");
        }
        TraderDataCache data = TraderDataCache.TYPE.get(false);
        TraderData traderData = data.getAuctionHouse();
        if (traderData instanceof AuctionHouseTrader) {
            AuctionHouseTrader ah = (AuctionHouseTrader)traderData;
            return ah;
        }
        throw new LuaException("Auction House could not be located!");
    }

    public long getID() throws LuaException {
        return this.getTrader().getID();
    }

    public int getAuctionCount() throws LuaException {
        return this.getTrader().validTradeCount();
    }

    public LCLuaTable[] getAuctions() throws LuaException {
        AuctionHouseTrader trader = this.getTrader();
        ArrayList<LCLuaTable> list = new ArrayList<LCLuaTable>();
        for (int i = 0; i < trader.getTradeCount(); ++i) {
            AuctionTradeData trade = trader.getTrade(i);
            if (!trade.isValid()) continue;
            LCLuaTable entry = new LCLuaTable();
            entry.put("LastBid", LCLuaTable.fromMoney(trade.getLastBidAmount()));
            entry.put("MinumumBid", LCLuaTable.fromMoney(trade.getMinNextBid()));
            entry.put("BidDifference", LCLuaTable.fromMoney(trade.getMinBidDifference()));
            PlayerReference lastBidder = trade.getLastBidPlayer();
            entry.put("LastBidder", lastBidder == null ? null : lastBidder.getName(false));
            entry.put("Owner", trade.getOwner().getName(false));
            entry.put("RemainingTime", trade.getRemainingTime(TimeUtil.getCurrentTime()));
            ArrayList<LCLuaTable> items = new ArrayList<LCLuaTable>();
            for (ItemStack item : trade.getAuctionItems()) {
                items.add(LCLuaTable.fromTag(InventoryUtil.saveItemNoLimits(item)));
            }
            entry.put("Items", items.toArray(LCLuaTable[]::new));
            list.add(entry);
        }
        return (LCLuaTable[])list.toArray(LCLuaTable[]::new);
    }

    @Override
    protected void registerMethods(PeripheralMethod.Registration registration) {
        registration.register(PeripheralMethod.builder("getID").simple(this::getID));
        registration.register(PeripheralMethod.builder("getAuctionCount").simple(this::getAuctionCount));
        registration.register(PeripheralMethod.builder("getAuctions").simple(this::getAuctions));
    }
}

