/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.trader.paygate;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IPeripheral;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.common.blockentity.trader.PaygateBlockEntity;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.PaygateTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.tradedata.PaygateTradeData;
import io.github.lightman314.lightmanscurrency.integration.computercraft.PeripheralMethod;
import io.github.lightman314.lightmanscurrency.integration.computercraft.data.LCLuaTable;
import io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.trader.TraderPeripheral;
import io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.trader.paygate.PaygateTradeWrapper;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public class PaygatePeripheral
extends TraderPeripheral<PaygateBlockEntity, PaygateTraderData> {
    public PaygatePeripheral(PaygateBlockEntity paygateBlockEntity) {
        super(paygateBlockEntity);
    }

    public String getType() {
        return "lc_trader_paygate";
    }

    public LCLuaTable[] getTicketStubStorage() throws LuaException {
        ArrayList<LCLuaTable> list = new ArrayList<LCLuaTable>();
        for (ItemStack stub : ((PaygateTraderData)this.getTrader()).getTicketStubStorage()) {
            list.add(LCLuaTable.fromTag(InventoryUtil.saveItemNoLimits(stub)));
        }
        return (LCLuaTable[])list.toArray(LCLuaTable[]::new);
    }

    private Supplier<PaygateTradeData> tradeSource(int index) {
        return () -> {
            PaygateTraderData trader = (PaygateTraderData)this.safeGetTrader();
            if (trader != null && index >= 0 && index < trader.getTradeCount()) {
                return trader.getTrade(index);
            }
            return null;
        };
    }

    @Override
    @Nullable
    protected IPeripheral wrapTrade(TradeData trade) throws LuaException {
        int index = ((PaygateTraderData)this.getTrader()).indexOfTrade(trade);
        return new PaygateTradeWrapper(this.tradeSource(index), this::safeGetTrader);
    }

    public PaygateTradeWrapper[] getTrades() throws LuaException {
        ArrayList<PaygateTradeWrapper> list = new ArrayList<PaygateTradeWrapper>();
        PaygateTraderData trader = (PaygateTraderData)this.getTrader();
        for (int i = 0; i < trader.getTradeCount(); ++i) {
            list.add(new PaygateTradeWrapper(this.tradeSource(i), this::safeGetTrader));
        }
        return (PaygateTradeWrapper[])list.toArray(PaygateTradeWrapper[]::new);
    }

    public LCLuaTable getRedstoneState() throws LuaException {
        PaygateBlockEntity be = (PaygateBlockEntity)this.getBlockEntity();
        if (be == null) {
            throw new LuaException("An unexpected error occurred attempting to access the Paygate!");
        }
        LCLuaTable table = new LCLuaTable();
        CompoundTag tag = new CompoundTag();
        be.saveRedstoneData(tag);
        Set unusedSides = Arrays.stream(Direction.values()).collect(Collectors.toSet());
        for (PaygateBlockEntity.OutputVisibilityData data : PaygateBlockEntity.parseVisibilityData(tag)) {
            LCLuaTable entry = new LCLuaTable();
            if (data.name() != null) {
                entry.put("Name", data.name());
            }
            entry.put("Power", data.power());
            entry.put("Timer", data.timer());
            for (Direction side : data.sides()) {
                table.putTable(side.toString(), entry);
                unusedSides.remove(side);
            }
        }
        for (Direction side : unusedSides) {
            table.put(side.toString(), new LCLuaTable());
        }
        return table;
    }

    @Override
    protected void registerMethods(PeripheralMethod.Registration registration) {
        super.registerMethods(registration);
        registration.register(PeripheralMethod.builder("getTicketStubStorage").simpleArray(this::getTicketStubStorage));
        registration.register(PeripheralMethod.builder("getTrades").simpleArray(this::getTrades));
        registration.register(PeripheralMethod.builder("getRedstoneState").simple(this::getRedstoneState));
    }
}

