/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat;

import com.momosoftworks.coldsweat.common.blockentity.HearthBlockEntity;
import com.momosoftworks.coldsweat.common.entity.Chameleon;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ModUpdater;
import com.momosoftworks.coldsweat.config.spec.ClientSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.EntitySettingsConfig;
import com.momosoftworks.coldsweat.config.spec.ItemSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.MainSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.WorldSettingsConfig;
import com.momosoftworks.coldsweat.core.init.ModAdvancementTriggers;
import com.momosoftworks.coldsweat.core.init.ModArmorMaterials;
import com.momosoftworks.coldsweat.core.init.ModAttributes;
import com.momosoftworks.coldsweat.core.init.ModBiomeModifiers;
import com.momosoftworks.coldsweat.core.init.ModBlockEntities;
import com.momosoftworks.coldsweat.core.init.ModBlocks;
import com.momosoftworks.coldsweat.core.init.ModCommands;
import com.momosoftworks.coldsweat.core.init.ModCreativeTabs;
import com.momosoftworks.coldsweat.core.init.ModDataAttachments;
import com.momosoftworks.coldsweat.core.init.ModEffects;
import com.momosoftworks.coldsweat.core.init.ModEntities;
import com.momosoftworks.coldsweat.core.init.ModFeatures;
import com.momosoftworks.coldsweat.core.init.ModItemComponents;
import com.momosoftworks.coldsweat.core.init.ModItems;
import com.momosoftworks.coldsweat.core.init.ModMenus;
import com.momosoftworks.coldsweat.core.init.ModParticleTypes;
import com.momosoftworks.coldsweat.core.init.ModPotions;
import com.momosoftworks.coldsweat.core.init.ModSounds;
import com.momosoftworks.coldsweat.core.init.ModTempEffects;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="cold_sweat")
public class ColdSweat {
    public static final Logger LOGGER = LogManager.getLogger((String)"Cold Sweat");
    public static final String MOD_ID = "cold_sweat";
    public static IEventBus MOD_BUS = null;

    public ColdSweat(IEventBus bus, ModContainer modContainer) {
        MOD_BUS = bus;
        MOD_BUS.addListener(this::spawnPlacements);
        MOD_BUS.addListener(this::registerCaps);
        MOD_BUS.addListener(this::updateConfigs);
        ModBlocks.BLOCKS.register(MOD_BUS);
        ModItems.ITEMS.register(MOD_BUS);
        ModEntities.ENTITY_TYPES.register(MOD_BUS);
        ModBlockEntities.BLOCK_ENTITY_TYPES.register(MOD_BUS);
        ModMenus.MENU_TYPES.register(MOD_BUS);
        ModEffects.EFFECTS.register(MOD_BUS);
        ModParticleTypes.PARTICLES.register(MOD_BUS);
        ModPotions.POTIONS.register(MOD_BUS);
        ModSounds.SOUNDS.register(MOD_BUS);
        ModFeatures.FEATURES.register(MOD_BUS);
        ModBiomeModifiers.BIOME_MODIFIER_SERIALIZERS.register(MOD_BUS);
        ModCreativeTabs.ITEM_GROUPS.register(MOD_BUS);
        ModAttributes.ATTRIBUTES.register(MOD_BUS);
        ModCommands.ARGUMENTS.register(MOD_BUS);
        ModArmorMaterials.ARMOR_MATERIALS.register(MOD_BUS);
        ModAdvancementTriggers.TRIGGERS.register(MOD_BUS);
        ModItemComponents.DATA_COMPONENTS.register(MOD_BUS);
        ModTempEffects.TEMP_EFFECTS.register(MOD_BUS);
        ModDataAttachments.DATA_ATTACHMENTS.register(MOD_BUS);
        ModUpdater.updateFileNames();
        MainSettingsConfig.setup(modContainer);
        ClientSettingsConfig.setup(modContainer);
        WorldSettingsConfig.setup(modContainer);
        ItemSettingsConfig.setup(modContainer);
        EntitySettingsConfig.setup(modContainer);
        CompatManager.registerEventHandlers();
    }

    public static ResourceLocation createKey(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static String getVersion() {
        return FMLLoader.getLoadingModList().getModFileById(MOD_ID).versionString();
    }

    public void spawnPlacements(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)ModEntities.CHAMELEON.value(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Chameleon::canSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public void registerCaps(RegisterCapabilitiesEvent event) {
        for (BlockEntityType blockEntityType : List.of((BlockEntityType)ModBlockEntities.HEARTH.value(), (BlockEntityType)ModBlockEntities.BOILER.value(), (BlockEntityType)ModBlockEntities.ICEBOX.value())) {
            event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, blockEntityType, (hearthLike, facing) -> hearthLike.isHeatingSide((Direction)facing) ? new HearthBlockEntity.HotFluidHandler((HearthBlockEntity)((Object)hearthLike)) : (hearthLike.isCoolingSide((Direction)facing) ? new HearthBlockEntity.ColdFluidHandler((HearthBlockEntity)((Object)hearthLike)) : null));
        }
    }

    public void updateConfigs(FMLLoadCompleteEvent event) {
        ModUpdater.updateConfigs();
    }
}

