/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.event.core.init;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagManager;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.util.ObfuscationReflectionHelper;

public class InitDynamicTagsEvent
extends Event {
    private final RegistryAccess registryAccess;
    private Map<TagKey<?>, Collection<Holder<?>>> tags = new HashMap();
    private static final Field MANAGER_ACCESS = ObfuscationReflectionHelper.findField(TagManager.class, (String)"registryAccess");

    public InitDynamicTagsEvent(RegistryAccess registryAccess) {
        this.registryAccess = registryAccess;
    }

    public Map<TagKey<?>, Collection<Holder<?>>> getTags() {
        return this.tags;
    }

    public <T> void fillTag(TagKey<T> tag, Predicate<T> predicate) {
        Registry registry = this.registryAccess.registryOrThrow(tag.registry());
        registry.holders().forEach(holder -> {
            if (predicate.test(holder.value())) {
                this.tags.computeIfAbsent(tag, t -> new ArrayList()).add(holder);
            }
        });
    }

    static {
        MANAGER_ACCESS.setAccessible(true);
    }
}

