/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.effect.player;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffect;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffectType;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import org.joml.Vector4f;

public abstract class AbstractVignetteEffect
extends TempEffect {
    public AbstractVignetteEffect(TempEffectType<?> type, LivingEntity entity, IntegerBounds bounds) {
        super(type, entity, bounds);
    }

    protected abstract ResourceLocation getTexture();

    protected abstract Vector4f getColor(float var1);

    protected void setupRender(float opacity, float tickTime) {
        Vector4f color = this.getColor(tickTime);
        RenderSystem.setShaderColor((float)color.x, (float)color.y, (float)color.z, (float)(opacity * color.w));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.getTexture());
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void render(float opacity, float tickTime, RenderGuiLayerEvent.Pre event) {
        float width = Minecraft.getInstance().getWindow().getWidth();
        float height = Minecraft.getInstance().getWindow().getHeight();
        float scale = (float)Minecraft.getInstance().getWindow().getGuiScale();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        this.setupRender(opacity, tickTime);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder.addVertex(0.0f, height / scale, -90.0f).setUv(0.0f, 1.0f);
        bufferbuilder.addVertex(width / scale, height / scale, -90.0f).setUv(1.0f, 1.0f);
        bufferbuilder.addVertex(width / scale, 0.0f, -90.0f).setUv(1.0f, 0.0f);
        bufferbuilder.addVertex(0.0f, 0.0f, -90.0f).setUv(0.0f, 0.0f);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void vignette(RenderGuiLayerEvent.Pre event) {
        if (!this.test((Entity)Minecraft.getInstance().player)) {
            return;
        }
        LivingEntity entity = this.entity();
        float effect = (float)this.getEffectFactor();
        float tickTime = (float)entity.tickCount + event.getPartialTick().getGameTimeDeltaPartialTick(true);
        if (event.getName() == VanillaGuiLayers.CAMERA_OVERLAYS) {
            float opacity = CSMath.blend(0.0f, 1.0f, effect, 0.0f, 1.0f);
            if (opacity == 0.0f) {
                return;
            }
            this.render(opacity, tickTime, event);
        }
    }

    @Override
    public TempEffect.Side getSide() {
        return TempEffect.Side.CLIENT;
    }
}

