/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.effect.player;

import com.momosoftworks.coldsweat.api.temperature.effect.TempEffect;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffectType;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;

public class HeatSwayEffect
extends TempEffect {
    static float PREV_X_SWAY = 0.0f;
    static float PREV_Y_SWAY = 0.0f;
    static float X_SWAY_SPEED = 0.0f;
    static float Y_SWAY_SPEED = 0.0f;
    static float X_SWAY_PHASE = 0.0f;
    static float Y_SWAY_PHASE = 0.0f;
    static float TIME_SINCE_NEW_SWAY = 0.0f;
    static float SWAY_FACTOR = 0.0f;

    public HeatSwayEffect(TempEffectType<?> type, LivingEntity entity, IntegerBounds bounds) {
        super(type, entity, bounds);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void swayCamera(ViewportEvent.ComputeCameraAngles event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (!this.test((Entity)Minecraft.getInstance().player)) {
            SWAY_FACTOR = 0.0f;
            PREV_X_SWAY = 0.0f;
            PREV_Y_SWAY = 0.0f;
            return;
        }
        float frameTime = Minecraft.getInstance().getTimer().getRealtimeDeltaTicks();
        double effect = this.getEffectFactor();
        if (!Minecraft.getInstance().isPaused() && ConfigSettings.DISTORTION_EFFECTS.get().booleanValue()) {
            float targetFactor = (float)CSMath.blend(0.0, 20.0, effect, 0.0, 1.0);
            targetFactor = (float)((double)targetFactor * ConfigSettings.HEATSTROKE_SWAY_AMOUNT.get());
            float interpolationSpeed = 0.05f * frameTime;
            SWAY_FACTOR += (targetFactor - SWAY_FACTOR) * interpolationSpeed;
            if (TIME_SINCE_NEW_SWAY > 100.0f || X_SWAY_SPEED == 0.0f || Y_SWAY_SPEED == 0.0f) {
                TIME_SINCE_NEW_SWAY = 0.0f;
                X_SWAY_SPEED = (float)((Math.random() * (double)0.002f + (double)0.0025f) * ConfigSettings.HEATSTROKE_SWAY_SPEED.get());
                Y_SWAY_SPEED = (float)((Math.random() * (double)0.002f + (double)0.0025f) * ConfigSettings.HEATSTROKE_SWAY_SPEED.get());
            }
            TIME_SINCE_NEW_SWAY += frameTime;
            X_SWAY_PHASE = (float)((double)X_SWAY_PHASE + Math.PI * 2 * (double)frameTime * (double)X_SWAY_SPEED);
            Y_SWAY_PHASE = (float)((double)Y_SWAY_PHASE + Math.PI * 2 * (double)frameTime * (double)Y_SWAY_SPEED);
            float xOffs = (float)(Math.sin(X_SWAY_PHASE) * (double)SWAY_FACTOR);
            float yOffs = (float)((Math.sin(Y_SWAY_PHASE) + Math.cos(Y_SWAY_PHASE / 4.0f) * 2.0) * (double)SWAY_FACTOR * 3.0);
            player.setXRot(player.getXRot() + xOffs - PREV_X_SWAY);
            player.setYRot(player.getYRot() + yOffs - PREV_Y_SWAY);
            PREV_X_SWAY = xOffs;
            PREV_Y_SWAY = yOffs;
        }
    }

    @Override
    public TempEffect.Side getSide() {
        return TempEffect.Side.CLIENT;
    }
}

