/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import java.util.function.Function;
import net.minecraft.world.entity.LivingEntity;

public class ArmorInsulationTempModifier
extends TempModifier {
    public ArmorInsulationTempModifier() {
        this(0.0, 0.0);
    }

    public ArmorInsulationTempModifier(double cold, double hot) {
        this.getNBT().putDouble("cold", cold);
        this.getNBT().putDouble("hot", hot);
    }

    @Override
    public Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        double cold = this.getNBT().getDouble("cold");
        double hot = this.getNBT().getDouble("hot");
        double insulationStrength = ConfigSettings.INSULATION_STRENGTH.get();
        return temp -> {
            double insulation = (temp > 0.0 ? hot : cold) * insulationStrength;
            if (insulation >= 0.0) {
                return temp * Math.pow(0.1, insulation / 40.0);
            }
            return temp * (-insulation / 20.0 + 1.0);
        };
    }
}

