/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.event;

import com.momosoftworks.coldsweat.client.gui.config.AbstractConfigPage;
import com.momosoftworks.coldsweat.client.gui.config.ConfigScreen;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.event.TaskScheduler;
import com.momosoftworks.coldsweat.core.network.message.ClientConfigAskMessage;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.options.OptionsScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Vector2i;

@EventBusSubscriber(value={Dist.CLIENT})
public class DrawConfigButton {
    public static boolean EDIT_MODE = false;

    @SubscribeEvent
    public static void eventHandler(ScreenEvent.Init.Post event) {
        if (event.getScreen() instanceof OptionsScreen && ConfigSettings.SHOW_CONFIG_BUTTON.get().booleanValue()) {
            Supplier<Vector2i> buttonPos = () -> ConfigSettings.CONFIG_BUTTON_POS.get();
            AtomicInteger xOffset = new AtomicInteger(buttonPos.get().x());
            AtomicInteger yOffset = new AtomicInteger(buttonPos.get().y());
            int buttonX = event.getScreen().width / 2 - 183;
            int buttonY = event.getScreen().height / 6 + 110;
            int screenWidth = event.getScreen().width;
            int screenHeight = event.getScreen().height;
            if (xOffset.get() + buttonX < -1 || yOffset.get() + buttonY < -1) {
                xOffset.set(0);
                yOffset.set(0);
                ConfigSettings.CONFIG_BUTTON_POS.set(new Vector2i(0, 0));
            }
            ImageButton mainButton = new ImageButton(buttonX + xOffset.get(), buttonY + yOffset.get(), 24, 24, AbstractConfigPage.CONFIG_BUTTON_SPRITES, button -> {
                ConfigScreen.CURRENT_PAGE = 0;
                if (Minecraft.getInstance().player != null) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new ClientConfigAskMessage(Minecraft.getInstance().player.getUUID()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            });
            if (Minecraft.getInstance().level == null) {
                mainButton.active = false;
                mainButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.cold_sweat.config.must_be_in_game").withStyle(ChatFormatting.RED)));
            }
            event.addListener((GuiEventListener)mainButton);
            if (EDIT_MODE) {
                int buttonStartX = event.getScreen().width / 2 - 183;
                int buttonStartY = event.getScreen().height / 6 + 110;
                Runnable saveAndClamp = () -> {
                    xOffset.set(CSMath.clamp(xOffset.get(), -buttonStartX, screenWidth - mainButton.getWidth() - buttonStartX));
                    yOffset.set(CSMath.clamp(yOffset.get(), -buttonStartY, screenHeight - mainButton.getHeight() - buttonStartY));
                    mainButton.setPosition(buttonStartX + xOffset.get(), buttonStartY + yOffset.get());
                    ConfigSettings.CONFIG_BUTTON_POS.set(new Vector2i(xOffset.get(), yOffset.get()));
                };
                AtomicReference<Object> doneButtonAtomic = new AtomicReference<Object>(null);
                event.getScreen().children().forEach(child -> {
                    if (child instanceof AbstractButton) {
                        AbstractButton button = (AbstractButton)child;
                        boolean isDoneButton = button.getMessage().getString().equals(CommonComponents.GUI_DONE.getString());
                        if (!isDoneButton) {
                            button.active = false;
                        } else {
                            doneButtonAtomic.set(button);
                            button.setWidth(button.getWidth() - 72);
                        }
                    }
                    if (child instanceof AbstractSliderButton) {
                        AbstractSliderButton slider = (AbstractSliderButton)child;
                        slider.active = false;
                    }
                });
                if (doneButtonAtomic.get() == null) {
                    return;
                }
                AbstractButton doneButton = doneButtonAtomic.get();
                ImageButton leftButton = new ImageButton(doneButton.getX() + doneButton.getWidth() + 2, doneButton.getY(), 14, 20, AbstractConfigPage.DIRECTION_LEFT_SPRITES, button -> {
                    xOffset.set(xOffset.get() - ConfigScreen.SHIFT_AMOUNT.get());
                    saveAndClamp.run();
                });
                event.addListener((GuiEventListener)leftButton);
                ImageButton upButton = new ImageButton(leftButton.getX() + leftButton.getWidth(), leftButton.getY(), 20, 10, AbstractConfigPage.DIRECTION_UP_SPRITES, button -> {
                    yOffset.set(yOffset.get() - ConfigScreen.SHIFT_AMOUNT.get());
                    saveAndClamp.run();
                });
                event.addListener((GuiEventListener)upButton);
                ImageButton downButton = new ImageButton(upButton.getX(), upButton.getY() + upButton.getHeight(), 20, 10, AbstractConfigPage.DIRECTION_DOWN_SPRITES, button -> {
                    yOffset.set(yOffset.get() + ConfigScreen.SHIFT_AMOUNT.get());
                    saveAndClamp.run();
                });
                event.addListener((GuiEventListener)downButton);
                ImageButton rightButton = new ImageButton(upButton.getX() + upButton.getWidth(), upButton.getY(), 14, 20, AbstractConfigPage.DIRECTION_RIGHT_SPRITES, button -> {
                    xOffset.set(xOffset.get() + ConfigScreen.SHIFT_AMOUNT.get());
                    saveAndClamp.run();
                });
                event.addListener((GuiEventListener)rightButton);
                ImageButton resetButton = new ImageButton(rightButton.getX() + rightButton.getWidth() + 2, rightButton.getY(), 20, 20, AbstractConfigPage.DIRECTION_RESET_SPRITES, button -> {
                    xOffset.set(0);
                    yOffset.set(0);
                    saveAndClamp.run();
                });
                event.addListener((GuiEventListener)resetButton);
                TaskScheduler.scheduleClient(() -> {
                    EDIT_MODE = false;
                }, 1);
            }
        }
    }
}

