/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.event;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.common.blockentity.HearthBlockEntity;
import com.momosoftworks.coldsweat.common.event.HearthSaveDataHandler;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;

@EventBusSubscriber(value={Dist.CLIENT})
public class HearthDebugRenderer {
    public static Map<BlockPos, Map<BlockPos, Collection<Direction>>> HEARTH_LOCATIONS = new HashMap<BlockPos, Map<BlockPos, Collection<Direction>>>();

    @SubscribeEvent
    public static void onLevelRendered(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES && Minecraft.getInstance().getDebugOverlay().showDebugScreen() && ConfigSettings.HEARTH_DEBUG.get().booleanValue()) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player == null) {
                return;
            }
            Frustum frustum = event.getFrustum();
            PoseStack ps = event.getPoseStack();
            Vec3 camPos = event.getCamera().getPosition();
            Level level = player.level();
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
            VertexConsumer vertexes = buffer.getBuffer((RenderType)RenderType.LINES);
            ps.pushPose();
            ps.translate(-camPos.x, -camPos.y, -camPos.z);
            Matrix4f matrix4f = ps.last().pose();
            PoseStack.Pose pose = ps.last();
            BiConsumer<Vector3f, Vector4f> nw = (pos, color) -> {
                vertexes.addVertex(matrix4f, pos.x(), pos.y(), pos.z()).setColor(color.x(), color.y(), color.z(), color.w()).setNormal(pose, 0.0f, 1.0f, 0.0f);
                vertexes.addVertex(matrix4f, pos.x(), pos.y() + 1.0f, pos.z()).setColor(color.x(), color.y(), color.z(), color.w()).setNormal(pose, 0.0f, 1.0f, 0.0f);
            };
            BiConsumer<Vector3f, Vector4f> ne = (pos, color) -> {
                vertexes.addVertex(matrix4f, pos.x() + 1.0f, pos.y(), pos.z()).setColor(color.x(), color.y(), color.z(), color.w()).setNormal(pose, 0.0f, 1.0f, 0.0f);
                vertexes.addVertex(matrix4f, pos.x() + 1.0f, pos.y() + 1.0f, pos.z()).setColor(color.x(), color.y(), color.z(), color.w()).setNormal(pose, 0.0f, 1.0f, 0.0f);
            };
            BiConsumer<Vector3f, Vector4f> sw = (pos, color) -> {
                vertexes.addVertex(matrix4f, pos.x(), pos.y(), pos.z() + 1.0f).setColor(color.x(), color.y(), color.z(), color.w()).setNormal(pose, 0.0f, -1.0f, 0.0f);
                vertexes.addVertex(matrix4f, pos.x(), pos.y() + 1.0f, pos.z() + 1.0f).setColor(color.x(), color.y(), color.z(), color.w()).setNormal(pose, 0.0f, -1.0f, 0.0f);
            };
            BiConsumer<Vector3f, Vector4f> se = (pos, color) -> {
                vertexes.addVertex(matrix4f, pos.x() + 1.0f, pos.y(), pos.z() + 1.0f).setColor(color.x(), color.y(), color.z(), color.w()).setNormal(pose, 0.0f, 1.0f, 0.0f);
                vertexes.addVertex(matrix4f, pos.x() + 1.0f, pos.y() + 1.0f, pos.z() + 1.0f).setColor(color.x(), color.y(), color.z(), color.w()).setNormal(pose, 0.0f, 1.0f, 0.0f);
            };
            BiConsumer<Vector3f, Vector4f> nu = (pos, color) -> {
                vertexes.addVertex(matrix4f, pos.x(), pos.y() + 1.0f, pos.z()).setColor(color.x(), color.y(), color.z(), color.w()).setNormal(pose, -1.0f, 0.0f, 0.0f);
                vertexes.addVertex(matrix4f, pos.x() + 1.0f, pos.y() + 1.0f, pos.z()).setColor(color.x(), color.y(), color.z(), color.w()).setNormal(pose, -1.0f, 0.0f, 0.0f);
            };
            BiConsumer<Vector3f, Vector4f> nd = (pos, color) -> {
                vertexes.addVertex(matrix4f, pos.x(), pos.y(), pos.z()).setColor(color.x(), color.y(), color.z(), color.w()).setNormal(pose, 1.0f, 0.0f, 0.0f);
                vertexes.addVertex(matrix4f, pos.x() + 1.0f, pos.y(), pos.z()).setColor(color.x(), color.y(), color.z(), color.w()).setNormal(pose, 1.0f, 0.0f, 0.0f);
            };
            BiConsumer<Vector3f, Vector4f> su = (pos, color) -> {
                vertexes.addVertex(matrix4f, pos.x(), pos.y() + 1.0f, pos.z() + 1.0f).setColor(color.x(), color.y(), color.z(), color.w()).setNormal(pose, 1.0f, 0.0f, 0.0f);
                vertexes.addVertex(matrix4f, pos.x() + 1.0f, pos.y() + 1.0f, pos.z() + 1.0f).setColor(color.x(), color.y(), color.z(), color.w()).setNormal(pose, 1.0f, 0.0f, 0.0f);
            };
            BiConsumer<Vector3f, Vector4f> sd = (pos, color) -> {
                vertexes.addVertex(matrix4f, pos.x(), pos.y(), pos.z() + 1.0f).setColor(color.x(), color.y(), color.z(), color.w()).setNormal(pose, 1.0f, 0.0f, 0.0f);
                vertexes.addVertex(matrix4f, pos.x() + 1.0f, pos.y(), pos.z() + 1.0f).setColor(color.x(), color.y(), color.z(), color.w()).setNormal(pose, 1.0f, 0.0f, 0.0f);
            };
            BiConsumer<Vector3f, Vector4f> eu = (pos, color) -> {
                vertexes.addVertex(matrix4f, pos.x() + 1.0f, pos.y() + 1.0f, pos.z()).setColor(color.x(), color.y(), color.z(), color.w()).setNormal(pose, 0.0f, 0.0f, 1.0f);
                vertexes.addVertex(matrix4f, pos.x() + 1.0f, pos.y() + 1.0f, pos.z() + 1.0f).setColor(color.x(), color.y(), color.z(), color.w()).setNormal(pose, 0.0f, 0.0f, 1.0f);
            };
            BiConsumer<Vector3f, Vector4f> ed = (pos, color) -> {
                vertexes.addVertex(matrix4f, pos.x() + 1.0f, pos.y(), pos.z()).setColor(color.x(), color.y(), color.z(), color.w()).setNormal(pose, 0.0f, 0.0f, -1.0f);
                vertexes.addVertex(matrix4f, pos.x() + 1.0f, pos.y(), pos.z() + 1.0f).setColor(color.x(), color.y(), color.z(), color.w()).setNormal(pose, 0.0f, 0.0f, -1.0f);
            };
            BiConsumer<Vector3f, Vector4f> wu = (pos, color) -> {
                vertexes.addVertex(matrix4f, pos.x(), pos.y() + 1.0f, pos.z()).setColor(color.x(), color.y(), color.z(), color.w()).setNormal(pose, 0.0f, 0.0f, 1.0f);
                vertexes.addVertex(matrix4f, pos.x(), pos.y() + 1.0f, pos.z() + 1.0f).setColor(color.x(), color.y(), color.z(), color.w()).setNormal(pose, 0.0f, 0.0f, 1.0f);
            };
            BiConsumer<Vector3f, Vector4f> wd = (pos, color) -> {
                vertexes.addVertex(matrix4f, pos.x(), pos.y(), pos.z()).setColor(color.x(), color.y(), color.z(), color.w()).setNormal(pose, 0.0f, 0.0f, 1.0f);
                vertexes.addVertex(matrix4f, pos.x(), pos.y(), pos.z() + 1.0f).setColor(color.x(), color.y(), color.z(), color.w()).setNormal(pose, 0.0f, 0.0f, 1.0f);
            };
            ChunkAccess workingChunk = null;
            float viewDistance = (float)((Integer)Minecraft.getInstance().options.renderDistance().get()).intValue() * 2.0f;
            ArrayList<BlockPos> invalidHearths = new ArrayList<BlockPos>();
            for (Map.Entry<BlockPos, Map<BlockPos, Collection<Direction>>> entry : HEARTH_LOCATIONS.entrySet()) {
                if (!(level.getBlockEntity(entry.getKey()) instanceof HearthBlockEntity)) {
                    invalidHearths.add(entry.getKey());
                    continue;
                }
                if (HearthSaveDataHandler.DISABLED_HEARTHS.contains(Pair.of((Object)entry.getKey(), (Object)level.dimension().location().toString()))) continue;
                Map<BlockPos, Collection<Direction>> points = entry.getValue();
                for (Map.Entry<BlockPos, Collection<Direction>> pair : points.entrySet()) {
                    BlockPos pos2 = pair.getKey();
                    Collection<Direction> directions = pair.getValue();
                    float x = pos2.getX();
                    float y = pos2.getY();
                    float z = pos2.getZ();
                    float r = 1.0f;
                    float g = 0.7f;
                    float b = 0.6f;
                    float renderAlpha = CSMath.blend(1.0f, 0.0f, (float)CSMath.getDistance((Entity)player, x + 0.5f, y + 0.5f, z + 0.5f), 5.0f, viewDistance);
                    if (!(renderAlpha > 0.01f) || !frustum.isVisible(new AABB(pos2))) continue;
                    ChunkPos chunkPos = new ChunkPos(pos2);
                    if (workingChunk == null || !workingChunk.getPos().equals((Object)chunkPos)) {
                        workingChunk = WorldHelper.getChunk((LevelAccessor)level, pos2);
                    }
                    if (workingChunk == null) continue;
                    BlockState state = workingChunk.getBlockState(pos2);
                    VoxelShape blockShape = state.getShape((BlockGetter)level, pos2);
                    if (!blockShape.isEmpty() && !state.getCollisionShape((BlockGetter)level, pos2).isEmpty()) {
                        blockShape.forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> LevelRenderer.renderLineBox((PoseStack)ps, (VertexConsumer)vertexes, (double)(minX + (double)x - 0.001), (double)(minY + (double)y - 0.001), (double)(minZ + (double)z - 0.001), (double)(maxX + (double)x + 0.001), (double)(maxY + (double)y + 0.001), (double)(maxZ + (double)z + 0.001), (float)r, (float)g, (float)b, (float)renderAlpha));
                        continue;
                    }
                    if (directions.size() == 6) continue;
                    HashSet lines = Sets.newHashSet((Object[])new BiConsumer[]{nw, ne, sw, se, nu, nd, su, sd, eu, ed, wu, wd});
                    if (directions.contains(Direction.DOWN)) {
                        Stream.of(nd, sd, ed, wd).forEach(lines::remove);
                    }
                    if (directions.contains(Direction.UP)) {
                        Stream.of(nu, su, eu, wu).forEach(lines::remove);
                    }
                    if (directions.contains(Direction.NORTH)) {
                        Stream.of(nw, ne, nu, nd).forEach(lines::remove);
                    }
                    if (directions.contains(Direction.SOUTH)) {
                        Stream.of(sw, se, su, sd).forEach(lines::remove);
                    }
                    if (directions.contains(Direction.WEST)) {
                        Stream.of(nw, sw, wu, wd).forEach(lines::remove);
                    }
                    if (directions.contains(Direction.EAST)) {
                        Stream.of(ne, se, eu, ed).forEach(lines::remove);
                    }
                    lines.forEach(line -> line.accept(new Vector3f(x, y, z), new Vector4f(r, g, b, renderAlpha)));
                }
            }
            invalidHearths.forEach(HEARTH_LOCATIONS::remove);
            RenderSystem.disableBlend();
            ps.popPose();
            buffer.endBatch((RenderType)RenderType.LINES);
        }
    }

    public static void updatePaths(HearthBlockEntity hearth) {
        if (!hearth.isSpreading()) {
            return;
        }
        BlockPos pos = hearth.getBlockPos();
        Set paths = hearth.getPaths().stream().map(path -> path.pos).collect(Collectors.toSet());
        Map pathMap = HEARTH_LOCATIONS.computeIfAbsent(pos, k -> Maps.newHashMap());
        if (pathMap.size() != paths.size()) {
            HEARTH_LOCATIONS.put(pos, paths.stream().map(path -> {
                ArrayList<Direction> dirs = new ArrayList<Direction>();
                for (int i = 0; i < Direction.values().length; ++i) {
                    Direction dir = Direction.values()[i];
                    BlockPos dirPos = path.relative(dir);
                    if (!paths.contains(dirPos)) continue;
                    dirs.add(dir);
                }
                return Map.entry(path, dirs);
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
    }
}

