/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.event;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.ModItems;
import com.momosoftworks.coldsweat.util.entity.EntityHelper;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderHandEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class RenderLampHand {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onHandRender(RenderHandEvent event) {
        if (event.getItemStack().getItem() == ModItems.SOULSPRING_LAMP.value() && ConfigSettings.POSE_SOULSPRING_LAMP.get().booleanValue()) {
            event.setCanceled(true);
            PoseStack ms = event.getPoseStack();
            LocalPlayer player = Minecraft.getInstance().player;
            if (player == null) {
                return;
            }
            boolean isRightHand = EntityHelper.getArmFromHand(event.getHand(), (Player)player) == HumanoidArm.RIGHT;
            PlayerRenderer playerRenderer = (PlayerRenderer)Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)player);
            ItemInHandRenderer handRenderer = Minecraft.getInstance().gameRenderer.itemInHandRenderer;
            ms.pushPose();
            ms.translate(0.0, 0.2, -0.3);
            ms.pushPose();
            float swingProgress = event.getSwingProgress();
            float equipProgress = event.getEquipProgress();
            float handX = isRightHand ? 1.0f : -1.0f;
            ms.translate(isRightHand ? 0.0 : -0.698, 0.6, isRightHand ? 0.7 : 0.76);
            float sqrtSwing = Mth.sqrt((float)swingProgress);
            float handSwingX = -0.3f * Mth.sin((float)(sqrtSwing * (float)Math.PI));
            float handSwingY = 0.4f * Mth.sin((float)(sqrtSwing * ((float)Math.PI * 2)));
            float handSwingZ = -0.4f * Mth.sin((float)(swingProgress * (float)Math.PI));
            float swingSize = isRightHand ? (float)(equipProgress != 0.0f && equipProgress < 1.0f ? 2 : 4) : (equipProgress != 0.0f && equipProgress < 1.0f ? 1.5f : 7.0f);
            ms.translate(handX * (handSwingX + 0.64000005f), handSwingY / swingSize + -0.6f + equipProgress * -0.6f, handSwingZ / (swingSize * 6.0f) + -0.71999997f);
            ms.mulPose(Axis.YP.rotationDegrees(handX * 45.0f));
            float handFlailZ = Mth.sin((float)(swingProgress * swingProgress * (float)Math.PI));
            float handFlailX = Mth.sin((float)(sqrtSwing * (float)Math.PI));
            ms.mulPose(Axis.YP.rotationDegrees(handX * handFlailX * (isRightHand ? 1.0f : 20.0f)));
            ms.mulPose(Axis.XP.rotationDegrees(handX * handFlailX * (isRightHand ? -10.0f : 1.0f)));
            ms.mulPose(Axis.ZP.rotationDegrees(handX * handFlailZ * 20.0f));
            ms.mulPose(Axis.XP.rotationDegrees(90.0f));
            if (isRightHand) {
                ms.mulPose(Axis.ZP.rotationDegrees(-130.0f));
            } else {
                ms.mulPose(Axis.ZP.rotationDegrees(-230.0f));
            }
            ms.scale(0.5f, 0.5f, 0.5f);
            if (isRightHand) {
                ms.translate(0.5, -0.1, 0.5);
            } else {
                ms.translate(-1.2, -0.1, 0.5);
            }
            RenderLampHand.renderHand(ms, event.getMultiBufferSource(), event.getPackedLight(), player, isRightHand, event.getHand(), handRenderer, playerRenderer, event.getItemStack());
            ms.popPose();
            ms.popPose();
        }
    }

    public static void transformArm(LivingEntity entity, ModelPart arm, HumanoidArm side) {
        Player player;
        if (entity instanceof Player && EntityHelper.holdingLamp((LivingEntity)(player = (Player)entity), side)) {
            float sideMultiplier = side == HumanoidArm.RIGHT ? 1.0f : -1.0f;
            arm.zRot += 1.5707964f * sideMultiplier;
            arm.yRot = -arm.xRot * sideMultiplier - 1.5707964f * sideMultiplier * 1.04f;
            arm.xRot = -1.5707964f;
            arm.x -= 1.0f * sideMultiplier;
            if (player.isCrouching()) {
                arm.xRot -= 0.4f;
            }
            if (player.swinging && side == EntityHelper.getArmFromHand(player.swingingArm, player)) {
                RenderLampHand.swingArm(arm, (LivingEntity)player, side);
            }
        }
    }

    private static void swingArm(ModelPart arm, LivingEntity player, HumanoidArm side) {
        float sideMultiplier = side == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        float partialTick = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
        float attackAnim = player.getAttackAnim(partialTick);
        float playerPitch = player.getViewXRot(partialTick);
        float pitchFactor = RenderLampHand.getSwingHorizontalOffset(side, playerPitch);
        float windUpTime = 0.3f;
        float windUpPoint = 1.5f;
        float midSwingTime = 0.7f;
        arm.xRot = attackAnim < windUpTime / 3.0f ? (arm.xRot += CSMath.blendLog(0.0f, windUpPoint, attackAnim, 0.0f, windUpTime / 3.0f, 1.0) / pitchFactor) : (attackAnim < windUpTime ? (arm.xRot += CSMath.blendLog(windUpPoint, 1.0f, attackAnim, windUpTime / 3.0f, windUpTime, 1.0) / pitchFactor) : (attackAnim < midSwingTime ? (arm.xRot += CSMath.blend(1.0f, 0.2f, attackAnim, windUpTime, midSwingTime) / pitchFactor) : (arm.xRot += CSMath.blendExp(0.2f, 0.0f, attackAnim, midSwingTime, 1.0f) / pitchFactor)));
        float pitchSwingHeight = playerPitch < 0.0f ? playerPitch / 20.0f : playerPitch / 60.0f;
        arm.yRot = (float)((double)arm.yRot + (Math.pow((double)attackAnim - 0.5, 2.0) - 0.25) * (double)pitchSwingHeight * (double)sideMultiplier);
        if (side == HumanoidArm.LEFT) {
            arm.zRot = (float)((double)arm.zRot + Math.sin((double)attackAnim * Math.PI) * 0.5);
        }
    }

    private static float getSwingHorizontalOffset(HumanoidArm side, float playerPitch) {
        float pitchFactor = side == HumanoidArm.RIGHT ? (playerPitch < 0.0f ? CSMath.blend(1.8f, 0.6f, playerPitch, 0.0f, -90.0f) : CSMath.blend(1.8f, 3.0f, playerPitch, 0.0f, 90.0f)) : (playerPitch < 0.0f ? CSMath.blend(3.0f, 0.5f, playerPitch, 0.0f, -90.0f) : CSMath.blend(3.0f, 3.0f, playerPitch, 0.0f, 90.0f));
        return pitchFactor;
    }

    private static void renderHand(PoseStack ms, MultiBufferSource bufferSource, int light, LocalPlayer player, boolean isRightHand, InteractionHand hand, ItemInHandRenderer handRenderer, PlayerRenderer playerRenderer, ItemStack itemStack) {
        boolean isSelected = player.getItemInHand(hand).is(ModItems.SOULSPRING_LAMP);
        ms.pushPose();
        ms.pushPose();
        ms.scale(1.0f, 1.2f, 1.0f);
        ms.mulPose(Axis.XP.rotationDegrees(-25.0f));
        ms.translate(0.0, -0.2, 0.25);
        if (!isSelected) {
            ms.translate(0.0, isRightHand ? -0.012 : 0.015, 0.0);
            ms.mulPose(Axis.ZP.rotationDegrees(2.4f * (float)(isRightHand ? -1 : 1)));
            ms.mulPose(Axis.XP.rotationDegrees(2.3f));
        }
        if (isRightHand) {
            if (isSelected) {
                ms.translate(-0.365, -0.2, -0.075);
                ms.mulPose(Axis.YP.rotationDegrees(-90.0f));
                ms.mulPose(Axis.ZP.rotationDegrees(-90.0f));
            } else {
                ms.translate(-0.3925, 0.06, 0.38);
                ms.mulPose(Axis.YP.rotationDegrees(-90.0f));
            }
            playerRenderer.renderRightHand(ms, bufferSource, light, (AbstractClientPlayer)player);
        } else {
            if (isSelected) {
                ms.translate(-0.335, -0.2, -0.075);
                ms.mulPose(Axis.YP.rotationDegrees(90.0f));
                ms.mulPose(Axis.ZP.rotationDegrees(90.0f));
            } else {
                ms.translate(-0.325, 0.06, 0.38);
                ms.mulPose(Axis.YP.rotationDegrees(87.0f));
            }
            playerRenderer.renderLeftHand(ms, bufferSource, light, (AbstractClientPlayer)player);
        }
        ms.popPose();
        ms.pushPose();
        ms.mulPose(Axis.XP.rotationDegrees(-90.0f));
        ms.translate(-0.35, 0.1, 0.625);
        ms.scale(1.0f, 1.0f, 0.8f);
        if (isRightHand) {
            ms.mulPose(Axis.ZP.rotationDegrees(90.0f));
            ms.translate(-0.1, 0.125, 0.0);
            handRenderer.renderItem((LivingEntity)player, itemStack, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, false, ms, bufferSource, light);
        } else {
            ms.mulPose(Axis.ZP.rotationDegrees(90.0f));
            ms.translate(-0.1, 0.125, 0.0);
            handRenderer.renderItem((LivingEntity)player, itemStack, ItemDisplayContext.THIRD_PERSON_LEFT_HAND, false, ms, bufferSource, light);
        }
        ms.popPose();
        ms.popPose();
    }
}

