/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.gui.config;

import com.momosoftworks.coldsweat.client.event.TooltipHandler;
import com.momosoftworks.coldsweat.client.gui.config.AbstractConfigPage;
import com.momosoftworks.coldsweat.client.gui.config.pages.ConfigPageDifficulty;
import com.momosoftworks.coldsweat.client.gui.config.pages.ConfigPageFour;
import com.momosoftworks.coldsweat.client.gui.config.pages.ConfigPageOne;
import com.momosoftworks.coldsweat.client.gui.config.pages.ConfigPageThree;
import com.momosoftworks.coldsweat.client.gui.config.pages.ConfigPageTwo;
import com.momosoftworks.coldsweat.config.spec.ClientSettingsConfig;
import com.momosoftworks.coldsweat.core.network.message.SyncConfigSettingsMessage;
import com.momosoftworks.coldsweat.core.network.message.SyncPreferencesMessage;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.serialization.RegistryHelper;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(value={Dist.CLIENT})
public class ConfigScreen {
    public static final int TITLE_HEIGHT = 16;
    public static final int BOTTOM_BUTTON_HEIGHT_OFFSET = 26;
    public static final int OPTION_SIZE = 25;
    public static final int BOTTOM_BUTTON_WIDTH = 150;
    public static Minecraft MC = Minecraft.getInstance();
    public static DecimalFormat TWO_PLACES = new DecimalFormat("#.##");
    public static boolean IS_MOUSE_DOWN = false;
    public static int MOUSE_X = 0;
    public static int MOUSE_Y = 0;
    static List<Function<Screen, AbstractConfigPage>> PAGES = new ArrayList<Function>(Arrays.asList(ConfigPageOne::new, ConfigPageTwo::new, ConfigPageThree::new, ConfigPageFour::new));
    public static int FIRST_PAGE = 0;
    public static int LAST_PAGE = PAGES.size() - 1;
    public static int CURRENT_PAGE = 0;
    public static final Supplier<Integer> SHIFT_AMOUNT = () -> TooltipHandler.isShiftDown() ? (Screen.hasControlDown() ? 100 : 10) : 1;

    public static Screen getPage(int index, Screen parentScreen) {
        return PAGES.get(CSMath.clamp(index, FIRST_PAGE, LAST_PAGE)).apply(parentScreen);
    }

    public static void saveConfig() {
        RegistryAccess registryAccess = RegistryHelper.getRegistryAccess();
        if (Minecraft.getInstance().player != null) {
            PacketDistributor.sendToServer((CustomPacketPayload)new SyncConfigSettingsMessage(registryAccess), (CustomPacketPayload[])new CustomPacketPayload[0]);
            PacketDistributor.sendToServer((CustomPacketPayload)SyncPreferencesMessage.create(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        ClientSettingsConfig.writeAndSave();
    }

    @SubscribeEvent
    public static void onClicked(ScreenEvent.MouseButtonPressed.Pre event) {
        if (event.getButton() == 0 && Minecraft.getInstance().screen instanceof ConfigPageDifficulty) {
            IS_MOUSE_DOWN = true;
        }
    }

    @SubscribeEvent
    public static void onReleased(ScreenEvent.MouseButtonReleased.Pre event) {
        if (event.getButton() == 0 && Minecraft.getInstance().screen instanceof ConfigPageDifficulty) {
            IS_MOUSE_DOWN = false;
        }
    }
}

