/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.gui.config.pages;

import com.mojang.blaze3d.systems.RenderSystem;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.client.gui.config.ConfigScreen;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;

public class ConfigPageDifficulty
extends Screen {
    private static final String BLUE = ChatFormatting.BLUE.toString();
    private static final String RED = ChatFormatting.RED.toString();
    private static final String YEL = ChatFormatting.YELLOW.toString();
    private static final String CLEAR = ChatFormatting.RESET.toString();
    private static final String BOLD = ChatFormatting.BOLD.toString();
    private static final String U_LINE = ChatFormatting.UNDERLINE.toString();
    private static final List<Component> SUPER_EASY_DESCRIPTION = ConfigPageDifficulty.generateDescription(ConfigSettings.Difficulty.SUPER_EASY);
    private static final List<Component> EASY_DESCRIPTION = ConfigPageDifficulty.generateDescription(ConfigSettings.Difficulty.EASY);
    private static final List<Component> NORMAL_DESCRIPTION = ConfigPageDifficulty.generateDescription(ConfigSettings.Difficulty.NORMAL);
    private static final List<Component> HARD_DESCRIPTION = ConfigPageDifficulty.generateDescription(ConfigSettings.Difficulty.HARD);
    private static final List<Component> CUSTOM_DESCRIPTION = Collections.singletonList(Component.translatable((String)"cold_sweat.config.difficulty.description.custom"));
    static final ResourceLocation CONFIG_BUTTONS_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/gui/screen/config_gui.png");
    private final Screen parentScreen;

    public ConfigPageDifficulty(Screen parentScreen) {
        super((Component)Component.translatable((String)"cold_sweat.config.section.difficulty"));
        this.parentScreen = parentScreen;
    }

    public static List<Component> getListFor(ConfigSettings.Difficulty difficulty) {
        return switch (difficulty) {
            case ConfigSettings.Difficulty.SUPER_EASY -> SUPER_EASY_DESCRIPTION;
            case ConfigSettings.Difficulty.EASY -> EASY_DESCRIPTION;
            case ConfigSettings.Difficulty.NORMAL -> NORMAL_DESCRIPTION;
            case ConfigSettings.Difficulty.HARD -> HARD_DESCRIPTION;
            default -> CUSTOM_DESCRIPTION;
        };
    }

    private static List<Component> generateDescription(ConfigSettings.Difficulty difficulty) {
        return List.of(Component.translatable((String)"cold_sweat.config.difficulty.description.min_temp", (Object[])new Object[]{ConfigPageDifficulty.getTemperatureString((Double)difficulty.getSetting(ColdSweat.createKey("min_temp")), BLUE)}), Component.translatable((String)"cold_sweat.config.difficulty.description.max_temp", (Object[])new Object[]{ConfigPageDifficulty.getTemperatureString((Double)difficulty.getSetting(ColdSweat.createKey("max_temp")), RED)}), ConfigPageDifficulty.getRateComponent(difficulty), Component.translatable((String)("cold_sweat.config.difficulty.description.world_temp_" + ((Boolean)difficulty.getSetting(ColdSweat.createKey("require_thermometer")) != false ? "off" : "on")), (Object[])new Object[]{BOLD + U_LINE, CLEAR}), Component.translatable((String)("cold_sweat.config.difficulty.description.potions_" + ((Boolean)difficulty.getSetting(ColdSweat.createKey("ice_resistance_enabled")) != false ? "on" : "off")), (Object[])new Object[]{BOLD + U_LINE, CLEAR}));
    }

    private static String getTemperatureString(double temp, String color) {
        DecimalFormat df = new DecimalFormat("#.##");
        return color + df.format(Temperature.convert(temp, Temperature.Units.MC, Temperature.Units.F, true)) + CLEAR + " \u00b0F / " + color + df.format(Temperature.convert(temp, Temperature.Units.MC, Temperature.Units.C, true)) + CLEAR + " \u00b0C";
    }

    private static Component getRateComponent(ConfigSettings.Difficulty difficulty) {
        double rate = (Double)difficulty.getSetting(ColdSweat.createKey("temp_rate"));
        String key = rate < 1.0 ? "cold_sweat.config.difficulty.description.rate.decrease" : (rate == 1.0 ? "cold_sweat.config.difficulty.description.rate.normal" : "cold_sweat.config.difficulty.description.rate.increase");
        return rate == 1.0 ? Component.translatable((String)key) : Component.translatable((String)key, (Object[])new Object[]{YEL + Math.abs(1.0 - rate) * 100.0 + "%" + CLEAR});
    }

    public static int getDifficultyColor(ConfigSettings.Difficulty difficulty) {
        return switch (difficulty) {
            case ConfigSettings.Difficulty.SUPER_EASY -> 0xFFFFFF;
            case ConfigSettings.Difficulty.EASY -> 16768882;
            case ConfigSettings.Difficulty.NORMAL -> 16755024;
            case ConfigSettings.Difficulty.HARD -> 16731202;
            default -> 10631158;
        };
    }

    public int index() {
        return -1;
    }

    protected void init() {
        this.addRenderableWidget((GuiEventListener)new Button.Builder(CommonComponents.GUI_DONE, button -> this.onClose()).pos(this.width / 2 - 75, this.height - 26).size(150, 20).createNarration(title -> (MutableComponent)title.get()).build());
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        ConfigSettings.Difficulty difficulty = ConfigSettings.DIFFICULTY.get();
        ArrayList<MutableComponent> descLines = new ArrayList<MutableComponent>();
        descLines.add(Component.literal((String)""));
        int longestLine = 0;
        for (Component text : ConfigPageDifficulty.getListFor(difficulty)) {
            MutableComponent descLine = Component.literal((String)(" \u2022 " + text.getString() + " "));
            descLines.add(descLine);
            descLines.add(Component.literal((String)""));
            int lineWidth = this.font.width((FormattedText)descLine);
            if (lineWidth <= longestLine) continue;
            longestLine = lineWidth;
        }
        int middleX = this.width / 2;
        int middleY = this.height / 2;
        graphics.renderTooltip(this.font, descLines, ItemStack.EMPTY.getTooltipImage(), middleX - longestLine / 2 - 10, middleY - 16);
        ConfigScreen.MOUSE_X = mouseX;
        ConfigScreen.MOUSE_Y = mouseY;
        graphics.drawCenteredString(this.font, this.title.getString(), this.width / 2, 16, 0xFFFFFF);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CONFIG_BUTTONS_LOCATION);
        graphics.blit(CONFIG_BUTTONS_LOCATION, this.width / 2 - 76, this.height / 2 - 53, 12, this.isMouseOverSlider(mouseX, mouseY) ? 134 : 128, 152, 6);
        graphics.blit(CONFIG_BUTTONS_LOCATION, this.width / 2 - 78 + difficulty.ordinal() * 37, this.height / 2 - 58, this.isMouseOverSlider(mouseX, mouseY) ? 0 : 6, 128, 6, 16);
        Component difficultyName = ConfigSettings.Difficulty.getFormattedName(difficulty);
        graphics.drawString(this.font, difficultyName, this.width / 2 - this.font.width((FormattedText)difficultyName) / 2, this.height / 2 - 84, ConfigPageDifficulty.getDifficultyColor(difficulty), true);
    }

    public void onClose() {
        super.onClose();
        ConfigSettings.DIFFICULTY.get().load();
        ConfigScreen.saveConfig();
        ConfigScreen.MC.setScreen(this.parentScreen);
    }

    boolean isMouseOverSlider(double mouseX, double mouseY) {
        return mouseX >= (double)this.width / 2.0 - 80.0 && mouseX <= (double)this.width / 2.0 + 80.0 && mouseY >= (double)this.height / 2.0 - 67.0 && mouseY <= (double)this.height / 2.0 - 35.0;
    }

    public void tick() {
        double x = ConfigScreen.MOUSE_X;
        double y = ConfigScreen.MOUSE_Y;
        if (ConfigScreen.IS_MOUSE_DOWN && this.isMouseOverSlider(x, y)) {
            ConfigSettings.Difficulty newDifficulty = ConfigSettings.Difficulty.values()[(int)Math.round(CSMath.blend(0.0, 4.0, x, (double)this.width / 2.0 - 76.0, (double)this.width / 2.0 + 76.0))];
            if (newDifficulty != ConfigSettings.DIFFICULTY.get()) {
                ConfigScreen.MC.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvent.createFixedRangeEvent((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"block.note_block.hat"), (float)1.8f), (float)0.5f));
            }
            ConfigSettings.DIFFICULTY.set(newDifficulty);
        }
    }
}

