/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.particle;

import com.momosoftworks.coldsweat.client.particle.ParticleUtil;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class HearthParticle
extends TextureSheetParticle {
    private SpriteSet ageSprite;

    protected HearthParticle(ClientLevel world, double x, double y, double z, double vx, double vy, double vz, SpriteSet spriteSet) {
        super(world, x, y, z);
        float size = 0.5f;
        this.ageSprite = spriteSet;
        this.alpha = 0.0f;
        this.setSize(size, size);
        this.scale(3.0f + (float)Math.random());
        this.lifetime = 40;
        this.gravity = -0.01f;
        this.hasPhysics = true;
        this.setParticleSpeed(vx, vy, vz);
        this.setSpriteFromAge(spriteSet);
    }

    public ParticleRenderType getRenderType() {
        return ParticleUtil.PARTICLE_SHEET_TRANSPARENT;
    }

    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.ageSprite);
        if (this.age < 10) {
            this.alpha += 0.02f;
        } else if (this.age > 32) {
            this.alpha -= 0.02f;
        }
        if ((double)this.alpha <= 0.06 && this.age > 10) {
            this.remove();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Factory(SpriteSet sprite) implements ParticleProvider<SimpleParticleType>
    {
        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new HearthParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, this.sprite);
        }
    }
}

