/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.renderer.animation;

import com.momosoftworks.coldsweat.client.renderer.animation.Keyframe;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.geom.ModelPart;

public class Animation {
    ArrayList<Keyframe> posKeyframes;
    ArrayList<Keyframe> rotKeyframes;
    float duration;
    float offsetAmount;
    String partName;

    public Animation(String partName, float durationSecs, List<Keyframe> posFrames, List<Keyframe> rotFrames) {
        this.partName = partName;
        this.duration = durationSecs;
        this.posKeyframes = new ArrayList<Keyframe>(posFrames);
        this.rotKeyframes = new ArrayList<Keyframe>(rotFrames);
    }

    public Animation setRotations(float time, ModelPart part, boolean offset) {
        if (this.rotKeyframes.isEmpty()) {
            return this;
        }
        Keyframe next = this.rotKeyframes.get(0);
        Keyframe prev = this.rotKeyframes.get(this.rotKeyframes.size() - 1);
        float animProgress = time % this.duration;
        for (int i = 0; i < this.rotKeyframes.size(); ++i) {
            Keyframe frame = this.rotKeyframes.get(i);
            if (!(frame.time >= animProgress)) continue;
            next = frame;
            prev = this.rotKeyframes.get(i == 0 ? this.rotKeyframes.size() - 1 : i - 1);
            break;
        }
        part.xRot = CSMath.toRadians(CSMath.blend(prev.x, next.x, animProgress, prev.time, next.time)) + (offset ? part.xRot : 0.0f);
        part.yRot = CSMath.toRadians(CSMath.blend(prev.y, next.y, animProgress, prev.time, next.time)) + (offset ? part.yRot : 0.0f);
        part.zRot = CSMath.toRadians(CSMath.blend(prev.z, next.z, animProgress, prev.time, next.time)) + (offset ? part.zRot : 0.0f);
        return this;
    }

    public Animation setPositions(float time, ModelPart part, boolean offset) {
        if (this.posKeyframes.isEmpty()) {
            return this;
        }
        Keyframe next = this.posKeyframes.get(0);
        Keyframe prev = this.posKeyframes.get(this.posKeyframes.size() - 1);
        float animProgress = (time + this.offsetAmount) % this.duration;
        for (int i = 0; i < this.posKeyframes.size(); ++i) {
            Keyframe frame = this.posKeyframes.get(i);
            if (!(frame.time >= animProgress)) continue;
            next = frame;
            prev = this.posKeyframes.get(i == 0 ? this.posKeyframes.size() - 1 : i - 1);
            break;
        }
        part.x = CSMath.blend(prev.x, next.x, animProgress, prev.time, next.time) + (offset ? part.x : 0.0f);
        part.y = CSMath.blend(prev.y, next.y, animProgress, prev.time, next.time) + (offset ? part.y : 0.0f);
        part.z = CSMath.blend(prev.z, next.z, animProgress, prev.time, next.time) + (offset ? part.z : 0.0f);
        return this;
    }

    public Animation offset(float amount) {
        this.offsetAmount = amount;
        return this;
    }

    public void addKeyframe(Keyframe keyframe, KeyframeType type) {
        if (type == KeyframeType.POSITION) {
            this.posKeyframes.add(keyframe);
        } else {
            this.rotKeyframes.add(keyframe);
        }
    }

    public String toString() {
        return "Animation{\n    partName: %s,\n    duration: %s,\n    offset: %s,\n    positions:\n    {\n        %s,\n    }\n    rotations\n    {\n        %s,\n    }\n}".formatted(this.partName, Float.valueOf(this.duration), Float.valueOf(this.offsetAmount), this.posKeyframes, this.rotKeyframes);
    }

    public static enum KeyframeType {
        POSITION,
        ROTATION;

    }
}

