/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.block;

import com.momosoftworks.coldsweat.common.block.BoilerBlock;
import com.momosoftworks.coldsweat.common.block.IceboxBlock;
import com.momosoftworks.coldsweat.common.blockentity.HearthBlockEntity;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.ModBlockEntities;
import com.momosoftworks.coldsweat.core.init.ModBlocks;
import com.momosoftworks.coldsweat.util.item.ItemStackHelper;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class HearthBottomBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty COOLING = BooleanProperty.create((String)"cooling");
    public static final BooleanProperty HEATING = BooleanProperty.create((String)"heating");
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final BooleanProperty FROSTED = BooleanProperty.create((String)"frosted");
    public static final BooleanProperty SMART = BooleanProperty.create((String)"smart");

    public static BlockBehaviour.Properties getProperties() {
        return BlockBehaviour.Properties.of().sound(SoundType.STONE).destroyTime(2.0f).explosionResistance(10.0f).requiresCorrectToolForDrops().isRedstoneConductor((state, level, pos) -> false).lightLevel(state -> (Boolean)state.getValue((Property)LIT) != false ? 13 : 0).noOcclusion();
    }

    public static Item.Properties getItemProperties() {
        return new Item.Properties().stacksTo(1);
    }

    public HearthBottomBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)COOLING, (Comparable)Boolean.valueOf(false))).setValue((Property)HEATING, (Comparable)Boolean.valueOf(false))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)FROSTED, (Comparable)Boolean.valueOf(false))).setValue((Property)SMART, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return type == ModBlockEntities.HEARTH.value() ? HearthBlockEntity::tickSelf : null;
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new HearthBlockEntity(pos, state);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult rayTraceResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof HearthBlockEntity) {
            HearthBlockEntity te = (HearthBlockEntity)blockEntity;
            player.openMenu((MenuProvider)te, pos);
        }
        return super.useWithoutItem(state, level, pos, player, rayTraceResult);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof HearthBlockEntity) {
            HearthBlockEntity te = (HearthBlockEntity)blockEntity;
            if (player.getItemInHand(hand).getItem() == Items.BUCKET) {
                int hearthFuel;
                Vec3 clickedPos = rayTraceResult.getLocation();
                Vec3i lavaSideOffset = ((Direction)state.getValue((Property)FACING)).getClockWise().getNormal();
                Vec3 lavaSidePos = CSMath.getCenterPos(pos).add((double)lavaSideOffset.getX() * 0.65, (double)lavaSideOffset.getY() * 0.65, (double)lavaSideOffset.getZ() * 0.65);
                Vec3i waterSideOffset = ((Direction)state.getValue((Property)FACING)).getCounterClockWise().getNormal();
                Vec3 waterSidePos = CSMath.getCenterPos(pos).add((double)waterSideOffset.getX() * 0.65, (double)waterSideOffset.getY() * 0.65, (double)waterSideOffset.getZ() * 0.65);
                boolean isLava = clickedPos.distanceTo(lavaSidePos) < clickedPos.distanceTo(waterSidePos);
                Vec3 sidePos = isLava ? lavaSidePos : waterSidePos;
                BucketItem filledBucket = isLava ? (BucketItem)Items.LAVA_BUCKET : (BucketItem)Items.WATER_BUCKET;
                int itemFuel = Math.abs(te.getItemFuel(filledBucket.getDefaultInstance()));
                int n = hearthFuel = isLava ? te.getHotFuel() : te.getColdFuel();
                if ((double)hearthFuel >= (double)itemFuel * 0.99 && rayTraceResult.getLocation().distanceTo(sidePos) < 0.4 && itemFuel > 0) {
                    if (isLava) {
                        te.setHotFuel(hearthFuel - itemFuel);
                    } else {
                        te.setColdFuel(hearthFuel - itemFuel);
                    }
                    stack.shrink(1);
                    player.addItem(filledBucket.getDefaultInstance());
                    ItemStackHelper.playBucketEmptySound(stack, player, (LevelAccessor)level, pos);
                    return ItemInteractionResult.SUCCESS;
                }
                player.openMenu((MenuProvider)te, pos);
            } else {
                int hearthFuel;
                int itemFuel = te.getItemFuel(stack);
                int n = hearthFuel = itemFuel > 0 ? te.getHotFuel() : te.getColdFuel();
                if (itemFuel != 0 && (double)hearthFuel + (double)Math.abs(itemFuel) * 0.75 < (double)te.getMaxFuel()) {
                    if (!player.isCreative()) {
                        if (stack.hasCraftingRemainingItem()) {
                            ItemStack container = stack.getCraftingRemainingItem();
                            player.setItemInHand(hand, container);
                        } else {
                            stack.shrink(1);
                        }
                    }
                    te.addFuel(itemFuel);
                    level.playSound(null, pos, itemFuel > 0 ? SoundEvents.BUCKET_EMPTY_LAVA : SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 0.9f + new Random().nextFloat() * 0.2f);
                } else {
                    player.openMenu((MenuProvider)te, pos);
                }
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        HearthBlockEntity hearth = (HearthBlockEntity)level.getBlockEntity(pos);
        if (hearth != null && hearth.isUsingColdFuel()) {
            IceboxBlock.createMistParticles(level, pos);
        }
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            BoilerBlock.createFlameParticles(level, pos, state, 0.6, 0.1);
        }
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState lastState, boolean p_60570_) {
        level.setBlock(pos.above(), WorldHelper.waterlog(((Block)ModBlocks.HEARTH_TOP.value()).defaultBlockState(), level, pos.above()), 3);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, level, pos, neighborBlock, fromPos, isMoving);
        if (level.getBlockState(pos.above()).getBlock() != ModBlocks.HEARTH_TOP.value()) {
            this.destroy((LevelAccessor)level, pos, state);
        } else {
            HearthBlockEntity hearth = (HearthBlockEntity)level.getBlockEntity(pos);
            if (hearth != null) {
                hearth.checkInputSignal();
                hearth.checkForStateChange();
            }
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity tileentity;
            if (level.getBlockState(pos.above()).getBlock() == ModBlocks.HEARTH_TOP.value()) {
                level.destroyBlock(pos.above(), false);
            }
            if ((tileentity = level.getBlockEntity(pos)) instanceof HearthBlockEntity) {
                Containers.dropContents((Level)level, (BlockPos)pos, (Container)((HearthBlockEntity)tileentity));
            }
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public BlockState rotate(BlockState state, Rotation direction) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)direction.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, COOLING, HEATING, LIT, FROSTED, SMART});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        return level.getBlockState(context.getClickedPos().above()).canBeReplaced() ? (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)SMART, (Comparable)ConfigSettings.SMART_HEARTH.get()) : null;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return direction != null && direction.getAxis() != Direction.Axis.Y && direction != ((Direction)state.getValue((Property)FACING)).getOpposite();
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState pState, Level level, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)level.getBlockEntity(pos));
    }
}

