/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.block;

import com.momosoftworks.coldsweat.common.blockentity.ThermolithBlockEntity;
import com.momosoftworks.coldsweat.core.init.ModBlockEntities;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.HashMap;
import java.util.Map;
import java.util.function.ToIntFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ThermolithBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    private static final Map<Direction, VoxelShape> SHAPES = new HashMap<Direction, VoxelShape>();

    public ThermolithBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        ThermolithBlock.calculateFacingShapes(Shapes.or((VoxelShape)Block.box((double)4.0, (double)0.0, (double)5.0, (double)12.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)6.0, (double)5.0)));
    }

    public static BlockBehaviour.Properties getProperties() {
        return BlockBehaviour.Properties.of().sound(SoundType.GILDED_BLACKSTONE).strength(2.0f).explosionResistance(10.0f).noOcclusion().dynamicShape().lightLevel(ThermolithBlock.getLightValueLit(5)).isRedstoneConductor((state, level, pos) -> true).requiresCorrectToolForDrops();
    }

    private static ToIntFunction<BlockState> getLightValueLit(int lightValue) {
        return state -> (Boolean)state.getValue((Property)BlockStateProperties.POWERED) != false ? lightValue : 0;
    }

    public static Item.Properties getItemProperties() {
        return new Item.Properties().stacksTo(64);
    }

    static void calculateFacingShapes(VoxelShape shape) {
        for (Direction direction : Direction.values()) {
            SHAPES.put(direction, CSMath.rotateShape(direction, shape));
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.getValue((Property)FACING));
    }

    public BlockState rotate(BlockState state, Rotation direction) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)direction.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, POWERED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ThermolithBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return type == ModBlockEntities.THERMOLITH.value() ? ThermolithBlockEntity::tick : null;
    }

    public int getSignal(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (direction == ((Direction)state.getValue((Property)FACING)).getOpposite() && blockEntity instanceof ThermolithBlockEntity) {
            ThermolithBlockEntity thermolith = (ThermolithBlockEntity)blockEntity;
            return thermolith.getSignal();
        }
        return 0;
    }

    public int getDirectSignal(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return state.getSignal(level, pos, direction);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return direction == ((Direction)state.getValue((Property)FACING)).getOpposite();
    }

    public boolean isSignalSource(BlockState pState) {
        return true;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        super.onRemove(state, level, pos, newState, moved);
        ThermolithBlock.updateFacingNeighbors(level, state, pos);
    }

    public static void updateFacingNeighbors(Level level, BlockState state, BlockPos pos) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        level.updateNeighborsAt(pos, state.getBlock());
        level.updateNeighborsAt(pos.relative(facing), level.getBlockState(pos.relative(facing)).getBlock());
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        ParticleStatus status = (ParticleStatus)Minecraft.getInstance().options.particles().get();
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue() && status != ParticleStatus.MINIMAL) {
            Direction direction = (Direction)state.getValue((Property)FACING);
            boolean xAxis = direction.getAxis() == Direction.Axis.X;
            float headLength = 0.25f;
            float offset = xAxis ? (direction.getStepX() < 0 ? headLength : -0.05f) : (direction.getStepZ() < 0 ? headLength : -0.05f);
            double pY = Math.random() * 0.625 + 0.375;
            double pX = xAxis ? (double)random.nextInt(2) * 0.8 + (double)offset : 0.5;
            double pZ = xAxis ? 0.5 : (double)random.nextInt(2) * 0.8 + (double)offset;
            level.addParticle((ParticleOptions)new DustParticleOptions(Vec3.fromRGB24((int)4895036).toVector3f(), random.nextFloat() * 0.5f + 0.5f), (double)pos.getX() + pX, (double)pos.getY() + pY, (double)pos.getZ() + pZ, 0.0, 0.0, 0.0);
            if (random.nextDouble() < 0.5) {
                float rX = xAxis ? (float)Math.random() * 0.8f + offset : 0.5f;
                float rZ = xAxis ? 0.5f : (float)Math.random() * 0.8f + offset;
                level.addParticle((ParticleOptions)new DustParticleOptions(Vec3.fromRGB24((int)4895036).toVector3f(), random.nextFloat() * 0.5f + 0.5f), (double)((float)pos.getX() + rX), (double)pos.getY() + 1.05, (double)((float)pos.getZ() + rZ), 0.0, 0.0, 0.0);
            }
        }
    }
}

