/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.event;

import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.core.network.message.DisableHearthParticlesMessage;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber
public class HearthSaveDataHandler {
    public static final Set<Pair<BlockPos, ResourceLocation>> HEARTH_POSITIONS = new HashSet<Pair<BlockPos, ResourceLocation>>();
    public static final Set<Pair<BlockPos, ResourceLocation>> DISABLED_HEARTHS = new HashSet<Pair<BlockPos, ResourceLocation>>();

    public static CompoundTag serializeDisabledHearths() {
        CompoundTag tag = new CompoundTag();
        ListTag disabledHearths = new ListTag();
        for (Pair<BlockPos, ResourceLocation> pair : DISABLED_HEARTHS) {
            CompoundTag hearthData = new CompoundTag();
            hearthData.putLong("Pos", ((BlockPos)pair.getFirst()).asLong());
            hearthData.putString("Level", ((ResourceLocation)pair.getSecond()).toString());
            disabledHearths.add((Object)hearthData);
        }
        tag.put("DisabledHearths", (Tag)disabledHearths);
        return tag;
    }

    public static void deserializeDisabledHearths(CompoundTag disabledHearths) {
        DISABLED_HEARTHS.clear();
        for (Tag tag : disabledHearths.getList("DisabledHearths", 10)) {
            CompoundTag hearthData = (CompoundTag)tag;
            DISABLED_HEARTHS.add((Pair<BlockPos, ResourceLocation>)Pair.of((Object)BlockPos.of((long)hearthData.getLong("Pos")), (Object)ResourceLocation.parse((String)hearthData.getString("Level"))));
        }
    }

    @SubscribeEvent
    public static void loadDisabledHearths(EntityJoinLevelEvent event) {
        Entity entity;
        if (!event.getEntity().level().isClientSide && (entity = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            CompoundTag disabledHearths = new CompoundTag();
            disabledHearths.put("DisabledHearths", (Tag)player.getPersistentData().getList("DisabledHearths", 10));
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new DisableHearthParticlesMessage(disabledHearths), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void transferDisabledHearths(PlayerEvent.Clone event) {
        if (!event.getEntity().level().isClientSide()) {
            ListTag disabledHearths = event.getOriginal().getPersistentData().getList("DisabledHearths", 10);
            event.getEntity().getPersistentData().put("DisabledHearths", (Tag)disabledHearths);
        }
    }
}

