/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.compat.kubejs.event.builder;

import com.momosoftworks.coldsweat.data.codec.configuration.FuelData;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.requirement.ItemRequirement;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.serialization.RegistryHelper;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class FuelBuilderJS {
    public double fuel = 0.0;
    public NegatableList<ItemRequirement> itemPredicate = new NegatableList();

    public FuelBuilderJS items(String ... items) {
        List<Item> itemList = RegistryHelper.mapBuiltinRegistryTagList(BuiltInRegistries.ITEM, ConfigHelper.getItems(items));
        if (itemList.isEmpty() && items.length != 0) {
            this.itemPredicate.add(ItemRequirement.NONE, true);
        } else {
            this.itemPredicate.add(new ItemRequirement(itemList, null), false);
        }
        return this;
    }

    public FuelBuilderJS fuel(double temperature) {
        this.fuel = temperature;
        return this;
    }

    public FuelBuilderJS itemPredicate(Predicate<ItemStack> itemPredicate) {
        this.itemPredicate.add(new ItemRequirement(itemPredicate), false);
        return this;
    }

    public FuelData build(FuelData.FuelType fuelType) {
        FuelData data = new FuelData(this.itemPredicate, fuelType, this.fuel);
        data.setConfigType(ConfigData.Type.KUBEJS);
        return data;
    }
}

