/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.event;

import com.momosoftworks.coldsweat.ColdSweat;
import java.util.ArrayList;
import java.util.List;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber
public class TaskScheduler {
    private static final List<QueueEntry> SERVER_SCHEDULE = new ArrayList<QueueEntry>(32);
    private static final List<QueueEntry> CLIENT_SCHEDULE = new ArrayList<QueueEntry>(32);

    @SubscribeEvent
    public static void tickClient(ClientTickEvent.Pre event) {
        TaskScheduler.tickScheduledTasks(CLIENT_SCHEDULE);
    }

    @SubscribeEvent
    public static void tickServer(ServerTickEvent.Pre event) {
        TaskScheduler.tickScheduledTasks(SERVER_SCHEDULE);
    }

    private static void tickScheduledTasks(List<QueueEntry> schedule) {
        if (!schedule.isEmpty()) {
            for (int i = 0; i < schedule.size(); ++i) {
                QueueEntry entry = schedule.get(i);
                int ticks = entry.time;
                if (ticks <= 0) {
                    try {
                        entry.task.run();
                    }
                    catch (Exception e) {
                        ColdSweat.LOGGER.error("Error while running scheduled task", (Throwable)e);
                        throw e;
                    }
                    schedule.remove(i);
                    --i;
                    continue;
                }
                entry.time = ticks - 1;
            }
        }
    }

    public static void scheduleServer(Runnable task, int delay) {
        SERVER_SCHEDULE.add(new QueueEntry(task, delay));
    }

    public static void scheduleClient(Runnable task, int delay) {
        CLIENT_SCHEDULE.add(new QueueEntry(task, delay));
    }

    public static void schedule(Runnable task, int delay) {
        TaskScheduler.scheduleServer(task, delay);
        TaskScheduler.scheduleClient(task, delay);
    }

    static class QueueEntry {
        private final Runnable task;
        private int time;

        public QueueEntry(Runnable task, int time) {
            this.task = task;
            this.time = time;
        }
    }
}

