/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.impl;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.momosoftworks.coldsweat.api.annotation.Internal;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.data.ModRegistries;
import com.momosoftworks.coldsweat.data.codec.util.ExtraCodecs;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;

public abstract class ConfigData {
    protected UUID id = UUID.randomUUID();
    protected Type configType = Type.JSON;
    protected NegatableList<String> requiredMods;
    protected ResourceKey registryKey;
    protected static final Codec<NegatableList<String>> REQUIRED_MODS_CODEC = NegatableList.listCodec(Codec.STRING);
    protected static final Codec<UUID> UUID_CODEC = Codec.STRING.xmap(UUID::fromString, UUID::toString);
    protected static final Codec<Type> TYPE_CODEC = Type.CODEC;

    public ConfigData(NegatableList<String> requiredMods, Type configType, UUID id) {
        this.requiredMods = requiredMods;
        this.configType = configType;
        this.id = id;
    }

    public ConfigData(NegatableList<String> requiredMods) {
        this.requiredMods = requiredMods;
    }

    public abstract <T> Codec<T> getCodec();

    protected static <T extends ConfigData> Codec<T> createCodec(final MapCodec<T> child) {
        return new MapCodec<T>(){

            public <O> RecordBuilder<O> encode(T input, DynamicOps<O> ops, RecordBuilder<O> prefix) {
                RecordBuilder builder = child.encode(input, ops, prefix);
                builder.add("required_mods", ((ConfigData)input).requiredMods(), REQUIRED_MODS_CODEC).add("config_type", (Object)((ConfigData)input).configType(), TYPE_CODEC).add("id", (Object)((ConfigData)input).uuid(), UUID_CODEC);
                if (((ConfigData)input).registryKey != null) {
                    builder.add("registry_name", (Object)((ConfigData)input).registryKey().registry(), (Encoder)ResourceLocation.CODEC);
                    builder.add("registry_key", (Object)((ConfigData)input).registryKey().location(), (Encoder)ResourceLocation.CODEC);
                }
                return builder;
            }

            public <O> DataResult<T> decode(DynamicOps<O> ops, MapLike<O> input) {
                return child.decode(ops, input).flatMap(instance -> {
                    instance.requiredMods = ConfigData.decodeFromMap("required_mods", ops, input, REQUIRED_MODS_CODEC, new NegatableList());
                    instance.configType = ConfigData.decodeFromMap("config_type", ops, input, TYPE_CODEC, Type.JSON);
                    instance.id = ConfigData.decodeFromMap("id", ops, input, UUID_CODEC, null);
                    ResourceLocation registry = ConfigData.decodeFromMap("registry_name", ops, input, ResourceLocation.CODEC, null);
                    ResourceLocation key = ConfigData.decodeFromMap("registry_key", ops, input, ResourceLocation.CODEC, null);
                    if (registry != null && key != null) {
                        instance.registryKey = ResourceKey.create((ResourceKey)ResourceKey.createRegistryKey((ResourceLocation)registry), (ResourceLocation)key);
                    }
                    return DataResult.success((Object)instance);
                });
            }

            public <O> Stream<O> keys(DynamicOps<O> ops) {
                return Stream.of("required_mods", "config_type", "id").map(arg_0 -> ops.createString(arg_0));
            }
        }.codec();
    }

    private static <T, O> T decodeFromMap(String key, DynamicOps<O> ops, MapLike<O> input, Codec<T> codec, T defaultValue) {
        return (T)codec.decode(ops, input.get(key)).result().map(Pair::getFirst).orElse(defaultValue);
    }

    public UUID uuid() {
        if (this.id == null) {
            this.id = UUID.randomUUID();
        }
        return this.id;
    }

    public Type configType() {
        return this.configType;
    }

    public NegatableList<String> requiredMods() {
        return this.requiredMods;
    }

    public <T> ResourceKey<T> registryKey() {
        return this.registryKey;
    }

    public <D extends ConfigData> Optional<? extends Holder<D>> getHolder(RegistryAccess registryAccess) {
        if (this.registryKey == null) {
            return Optional.empty();
        }
        ResourceKey<? extends Registry<? extends ConfigData>> regKey = ModRegistries.getRegistryKey(this.registryKey().registry());
        Registry registry = registryAccess.registryOrThrow(regKey);
        return registry.getHolder(this.registryKey());
    }

    @Internal
    public void setId(UUID id) {
        this.id = id;
    }

    @Internal
    public void setConfigType(Type configType) {
        this.configType = configType;
    }

    @Internal
    public void setRegistryKey(ResourceKey<? extends ConfigData> registryKey) {
        this.registryKey = registryKey;
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.getCodec().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("");
    }

    public boolean areRequiredModsLoaded() {
        return this.requiredMods.test(mod -> mod.equals("minecraft") || CompatManager.modLoaded(mod));
    }

    public boolean equals(Object obj) {
        ConfigData data;
        return obj instanceof ConfigData && (data = (ConfigData)obj).requiredMods().equals(this.requiredMods());
    }

    public static enum Type implements StringRepresentable
    {
        TOML("toml"),
        JSON("json"),
        KUBEJS("kubejs");

        public static final Codec<Type> CODEC;
        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = ExtraCodecs.enumIgnoreCase((Enum[])Type.values());
        }
    }
}

