/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.util;

import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.momosoftworks.coldsweat.data.codec.util.AttributeCodecs;
import com.momosoftworks.coldsweat.util.math.FastMultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class AttributeModifierMap {
    public static final Codec<AttributeModifierMap> CODEC = Codec.unboundedMap((Codec)Attribute.CODEC, (Codec)AttributeCodecs.MODIFIER_CODEC.listOf()).xmap(AttributeModifierMap::new, map -> map.getMap().asMap().entrySet().stream().collect(HashMap::new, (mp, ent) -> mp.put((Holder)ent.getKey(), new ArrayList((Collection)ent.getValue())), HashMap::putAll));
    public static final StreamCodec<RegistryFriendlyByteBuf, AttributeModifierMap> STREAM_CODEC = ByteBufCodecs.fromCodecWithRegistries(CODEC);
    private final Multimap<Holder<Attribute>, AttributeModifier> map = new FastMultiMap<Holder<Attribute>, AttributeModifier>();

    public AttributeModifierMap() {
    }

    public AttributeModifierMap(Map<Holder<Attribute>, ?> attributeListMap) {
        attributeListMap.forEach((attribute, list) -> {
            if (list instanceof Collection) {
                this.map.putAll(attribute, (Iterable)((Collection)list));
            } else if (list instanceof AttributeModifier) {
                this.map.put(attribute, (Object)((AttributeModifier)list));
            }
        });
    }

    public AttributeModifierMap(Multimap<Holder<Attribute>, AttributeModifier> map) {
        this.map.putAll(map);
    }

    public AttributeModifierMap(AttributeModifierMap original) {
        this.map.putAll(original.map);
    }

    public void put(Holder<Attribute> attribute, AttributeModifier modifier) {
        this.map.put(attribute, (Object)modifier);
    }

    public Collection<AttributeModifier> get(Holder<Attribute> attribute) {
        return this.map.get(attribute);
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getMap() {
        return this.map;
    }

    public AttributeModifierMap putAll(AttributeModifierMap other) {
        this.map.putAll(other.map);
        return this;
    }

    public AttributeModifierMap putAll(Holder<Attribute> attribute, Collection<AttributeModifier> modifiers) {
        this.map.putAll(attribute, modifiers);
        return this;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public void clear() {
        this.map.clear();
    }

    public static AttributeModifierMap deserialize(CompoundTag tag) {
        return (AttributeModifierMap)((Pair)CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag).result().orElseThrow(() -> new IllegalArgumentException("Could not deserialize AttributeModifierMap"))).getFirst();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeModifierMap that = (AttributeModifierMap)obj;
        for (Map.Entry entry : this.map.asMap().entrySet()) {
            if (!that.map.containsKey(entry.getKey())) {
                return false;
            }
            Collection other = that.map.get((Object)((Holder)entry.getKey()));
            if (((Collection)entry.getValue()).size() != other.size()) {
                return false;
            }
            Iterator thatIterator = other.iterator();
            for (AttributeModifier modifier : (Collection)entry.getValue()) {
                if (!thatIterator.hasNext()) {
                    return false;
                }
                AttributeModifier thatModifier = (AttributeModifier)thatIterator.next();
                if (Double.compare(modifier.amount(), thatModifier.amount()) == 0 && modifier.operation() == thatModifier.operation() && modifier.id().equals((Object)thatModifier.id())) continue;
                return false;
            }
        }
        return true;
    }
}

