/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.serialization;

import com.mojang.datafixers.util.Either;
import com.momosoftworks.coldsweat.api.event.vanilla.ServerConfigsLoadedEvent;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.serialization.OptionalHolder;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;

public class RegistryHelper {
    private static RegistryAccess REGISTRY_ACCESS = null;
    private static final Field OWNER_FIELD = ObfuscationReflectionHelper.findField(Holder.Reference.class, (String)"owner");
    private static final Method BIND_KEY = ObfuscationReflectionHelper.findMethod(Holder.Reference.class, (String)"bindKey", (Class[])new Class[]{ResourceKey.class});
    private static final Method BIND_TAGS = ObfuscationReflectionHelper.findMethod(Holder.Reference.class, (String)"bindTags", (Class[])new Class[]{Collection.class});

    @Nullable
    public static <T> Registry<T> getRegistry(ResourceKey<Registry<T>> registry) {
        return CSMath.getIfNotNull(RegistryHelper.getRegistryAccess(), access -> access.registryOrThrow(registry), null);
    }

    @Nullable
    public static RegistryAccess getRegistryAccess() {
        return REGISTRY_ACCESS;
    }

    public static <T> List<T> mapBuiltinRegistryTagList(Registry<T> registry, NegatableList<Either<TagKey<T>, T>> eitherList) {
        ArrayList list = new ArrayList();
        if (registry == null) {
            return list;
        }
        for (Either<TagKey<T>, T> either : eitherList.requirements()) {
            either.ifLeft(tagKey -> {
                Optional tag = registry.getTag(tagKey);
                tag.ifPresent(tag1 -> list.addAll(tag1.stream().map(Holder::value).toList()));
            });
            either.ifRight(list::add);
        }
        for (Either<TagKey<T>, T> either : eitherList.exclusions()) {
            either.ifLeft(tagKey -> registry.getTag(tagKey).ifPresent(tag -> list.removeAll(tag.stream().map(Holder::value).toList())));
            either.ifRight(object -> list.remove(object));
        }
        return list;
    }

    public static <T> List<T> mapBuiltinRegistryTagList(Registry<T> registry, List<Either<TagKey<T>, T>> eitherList) {
        return RegistryHelper.mapBuiltinRegistryTagList(registry, new NegatableList<Either<TagKey<T>, T>>(eitherList));
    }

    public static <T> List<OptionalHolder<T>> mapRegistryTagList(ResourceKey<Registry<T>> registry, NegatableList<Either<TagKey<T>, OptionalHolder<T>>> eitherList, @Nullable RegistryAccess registryAccess) {
        Registry reg = registryAccess != null ? registryAccess.registryOrThrow(registry) : RegistryHelper.getRegistry(registry);
        ArrayList list = new ArrayList();
        if (reg == null) {
            return list;
        }
        for (Either<TagKey<T>, OptionalHolder<T>> either : eitherList.requirements()) {
            either.ifLeft(tagKey -> {
                Optional tag = reg.getTag(tagKey);
                tag.ifPresent(tag1 -> list.addAll(tag1.stream().map(OptionalHolder::ofHolder).toList()));
            });
            either.ifRight(list::add);
        }
        for (Either<TagKey<T>, OptionalHolder<T>> either : eitherList.exclusions()) {
            either.ifLeft(tagKey -> {
                Optional tag = reg.getTag(tagKey);
                tag.ifPresent(tag1 -> list.removeAll(tag1.stream().map(OptionalHolder::ofHolder).toList()));
            });
            either.ifRight(list::remove);
        }
        return list;
    }

    public static <T> List<OptionalHolder<T>> mapRegistryTagList(ResourceKey<Registry<T>> registry, List<Either<TagKey<T>, OptionalHolder<T>>> eitherList, @Nullable RegistryAccess registryAccess) {
        return RegistryHelper.mapRegistryTagList(registry, new NegatableList<Either<TagKey<T>, OptionalHolder<T>>>(eitherList), registryAccess);
    }

    public static <T> Optional<T> getVanillaRegistryValue(ResourceKey<Registry<T>> registry, ResourceLocation id) {
        try {
            return Optional.ofNullable(RegistryHelper.getRegistry(registry)).map(reg -> reg.get(id));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    @Nullable
    public static ResourceLocation getKey(Holder<?> holder) {
        return holder.unwrapKey().map(ResourceKey::location).orElse(null);
    }

    public static <T> Holder.Reference<T> modifyHolder(Holder.Reference<T> original, T value) {
        try {
            HolderOwner owner = (HolderOwner)OWNER_FIELD.get(original);
            Holder.Reference newHolder = Holder.Reference.createIntrusive((HolderOwner)owner, value);
            BIND_KEY.invoke((Object)newHolder, original.unwrapKey().orElse(null));
            BIND_TAGS.invoke((Object)newHolder, original.tags().toList());
            return newHolder;
        }
        catch (Exception e) {
            e.printStackTrace();
            return original;
        }
    }

    static {
        OWNER_FIELD.setAccessible(true);
        BIND_KEY.setAccessible(true);
        BIND_TAGS.setAccessible(true);
    }

    @EventBusSubscriber(value={Dist.CLIENT})
    public static class GetAccessClient {
        @SubscribeEvent
        public static void onClientLoading(ClientPlayerNetworkEvent.LoggingIn event) {
            if (!Minecraft.getInstance().hasSingleplayerServer()) {
                REGISTRY_ACCESS = event.getPlayer().connection.registryAccess();
            }
        }
    }

    @EventBusSubscriber
    public static class GetAccessServer {
        @SubscribeEvent
        public static void onServerLoading(ServerConfigsLoadedEvent event) {
            REGISTRY_ACCESS = event.getServer().registryAccess();
        }
    }
}

