/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ChangelogGenerator {
    private static final String COMMON_STYLE = "font-family: 'JetBrains Mono',monospace;\nbackground-color: #212121;\ncolor: #aaafb6;";
    private static final String HEADER_STYLE = "color: #ffffff;\nfont-size: 20;\nfont-weight: bold;";
    private static final String SECTION_STYLE = "color: #ffffff;\nfont-size: 16;\nfont-weight: bold;";
    private static final String WARNING_STYLE = "color: orange;";
    private static final String URGENT_STYLE = "color: #e06c75; font-weight: bold;";

    public static void main(String[] args) {
        String inputFilePath = "changelog.txt";
        String outputFilePath = "formatted_changelog.txt";
        try (BufferedReader reader = new BufferedReader(new FileReader(inputFilePath));
             BufferedWriter writer = new BufferedWriter(new FileWriter(outputFilePath));){
            String line;
            ArrayList<String> allLines = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                allLines.add(line);
            }
            int lastDashIndex = -1;
            for (int i = allLines.size() - 1; i >= 0; --i) {
                if (!((String)allLines.get(i)).trim().matches("^-+$")) continue;
                lastDashIndex = i;
                break;
            }
            ArrayList lines = new ArrayList(allLines.subList(lastDashIndex + 1, allLines.size()));
            String version = "";
            for (String l : lines) {
                if (l.trim().isEmpty()) continue;
                version = l.trim();
                break;
            }
            if (version.isEmpty()) {
                System.err.println("No version number found in the changelog.");
                return;
            }
            List<Section> sections = ChangelogGenerator.parseSections(lines.subList(1, lines.size()));
            ChangelogGenerator.generateHTML(writer, version, sections);
        }
        catch (IOException e) {
            System.err.println("Error processing the files: " + e.getMessage());
        }
    }

    private static List<Section> parseSections(List<String> lines) {
        ArrayList<Section> sections = new ArrayList<Section>();
        Section currentSection = new Section("");
        sections.add(currentSection);
        ArrayList<AbstractMap.SimpleEntry<Item, Integer>> itemStack = new ArrayList<AbstractMap.SimpleEntry<Item, Integer>>();
        for (String line : lines) {
            int i;
            int indent;
            for (indent = 0; indent < line.length() && line.charAt(indent) == ' '; ++indent) {
            }
            String trimmed = line.trim();
            if (trimmed.isEmpty()) continue;
            if (trimmed.endsWith(":") && indent == 0 && !ChangelogGenerator.isListItem(trimmed)) {
                currentSection = new Section(trimmed);
                sections.add(currentSection);
                itemStack.clear();
                continue;
            }
            Item newItem = ChangelogGenerator.parseItem(trimmed);
            if (indent == 0 || itemStack.isEmpty()) {
                currentSection.items.add(newItem);
                itemStack.clear();
                itemStack.add(new AbstractMap.SimpleEntry<Item, Integer>(newItem, indent));
                continue;
            }
            for (i = itemStack.size() - 1; i >= 0 && (Integer)((Map.Entry)itemStack.get(i)).getValue() >= indent; --i) {
            }
            if (i >= 0) {
                Item parent = (Item)((Map.Entry)itemStack.get(i)).getKey();
                parent.children.add(newItem);
                while (itemStack.size() > i + 1) {
                    itemStack.remove(itemStack.size() - 1);
                }
            } else {
                currentSection.items.add(newItem);
                itemStack.clear();
            }
            itemStack.add(new AbstractMap.SimpleEntry<Item, Integer>(newItem, indent));
        }
        if (((Section)sections.get((int)0)).items.isEmpty()) {
            sections.remove(0);
        }
        return sections;
    }

    private static Item parseItem(String line) {
        if (line.startsWith("!!")) {
            return new Item("!!", line.substring(2).trim());
        }
        if (line.startsWith("!")) {
            return new Item("!", line.substring(1).trim());
        }
        if (line.startsWith("*")) {
            return new Item("*", line.substring(1).trim());
        }
        if (line.startsWith("-")) {
            return new Item("-", line.substring(1).trim());
        }
        return new Item("", line);
    }

    private static boolean isListItem(String line) {
        return line.startsWith("*") || line.startsWith("-") || line.startsWith("!!") || line.startsWith("!");
    }

    private static void generateHTML(BufferedWriter writer, String version, List<Section> sections) throws IOException {
        writer.write("<div style=\"font-family: 'JetBrains Mono',monospace;\nbackground-color: #212121;\ncolor: #aaafb6;\">");
        writer.write(String.format("<span style=\"%s\">%s</span>", HEADER_STYLE, version));
        writer.write("<br><br>\n");
        for (Section section : sections) {
            writer.write(String.format("<span style=\"%s\">%s</span>\n", SECTION_STYLE, section.title));
            writer.write("<ul style=\"font-size: 13;\">\n");
            for (Item item : section.items) {
                ChangelogGenerator.writeItem(writer, item, 0);
            }
            writer.write("</ul>\n<br>\n");
        }
        writer.write("</div>");
    }

    private static void writeItem(BufferedWriter writer, Item item, int level) throws IOException {
        switch (item.prefix) {
            case "*": {
                writer.write(String.format("<li><span style=\"color: #ffffff; font-weight: bold;\">%s</span>", item.content));
                break;
            }
            case "!": {
                writer.write(String.format("<li><span style=\"%s\">! %s</span>", WARNING_STYLE, item.content));
                break;
            }
            case "!!": {
                writer.write(String.format("<li><span style=\"%s\">!! %s</span>", URGENT_STYLE, item.content));
                break;
            }
            case "-": {
                writer.write(String.format("<li>%s", item.content));
                break;
            }
            default: {
                writer.write(String.format("<li>%s", item.content));
            }
        }
        if (!item.children.isEmpty()) {
            writer.write("\n<ul style=\"margin-left: " + (10 + level * 5) + "px;\">\n");
            for (Item child : item.children) {
                ChangelogGenerator.writeItem(writer, child, level + 1);
            }
            writer.write("</ul>\n");
        }
        writer.write("</li>\n");
    }

    static class Section {
        String title;
        List<Item> items = new ArrayList<Item>();

        Section(String title) {
            this.title = title;
        }
    }

    static class Item {
        String prefix;
        String content;
        List<Item> children = new ArrayList<Item>();

        Item(String prefix, String content) {
            this.prefix = prefix;
            this.content = content;
        }
    }
}

