/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.effect.player;

import com.momosoftworks.coldsweat.api.temperature.effect.TempEffect;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffectType;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class FreezeMineSpeedEffect
extends TempEffect {
    public FreezeMineSpeedEffect(TempEffectType<?> type, LivingEntity entity, IntegerBounds bounds) {
        super(type, entity, bounds);
    }

    @SubscribeEvent
    public void onPlayerMine(PlayerEvent.BreakSpeed event) {
        if (!this.test((Entity)event.getEntity())) {
            return;
        }
        float miningSpeed = 1.0f - ConfigSettings.COLD_MINING_IMPAIRMENT.get().floatValue();
        if (miningSpeed == 1.0f) {
            return;
        }
        float effect = (float)this.getEffectFactor();
        float minMiningSpeed = CSMath.blend(1.0f, miningSpeed, effect, 0.0f, 1.0f);
        event.setNewSpeed(event.getNewSpeed() * minMiningSpeed);
    }

    @Override
    public TempEffect.Side getSide() {
        return TempEffect.Side.SERVER;
    }
}

