/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.config.spec;

import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.config.spec.CSConfigSpec;
import com.momosoftworks.coldsweat.util.serialization.DynamicHolder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import org.joml.Vector2i;

public class ClientSettingsConfig {
    private static final CSConfigSpec SPEC;
    private static final CSConfigSpec.Builder BUILDER;
    public static final CSConfigSpec.BooleanValue USE_CELSIUS;
    public static final CSConfigSpec.IntValue TEMPERATURE_OFFSET;
    public static final CSConfigSpec.DoubleValue TEMPERATURE_SMOOTHING;
    public static final CSConfigSpec.ConfigValue<List<? extends Integer>> BODY_TEMP_ICON_POS;
    public static final CSConfigSpec.BooleanValue SHOW_BODY_TEMP_ICON;
    public static final CSConfigSpec.BooleanValue MOVE_BODY_TEMP_ICON_ADVANCED;
    public static final CSConfigSpec.ConfigValue<List<? extends Integer>> BODY_TEMP_READOUT_POS;
    public static final CSConfigSpec.BooleanValue SHOW_BODY_TEMP_READOUT;
    public static final CSConfigSpec.ConfigValue<List<? extends Integer>> WORLD_TEMP_GAUGE_POS;
    public static final CSConfigSpec.BooleanValue SHOW_WORLD_TEMP_GAUGE;
    public static final CSConfigSpec.ConfigValue<List<? extends Integer>> FOOD_EFFECTS_POS;
    public static final CSConfigSpec.BooleanValue SHOW_FOOD_EFFECTS;
    public static final CSConfigSpec.BooleanValue USE_CUSTOM_HOTBAR_LAYOUT;
    public static final CSConfigSpec.BooleanValue ENABLE_ICON_BOBBING;
    public static final CSConfigSpec.BooleanValue SHOW_HEARTH_DEBUG_VISUALS;
    public static final CSConfigSpec.BooleanValue SHOW_CONFIG_BUTTON;
    public static final CSConfigSpec.ConfigValue<List<? extends Integer>> CONFIG_BUTTON_POS;
    public static final CSConfigSpec.BooleanValue SHOW_SCREEN_DISTORTIONS;
    public static final CSConfigSpec.BooleanValue HIGH_CONTRAST_MODE;
    public static final CSConfigSpec.BooleanValue ENABLE_CREATIVE_WARNING;
    public static final CSConfigSpec.ConfigValue<String> INSULATION_VISIBILITY;
    public static final CSConfigSpec.BooleanValue EXPAND_TOOLTIPS;
    public static final CSConfigSpec.BooleanValue ENABLE_HINTS;
    public static final CSConfigSpec.IntValue WATER_EFFECT_SETTING;
    public static final CSConfigSpec.DoubleValue WATER_DROPLET_OPACITY;
    public static final CSConfigSpec.ConfigValue<List<? extends Integer>> WATER_DROPLET_SCALE;
    public static final CSConfigSpec.BooleanValue SHOW_FROZEN_HEALTH;
    public static final CSConfigSpec.DoubleValue FREEZING_OVERLAY_OPACITY;
    public static final CSConfigSpec.DoubleValue SHIVER_INTENSITY;
    public static final CSConfigSpec.DoubleValue HEATSTROKE_BORDER_OPACITY;
    public static final CSConfigSpec.DoubleValue HEATSTROKE_BLUR;
    public static final CSConfigSpec.DoubleValue HEATSTROKE_SWAY_AMOUNT;
    public static final CSConfigSpec.DoubleValue HEATSTROKE_SWAY_SPEED;
    public static final CSConfigSpec.BooleanValue ANIMATED_SOULSPRING_LAMP;
    public static final CSConfigSpec.BooleanValue POSE_SOULSPRING_LAMP;
    public static final CSConfigSpec.ConfigValue<String> WATERSKIN_DRINK_PRIMARY;
    public static final CSConfigSpec.ConfigValue<String> WATERSKIN_DRINK_SECONDARY;

    public static void setup() {
        Path configPath = FMLPaths.CONFIGDIR.get();
        Path csConfigPath = Paths.get(configPath.toAbsolutePath().toString(), "coldsweat");
        try {
            Files.createDirectory(csConfigPath, new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)SPEC, "coldsweat/client.toml");
    }

    public static Vector2i getBodyIconPos() {
        return new Vector2i(BODY_TEMP_ICON_POS.get().get(0).intValue(), BODY_TEMP_ICON_POS.get().get(1).intValue());
    }

    public static void setBodyIconPos(Vector2i pos) {
        BODY_TEMP_ICON_POS.set(List.of(Integer.valueOf(pos.x), Integer.valueOf(pos.y)));
    }

    public static Vector2i getBodyReadoutPos() {
        return new Vector2i(BODY_TEMP_READOUT_POS.get().get(0).intValue(), BODY_TEMP_READOUT_POS.get().get(1).intValue());
    }

    public static void setBodyReadoutPos(Vector2i pos) {
        BODY_TEMP_READOUT_POS.set(List.of(Integer.valueOf(pos.x), Integer.valueOf(pos.y)));
    }

    public static Vector2i getWorldGaugePos() {
        return new Vector2i(WORLD_TEMP_GAUGE_POS.get().get(0).intValue(), WORLD_TEMP_GAUGE_POS.get().get(1).intValue());
    }

    public static void setWorldGaugePos(Vector2i pos) {
        WORLD_TEMP_GAUGE_POS.set(List.of(Integer.valueOf(pos.x), Integer.valueOf(pos.y)));
    }

    public static Vector2i getFoodEffectsPos() {
        return new Vector2i(FOOD_EFFECTS_POS.get().get(0).intValue(), FOOD_EFFECTS_POS.get().get(1).intValue());
    }

    public static void setFoodEffectsPos(Vector2i pos) {
        FOOD_EFFECTS_POS.set(List.of(Integer.valueOf(pos.x), Integer.valueOf(pos.y)));
    }

    public static Vector2i getConfigButtonPos() {
        return new Vector2i(CONFIG_BUTTON_POS.get().get(0).intValue(), CONFIG_BUTTON_POS.get().get(1).intValue());
    }

    public static void setConfigButtonPos(Vector2i pos) {
        CONFIG_BUTTON_POS.set(List.of(Integer.valueOf(pos.x), Integer.valueOf(pos.y)));
    }

    public static synchronized void writeAndSave() {
        for (DynamicHolder holder : ConfigSettings.CLIENT_SETTINGS.values()) {
            holder.save(null);
        }
        ClientSettingsConfig.save();
    }

    public static synchronized void save() {
        SPEC.save();
    }

    static {
        BUILDER = new CSConfigSpec.Builder();
        BUILDER.push("Preferences");
        USE_CELSIUS = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Displays temperature in Celsius instead of Fahrenheit", " \u2304 ").define("Celsius", false);
        TEMPERATURE_OFFSET = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Visually offsets the world temperature to better match the user's definition of \"hot\" and \"cold\"", " \u2304 ").defineInRange("Temperature Offset", 0, -2147483647, Integer.MAX_VALUE);
        TEMPERATURE_SMOOTHING = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " The amount of smoothing applied to gauges in the UI", " A value of 1 has no smoothing", " \u2304 ").defineInRange("Temperature Smoothing", 10.0, 1.0, 2.147483647E9);
        WATER_EFFECT_SETTING = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Displays a dripping water effect on-screen and/or with particles when the player is wet", " 0: Off, 1: Particles, 2: On-Screen, 3: Both", " \u2304 ").defineInRange("Show Water Effect", 3, 0, 3);
        WATER_DROPLET_OPACITY = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " The opacity of the water droplets on-screen", " \u2304 ").defineInRange("Water Droplet Opacity", 0.5, 0.0, 1.0);
        WATER_DROPLET_SCALE = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " The scale of the water droplets on-screen, in scaled \"pixels\"", " \u2304 ").defineList("Water Droplet Scale", List.of(Integer.valueOf(40), Integer.valueOf(48)), it -> it instanceof Integer);
        WATERSKIN_DRINK_PRIMARY = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Defines the primary (right-click) action for the waterskin", " Can be one of \"drink\", \"pour\", or \"none\"", " \u2304 ").define("Waterskin Primary Action", "pour");
        WATERSKIN_DRINK_SECONDARY = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Defines the secondary (sneak-right-click) action for the waterskin", " Can be one of \"drink\", \"pour\", or \"none\"", " \u2304 ").define("Waterskin Secondary Action", "drink");
        BUILDER.pop();
        BUILDER.push("HUD");
        USE_CUSTOM_HOTBAR_LAYOUT = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Tweaks the layout of the hotbar to make foom for Cold Sweat UI elements", " \u2304 ").define("Custom hotbar layout", true);
        ENABLE_ICON_BOBBING = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Controls whether UI elements will shake when in critical conditions", " \u2304 ").define("Icon Bobbing", true);
        BODY_TEMP_ICON_POS = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " The position of the body temperature icon relative to default", " \u2304 ").defineList("Body Temperature Icon Offset", List.of(Integer.valueOf(0), Integer.valueOf(0)), it -> it instanceof Integer);
        SHOW_BODY_TEMP_ICON = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Enables the body temperature icon above the hotbar", " \u2304 ").define("Show Body Temperature Icon", true);
        MOVE_BODY_TEMP_ICON_ADVANCED = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Moves the body temperature icon to make way for the advanced readout when a thermometer is equipped", " \u2304 ").define("Move Body Icon For Advanced Info", true);
        BODY_TEMP_READOUT_POS = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " The position of the body temperature readout relative to default", " \u2304 ").defineList("Body Temperature Readout Offset", List.of(Integer.valueOf(0), Integer.valueOf(0)), it -> it instanceof Integer);
        SHOW_BODY_TEMP_READOUT = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Enables the body temperature readout above the hotbar", " \u2304 ").define("Show Body Temperature Readout", true);
        WORLD_TEMP_GAUGE_POS = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " The position of the world temperature gauge relative to default", " \u2304 ").defineList("World Temperature UI Offset", List.of(Integer.valueOf(0), Integer.valueOf(0)), it -> it instanceof Integer);
        SHOW_WORLD_TEMP_GAUGE = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Enables the world temperature gauge next to the hotbar", " \u2304 ").define("Show World Temperature Gauge", true);
        FOOD_EFFECTS_POS = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " The position of the food effects panel relative to default", " \u2304 ").defineList("Food Effects UI Offset", List.of(Integer.valueOf(0), Integer.valueOf(0)), it -> it instanceof Integer);
        SHOW_FOOD_EFFECTS = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Enables the food effects panel", " \u2304 ").define("Show Food Effects", true);
        BUILDER.pop();
        BUILDER.push("Accessibility");
        SHOW_SCREEN_DISTORTIONS = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Enables visual distortion effects when the player is too hot or cold", " \u2304 ").define("Distortion Effects", true);
        HIGH_CONTRAST_MODE = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Enables high contrast mode for UI elements", " \u2304 ").define("High Contrast", false);
        SHOW_FROZEN_HEALTH = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Shows a frozen texture over the player's health bar when they are freezing", " \u2304 ").define("Show Frozen Health", true);
        FREEZING_OVERLAY_OPACITY = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " The opacity of the icy overlay when the player is freezing", " Does not affect Vanilla's powder snow overlay", " \u2304 ").defineInRange("Freezing Overlay Opacity", 1.0, 0.0, 1.0);
        SHIVER_INTENSITY = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " The intensity of the shivering effect when the player is too cold", " \u2304 ").defineInRange("Shiver Intensity", 1.0, 0.0, 2.0);
        HEATSTROKE_BORDER_OPACITY = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " The opacity of the pulsing red border around the screen when the player is too hot", " \u2304 ").defineInRange("Heatstroke Border Opacity", 1.0, 0.0, 1.0);
        HEATSTROKE_BLUR = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " The amount of blur applied to the screen when the player is too hot", " \u2304 ").defineInRange("Heatstroke Blur Strength", 1.0, 0.0, 1.0);
        HEATSTROKE_SWAY_AMOUNT = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " The amount of camera sway applied when the player is too hot", " \u2304 ").defineInRange("Heatstroke Sway Amount", 1.0, 0.0, 2.0);
        HEATSTROKE_SWAY_SPEED = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " The speed of the camera sway applied when the player is too hot", " \u2304 ").defineInRange("Heatstroke Sway Speed", 1.0, 0.0, 2.0);
        BUILDER.pop();
        BUILDER.push("Tooltips");
        INSULATION_VISIBILITY = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Determines when armor insulation tooltips should show", " One of:", " \u2022 \"always\": Always show insulation tooltip", " \u2022 \"if_present\": Show insulation tooltip only if the item has insulation (default)", " \u2022 \"on_shift\": Show insulation tooltip if shift is held", " \u2022 \"shift_and_present\": Show insulation if shift is held AND the armor has any", " \u2022 \"never\": Never show insulation tooltips", " \u2304 ").define("Insulation Tooltip Visibility", "if_present", o -> o instanceof String);
        EXPAND_TOOLTIPS = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Always expand collapsible tooltips", " \u2304 ").define("Expand Tooltips", false);
        ENABLE_HINTS = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Show keybind hints in tooltips, i.e. \"Hold [Shift]\"", " \u2304 ").define("Enable Hints", true);
        BUILDER.pop();
        BUILDER.push("Misc");
        SHOW_CONFIG_BUTTON = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Show the config menu button in the Options menu", " \u2304 ").define("Enable In-Game Config", true);
        CONFIG_BUTTON_POS = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " The position (offset) of the config button on the screen", " \u2304 ").defineList("Config Button Position", List.of(Integer.valueOf(0), Integer.valueOf(0)), it -> it instanceof Integer);
        ENABLE_CREATIVE_WARNING = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Warns the player about a bug that clears armor insulation when in creative mode", " \u2304 ").define("Enable Creative Mode Warning", true);
        SHOW_HEARTH_DEBUG_VISUALS = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Displays areas that the Hearth is affecting when the F3 debug menu is open", " \u2304 ").define("Hearth Debug", true);
        ANIMATED_SOULSPRING_LAMP = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Enables the animated soul spring lamp model", " Disable this if there are visual errors like missing textures", " \u2304 ").define("Animated Soulspring Lamp", true);
        POSE_SOULSPRING_LAMP = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Uses custom player arm posing when holding a soulspring lamp", " \u2304 ").define("Pose Soulspring Lamp", true);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

