/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.util;

import com.google.common.collect.Multimap;
import com.mojang.serialization.Codec;
import com.momosoftworks.coldsweat.data.codec.util.AttributeCodecs;
import com.momosoftworks.coldsweat.util.math.FastMultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class AttributeModifierMap {
    public static final Codec<AttributeModifierMap> CODEC = Codec.unboundedMap(AttributeCodecs.ATTRIBUTE_CODEC, (Codec)AttributeCodecs.MODIFIER_CODEC.listOf()).xmap(AttributeModifierMap::new, map -> map.getMap().asMap().entrySet().stream().collect(HashMap::new, (mp, ent) -> mp.put((Attribute)ent.getKey(), new ArrayList((Collection)ent.getValue())), HashMap::putAll));
    private final Multimap<Attribute, AttributeModifier> map = new FastMultiMap<Attribute, AttributeModifier>();

    public AttributeModifierMap() {
    }

    public AttributeModifierMap(Map<Attribute, ?> attributeListMap) {
        attributeListMap.forEach((attribute, list) -> {
            if (list instanceof Collection) {
                this.map.putAll(attribute, (Iterable)((Collection)list));
            } else if (list instanceof AttributeModifier) {
                this.map.put(attribute, (Object)((AttributeModifier)list));
            }
        });
    }

    public AttributeModifierMap(Multimap<Attribute, AttributeModifier> map) {
        this.map.putAll(map);
    }

    public void put(Attribute attribute, AttributeModifier modifier) {
        this.map.put((Object)attribute, (Object)modifier);
    }

    public Collection<AttributeModifier> get(Attribute attribute) {
        return this.map.get((Object)attribute);
    }

    public Multimap<Attribute, AttributeModifier> getMap() {
        return this.map;
    }

    public AttributeModifierMap putAll(AttributeModifierMap other) {
        this.map.putAll(other.map);
        return this;
    }

    public AttributeModifierMap putAll(Attribute attribute, Collection<AttributeModifier> modifiers) {
        this.map.putAll((Object)attribute, modifiers);
        return this;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public void clear() {
        this.map.clear();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeModifierMap that = (AttributeModifierMap)obj;
        for (Map.Entry entry : this.map.asMap().entrySet()) {
            if (!that.map.containsKey(entry.getKey())) {
                return false;
            }
            Collection other = that.map.get((Object)((Attribute)entry.getKey()));
            if (((Collection)entry.getValue()).size() != other.size()) {
                return false;
            }
            Iterator thatIterator = other.iterator();
            for (AttributeModifier modifier : (Collection)entry.getValue()) {
                if (!thatIterator.hasNext()) {
                    return false;
                }
                AttributeModifier thatModifier = (AttributeModifier)thatIterator.next();
                if (Double.compare(modifier.m_22218_(), thatModifier.m_22218_()) == 0 && modifier.m_22217_() == thatModifier.m_22217_() && modifier.m_22214_().equals(thatModifier.m_22214_())) continue;
                return false;
            }
        }
        return true;
    }
}

