/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.momosoftworks.coldsweat.client.event.HearthDebugRenderer;
import com.momosoftworks.coldsweat.client.gui.config.pages.ConfigPageOne;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.sounds.EntityBoundSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundSetCreativeModeSlotPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class ClientOnlyHelper {
    private static final Field SLIM = ObfuscationReflectionHelper.findField(PlayerModel.class, (String)"f_103380_");

    public static void playEntitySound(SoundEvent sound, SoundSource source, float volume, float pitch, Entity entity) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new EntityBoundSoundInstance(sound, source, volume, pitch, entity, entity.m_9236_().f_46441_.m_188505_()));
    }

    public static Level getClientLevel() {
        return Minecraft.m_91087_().f_91073_;
    }

    public static void addHearthPosition(BlockPos pos) {
        HearthDebugRenderer.HEARTH_LOCATIONS.put(pos, new HashMap());
    }

    public static void removeHearthPosition(BlockPos pos) {
        HearthDebugRenderer.HEARTH_LOCATIONS.remove(pos);
    }

    public static void openConfigScreen() {
        Minecraft.m_91087_().m_91152_((Screen)new ConfigPageOne(Minecraft.m_91087_().f_91080_));
    }

    public static Player getClientPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    public static void sendPacketToServer(ServerboundSetCreativeModeSlotPacket packet) {
        Minecraft.m_91087_().m_91403_().m_104955_((Packet)packet);
    }

    public static GameType getGameMode() {
        return Minecraft.m_91087_().f_91072_.m_105295_();
    }

    public static boolean isPlayerModelSlim(RenderLayer<?, ?> layer) {
        EntityModel entityModel = layer.m_117386_();
        if (entityModel instanceof PlayerModel) {
            PlayerModel playerModel = (PlayerModel)entityModel;
            try {
                return (Boolean)SLIM.get(playerModel);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static boolean isPlayerModelSlim(HumanoidModel<?> model) {
        if (model instanceof PlayerModel) {
            PlayerModel playerModel = (PlayerModel)model;
            try {
                return (Boolean)SLIM.get(playerModel);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static void renderVerticalCropText(String text, int x, int y, int height, int color, GuiGraphics graphics) {
        Font font = Minecraft.m_91087_().f_91062_;
        Minecraft mc = Minecraft.m_91087_();
        if (height > 0) {
            int guiScale = (int)mc.m_91268_().m_85449_();
            int windowHeight = mc.m_91268_().m_85442_();
            int scissorX = x * guiScale;
            Objects.requireNonNull(font);
            int scissorY = windowHeight - (y + 9) * guiScale;
            int scissorWidth = font.m_92895_(text) * guiScale;
            int scissorHeight = height * guiScale;
            RenderSystem.enableScissor((int)scissorX, (int)scissorY, (int)scissorWidth, (int)scissorHeight);
            graphics.m_280056_(font, text, x, y, color, false);
            RenderSystem.disableScissor();
        }
    }

    static {
        SLIM.setAccessible(true);
    }
}

