/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.math;

import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.util.math.InterruptibleIterator;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3d;

public class CSMath {
    private CSMath() {
    }

    public static <T> void doIfNotNull(T object, Consumer<T> run) {
        if (object != null) {
            run.accept(object);
        }
    }

    public static <T, R> R getIfNotNull(T object, Function<T, R> valueGetter, R defaultValue) {
        if (object != null) {
            return valueGetter.apply(object);
        }
        return defaultValue;
    }

    public static float toRadians(float input) {
        return input * ((float)Math.PI / 180);
    }

    public static float toRadians(double input) {
        return (float)input * ((float)Math.PI / 180);
    }

    public static float toDegrees(float input) {
        return input * 57.29578f;
    }

    public static Vec3 toEulerAngles(Quaternionf quat) {
        double bank;
        double attitude;
        double heading;
        double sqw;
        double sqz;
        double sqy;
        double sqx;
        double unit;
        double w;
        double z;
        double y;
        double x = quat.x();
        double test = x * (y = (double)quat.y()) + (z = (double)quat.z()) * (w = (double)quat.w());
        if (test > 0.499 * (unit = (sqx = x * x) + (sqy = y * y) + (sqz = z * z) + (sqw = w * w))) {
            heading = 2.0 * Math.atan2(x, w);
            attitude = 1.5707963267948966;
            bank = 0.0;
        } else if (test < -0.499 * unit) {
            heading = -2.0 * Math.atan2(x, w);
            attitude = -1.5707963267948966;
            bank = 0.0;
        } else {
            heading = Math.atan2(2.0 * y * w - 2.0 * x * z, sqx - sqy - sqz + sqw);
            attitude = Math.asin(2.0 * test / unit);
            bank = Math.atan2(2.0 * x * w - 2.0 * y * z, -sqx + sqy - sqz + sqw);
        }
        return new Vec3((double)CSMath.toDegrees((float)bank), (double)CSMath.toDegrees((float)heading), (double)CSMath.toDegrees((float)attitude));
    }

    public static Quaternionf toQuaternion(double x, double y, double z) {
        return new Quaternionf().rotateXYZ((float)x, (float)y, (float)z);
    }

    public static double clamp(double value, double min, double max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static float clamp(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static int clamp(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static int ceil(double value) {
        if (value >= 0.0) {
            return (int)Math.ceil(value);
        }
        return (int)Math.floor(value);
    }

    public static int floor(double value) {
        if (value >= 0.0) {
            return (int)Math.floor(value);
        }
        return (int)Math.ceil(value);
    }

    @SafeVarargs
    public static <T extends Comparable<T>> T min(T ... values) {
        T min = values[0];
        for (T value : values) {
            if (value.compareTo(min) >= 0) continue;
            min = value;
        }
        return min;
    }

    @SafeVarargs
    public static <T extends Comparable<T>> T max(T ... values) {
        T max = values[0];
        for (T value : values) {
            if (value.compareTo(max) <= 0) continue;
            max = value;
        }
        return max;
    }

    public static double min(double ... values) {
        double min = values[0];
        for (double value : values) {
            if (!(value < min)) continue;
            min = value;
        }
        return min;
    }

    public static double max(double ... values) {
        double max = values[0];
        for (double value : values) {
            if (!(value > max)) continue;
            max = value;
        }
        return max;
    }

    public static boolean betweenInclusive(double value, double min, double max) {
        if (min > max) {
            double temp = min;
            min = max;
            max = temp;
        }
        return value >= min && value <= max;
    }

    public static boolean betweenExclusive(double value, double min, double max) {
        if (min > max) {
            double temp = min;
            min = max;
            max = temp;
        }
        return value > min && value < max;
    }

    public static double blend(double blendFrom, double blendTo, double factor, double rangeMin, double rangeMax) {
        if (rangeMin > rangeMax) {
            return CSMath.blend(blendTo, blendFrom, factor, rangeMax, rangeMin);
        }
        if (factor <= rangeMin) {
            return blendFrom;
        }
        if (factor >= rangeMax) {
            return blendTo;
        }
        return (blendTo - blendFrom) / (rangeMax - rangeMin) * (factor - rangeMin) + blendFrom;
    }

    public static float blend(float blendFrom, float blendTo, float factor, float rangeMin, float rangeMax) {
        return (float)CSMath.blend((double)blendFrom, (double)blendTo, (double)factor, (double)rangeMin, (double)rangeMax);
    }

    public static double blendLog(double blendFrom, double blendTo, double factor, double rangeMin, double rangeMax, double intensity) {
        factor = CSMath.clamp(factor, rangeMin, rangeMax);
        double normalizedFactor = (factor - rangeMin) / (rangeMax - rangeMin);
        double logFactor = Math.log(intensity * normalizedFactor + 1.0) / Math.log(intensity + 1.0);
        return blendFrom + (blendTo - blendFrom) * logFactor;
    }

    public static float blendLog(float blendFrom, float blendTo, float factor, float rangeMin, float rangeMax, double intensity) {
        return (float)CSMath.blendLog((double)blendFrom, (double)blendTo, (double)factor, (double)rangeMin, (double)rangeMax, intensity);
    }

    public static double blendExp(double blendFrom, double blendTo, double factor, double rangeMin, double rangeMax, double intensity) {
        factor = CSMath.clamp(factor, rangeMin, rangeMax);
        double normalizedFactor = (factor - rangeMin) / (rangeMax - rangeMin);
        double expFactor = (Math.pow(intensity, normalizedFactor) - 1.0) / (intensity - 1.0);
        return blendFrom + (blendTo - blendFrom) * expFactor;
    }

    public static float blendExp(float blendFrom, float blendTo, float factor, float rangeMin, float rangeMax, double intensity) {
        return (float)CSMath.blendExp((double)blendFrom, (double)blendTo, (double)factor, (double)rangeMin, (double)rangeMax, intensity);
    }

    public static double blendExp(double blendFrom, double blendTo, double factor, double rangeMin, double rangeMax) {
        return CSMath.blendExp(blendFrom, blendTo, factor, rangeMin, rangeMax, Math.E);
    }

    public static float blendExp(float blendFrom, float blendTo, float factor, float rangeMin, float rangeMax) {
        return CSMath.blendExp(blendFrom, blendTo, factor, rangeMin, rangeMax, Math.E);
    }

    public static float blendEase(float blendFrom, float blendTo, float factor, float rangeMin, float rangeMax) {
        factor = Math.max(rangeMin, Math.min(factor, rangeMax));
        float normalizedFactor = (factor - rangeMin) / (rangeMax - rangeMin);
        float expFactor = (float)(Math.pow(normalizedFactor, 2.0) / (Math.pow(normalizedFactor, 2.0) + Math.pow(1.0f - normalizedFactor, 2.0)));
        return blendFrom + (blendTo - blendFrom) * expFactor;
    }

    public static double averagePair(Pair<? extends Number, ? extends Number> pair) {
        return (((Number)pair.getFirst()).doubleValue() + ((Number)pair.getSecond()).doubleValue()) / 2.0;
    }

    @SafeVarargs
    public static Pair<Double, Double> addPairs(Pair<? extends Number, ? extends Number> ... pairs) {
        double first = 0.0;
        double second = 0.0;
        for (Pair<? extends Number, ? extends Number> pair : pairs) {
            first += ((Number)pair.getFirst()).doubleValue();
            second += ((Number)pair.getSecond()).doubleValue();
        }
        return Pair.of((Object)first, (Object)second);
    }

    public static double getDistanceSqr(double x1, double y1, double z1, double x2, double y2, double z2) {
        double xDistance = Math.abs(x1 - x2);
        double yDistance = Math.abs(y1 - y2);
        double zDistance = Math.abs(z1 - z2);
        return xDistance * xDistance + yDistance * yDistance + zDistance * zDistance;
    }

    public static double getDistance(Entity entity, Vec3 pos) {
        return CSMath.getDistance(entity, pos.f_82479_, pos.f_82480_, pos.f_82481_);
    }

    public static double getDistance(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt(CSMath.getDistanceSqr(x1, y1, z1, x2, y2, z2));
    }

    public static double getDistance(Vec3 pos1, Vec3 pos2) {
        return CSMath.getDistance(pos1.f_82479_, pos1.f_82480_, pos1.f_82481_, pos2.f_82479_, pos2.f_82480_, pos2.f_82481_);
    }

    public static double getDistance(Entity entity, double x, double y, double z) {
        return CSMath.getDistance(entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), x, y, z);
    }

    public static double getDistance(Vec3i pos1, Vec3i pos2) {
        return Math.sqrt(pos1.m_123331_(pos2));
    }

    public static double average(Number ... values) {
        double sum = 0.0;
        for (Number value : values) {
            sum += value.doubleValue();
        }
        return sum / (double)values.length;
    }

    public static double weightedAverage(double val1, double val2, double weight1, double weight2) {
        return (val1 * weight1 + val2 * weight2) / (weight1 + weight2);
    }

    public static double weightedAverage(List<? extends Pair<? extends Number, ? extends Number>> values) {
        double sum = 0.0;
        double weightSum = 0.0;
        for (Pair<? extends Number, ? extends Number> pair : values) {
            double weight = ((Number)pair.getSecond()).doubleValue();
            sum += ((Number)pair.getFirst()).doubleValue() * weight;
            weightSum += weight;
        }
        return sum / Math.max(1.0, weightSum);
    }

    public static Vec3 vectorToVec(Vector3d vec) {
        return new Vec3(vec.x, vec.y, vec.z);
    }

    public static Direction getDirectionFrom(double x, double y, double z) {
        Direction direction = Direction.NORTH;
        double f = 1.4E-45f;
        for (Direction direction1 : Direction.values()) {
            double f1 = x * (double)direction1.m_122429_() + y * (double)direction1.m_122430_() + z * (double)direction1.m_122431_();
            if (!(f1 > f)) continue;
            f = f1;
            direction = direction1;
        }
        return direction;
    }

    public static Direction getDirectionFrom(Vec3 vec3) {
        return CSMath.getDirectionFrom(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
    }

    public static Direction getDirectionFrom(BlockPos from, BlockPos to) {
        return CSMath.getDirectionFrom(to.m_123341_() - from.m_123341_(), to.m_123342_() - from.m_123342_(), to.m_123343_() - from.m_123343_());
    }

    public static <T> void breakableForEach(Collection<T> collection, BiConsumer<T, InterruptibleIterator<T>> consumer) {
        new InterruptibleIterator<T>(collection).run(consumer);
    }

    public static void tryCatch(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static <T> T tryCatch(Supplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static int sign(double value) {
        if (value == 0.0) {
            return 0;
        }
        return value < 0.0 ? -1 : 1;
    }

    public static int getSignForRange(double value, double min, double max) {
        return value > max ? 1 : (value < min ? -1 : 0);
    }

    public static double truncate(double value, int sigFigs) {
        return (double)((int)(value * Math.pow(10.0, sigFigs))) / Math.pow(10.0, sigFigs);
    }

    public static boolean isInteger(Number value) {
        return Math.abs(value.doubleValue() - (double)value.intValue()) < 1.0E-4;
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException("Argument \"places\" must be a positive integer.");
        }
        if (CSMath.isInteger(value)) {
            return value;
        }
        BigDecimal bd = new BigDecimal(Double.toString(value));
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public static double roundNearest(double value, double multipleOf) {
        return (double)Math.round(value / multipleOf) * multipleOf;
    }

    public static double roundDownNearest(double value, double multipleOf) {
        return Math.floor(value / multipleOf) * multipleOf;
    }

    public static double roundUpNearest(double value, double multipleOf) {
        return Math.ceil(value / multipleOf) * multipleOf;
    }

    public static int blendColors(int colorA, int colorB, float ratio) {
        int aFrom = colorA >> 24 & 0xFF;
        int rFrom = colorA >> 16 & 0xFF;
        int gFrom = colorA >> 8 & 0xFF;
        int bFrom = colorA & 0xFF;
        int aTo = colorB >> 24 & 0xFF;
        int rTo = colorB >> 16 & 0xFF;
        int gTo = colorB >> 8 & 0xFF;
        int bTo = colorB & 0xFF;
        int a = (int)((float)aFrom + (float)(aTo - aFrom) * ratio);
        int r = (int)((float)rFrom + (float)(rTo - rFrom) * ratio);
        int g = (int)((float)gFrom + (float)(gTo - gFrom) * ratio);
        int b = (int)((float)bFrom + (float)(bTo - bFrom) * ratio);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static double maxAbs(double ... values) {
        double mostExtreme = 0.0;
        for (double value : values) {
            if (!(Math.abs(value) > Math.abs(mostExtreme))) continue;
            mostExtreme = value;
        }
        return mostExtreme;
    }

    public static double minAbs(double ... values) {
        double smallest = values[0];
        for (double value : values) {
            if (!(Math.abs(value) < Math.abs(smallest))) continue;
            smallest = value;
        }
        return smallest;
    }

    public static boolean equalAbs(double value1, double value2) {
        return Math.abs(value1) == Math.abs(value2);
    }

    public static boolean greaterAbs(double value1, double value2) {
        return Math.abs(value1) > Math.abs(value2);
    }

    public static boolean lessAbs(double value1, double value2) {
        return Math.abs(value1) < Math.abs(value2);
    }

    public static boolean greaterEqualAbs(double value1, double value2) {
        return Math.abs(value1) >= Math.abs(value2);
    }

    public static boolean lessEqualAbs(double value1, double value2) {
        return Math.abs(value1) <= Math.abs(value2);
    }

    public static double shrink(double value, double amount) {
        return Math.max(0.0, Math.abs(value) - amount) * (double)CSMath.sign(value);
    }

    public static double grow(double value, double amount) {
        return Math.abs(value) + amount * (double)CSMath.sign(value);
    }

    public static int shrink(int value, int amount) {
        return value > 0 ? Math.max(0, value - amount) : Math.min(0, value + amount);
    }

    public static int grow(int value, int amount) {
        return value > 0 ? value + amount : value - amount;
    }

    public static Vec3 getCenterPos(BlockPos pos) {
        return new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
    }

    public static VoxelShape rotateShape(Direction to, VoxelShape shape) {
        VoxelShape[] shapeHolder = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.m_122416_() - Direction.NORTH.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            shapeHolder[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                shapeHolder[1] = Shapes.m_83110_((VoxelShape)shapeHolder[1], (VoxelShape)Shapes.m_166049_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            shapeHolder[0] = shapeHolder[1];
            shapeHolder[1] = Shapes.m_83040_();
        }
        return shapeHolder[0];
    }

    public static VoxelShape flattenShape(Direction.Axis axis, VoxelShape shape) {
        VoxelShape[] shapeHolder = new VoxelShape[]{shape, Shapes.m_83040_()};
        switch (axis) {
            case X: {
                shapeHolder[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                    shapeHolder[1] = Shapes.m_83110_((VoxelShape)shapeHolder[1], (VoxelShape)Shapes.m_83048_((double)0.0, (double)minY, (double)minZ, (double)1.0, (double)maxY, (double)maxZ));
                });
                break;
            }
            case Y: {
                shapeHolder[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                    shapeHolder[1] = Shapes.m_83110_((VoxelShape)shapeHolder[1], (VoxelShape)Shapes.m_83048_((double)minX, (double)0.0, (double)minZ, (double)maxX, (double)1.0, (double)maxZ));
                });
                break;
            }
            case Z: {
                shapeHolder[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                    shapeHolder[1] = Shapes.m_83110_((VoxelShape)shapeHolder[1], (VoxelShape)Shapes.m_83048_((double)minX, (double)minY, (double)0.0, (double)maxX, (double)maxY, (double)1.0));
                });
            }
        }
        return shapeHolder[1];
    }

    public static boolean withinCubeDistance(BlockPos pos1, BlockPos pos2, double maxDistance) {
        return (double)Math.abs(pos1.m_123341_() - pos2.m_123341_()) <= maxDistance && (double)Math.abs(pos1.m_123342_() - pos2.m_123342_()) <= maxDistance && (double)Math.abs(pos1.m_123343_() - pos2.m_123343_()) <= maxDistance;
    }

    public static Optional<Double> safeDouble(Double value) {
        return value == null || Double.isNaN(value) || Double.isInfinite(value) ? Optional.empty() : Optional.of(value);
    }

    @Nullable
    public static <Key> Key getExactKey(Map<Key, ?> map, Key key) {
        return map.keySet().stream().filter(key::equals).findFirst().orElse(null);
    }

    @SafeVarargs
    @Nullable
    public static <T> T orElse(T ... values) {
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            return values[i];
        }
        return null;
    }

    public static <T> List<T> listOrEmpty(Optional<List<T>> list) {
        return list.orElseGet(Collections::emptyList);
    }

    public static <T> void setOrAppend(List<T> list, int index, T entry) {
        if (index < 0 || index >= list.size()) {
            list.add(entry);
        } else {
            list.set(index, entry);
        }
    }

    @SafeVarargs
    public static <T> List<T> append(Collection<T> ... lists) {
        ArrayList<T> appended = new ArrayList<T>();
        for (Collection<T> list : lists) {
            appended.addAll(list);
        }
        return appended;
    }

    @SafeVarargs
    public static <T> Set<T> merge(Collection<T> ... lists) {
        HashSet<T> appended = new HashSet<T>();
        for (Collection<T> list : lists) {
            appended.addAll(list);
        }
        return appended;
    }

    public static <T> List<T> mutable(List<T> list) {
        return new ArrayList<T>(list);
    }

    public static Class<?> getCallerClass(int depth) {
        StackTraceElement[] stElements = Thread.currentThread().getStackTrace();
        String callerClassName = null;
        for (int i = 1 + depth; i < stElements.length; ++i) {
            StackTraceElement ste = stElements[i];
            if (ste.getClassName().indexOf("java.lang.Thread") == 0) continue;
            if (callerClassName == null) {
                callerClassName = ste.getClassName();
                continue;
            }
            if (callerClassName.equals(ste.getClassName())) continue;
            try {
                return Class.forName(ste.getClassName());
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    public static Class<?> getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static <T> int getIndexOf(T o, List<T> list, BiPredicate<T, T> equals) {
        Object[] es = list.toArray(new Object[0]);
        int size = list.size();
        if (o == null) {
            for (int i = 0; i < size - 1; ++i) {
                if (es[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < size - 1; ++i) {
                if (!equals.test(o, es[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> int getIndexOf(List<T> list, Predicate<T> equals) {
        Object[] es = list.toArray(new Object[0]);
        int size = list.size();
        for (int i = 0; i < size - 1; ++i) {
            if (!equals.test(es[i])) continue;
            return i;
        }
        return -1;
    }

    public static String formatDoubleOrInt(double value) {
        return CSMath.isInteger(value) ? String.valueOf((int)value) : String.valueOf(value);
    }

    @SafeVarargs
    public static <T> boolean containsAny(List<T> list, T ... values) {
        for (T value : values) {
            if (!list.contains(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAny(String string, String ... values) {
        for (String value : values) {
            if (!string.contains(value)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean anyMatch(List<T> list, Predicate<T> predicate) {
        for (int i = 0; i < list.size(); ++i) {
            if (!predicate.test(list.get(i))) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean anyMatch(Collection<T> collection, Predicate<T> predicate) {
        for (T t : collection) {
            if (!predicate.test(t)) continue;
            return true;
        }
        return false;
    }

    public static void fillHorizontalGradient(GuiGraphics graphics, int x1, int y1, int x2, int y2, int colorFrom, int colorTo) {
        int width = x2 - x1;
        int strips = 50;
        for (int i = 0; i < strips; ++i) {
            int stripX = x1 + width * i / strips;
            int nextStripX = x1 + width * (i + 1) / strips;
            float fraction = (float)i / (float)strips;
            int color = CSMath.blendColors(colorFrom, colorTo, fraction);
            graphics.m_280509_(stripX, y1, nextStripX, y2, color);
        }
    }

    public static Rotation rotationFromNorth(Direction direction) {
        switch (direction) {
            case NORTH: {
                return Rotation.NONE;
            }
            case EAST: {
                return Rotation.CLOCKWISE_90;
            }
            case SOUTH: {
                return Rotation.CLOCKWISE_180;
            }
            case WEST: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return Rotation.NONE;
    }

    public static Rotation rotationToNorth(Direction direction) {
        switch (direction) {
            case NORTH: {
                return Rotation.NONE;
            }
            case EAST: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
            case SOUTH: {
                return Rotation.CLOCKWISE_180;
            }
            case WEST: {
                return Rotation.CLOCKWISE_90;
            }
        }
        return Rotation.NONE;
    }

    public static Class<?> classForName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class not found: " + className, e);
        }
    }
}

