/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.insulation.slot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.util.ExtraCodecs;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.serialization.EnumHelper;
import com.momosoftworks.coldsweat.util.serialization.StringRepresentable;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;

public abstract class ScalingFormula {
    Type scaling;

    public static Codec<ScalingFormula> getCodec() {
        return Codec.either(Static.CODEC, Dynamic.CODEC).xmap(either -> (ScalingFormula)either.map(left -> left, right -> right), scaling -> scaling instanceof Static ? Either.left((Object)((Static)scaling)) : Either.right((Object)((Dynamic)scaling)));
    }

    protected ScalingFormula(Type scaling) {
        this.scaling = scaling;
    }

    public abstract int getSlots(EquipmentSlotType var1, ItemStack var2);

    public abstract List<? extends Number> getValues();

    public Type getType() {
        return this.scaling;
    }

    public static enum Type implements StringRepresentable
    {
        STATIC("static"),
        LINEAR("linear"),
        EXPONENTIAL("exponential"),
        LOGARITHMIC("logarithmic");

        final String name;
        public static final Codec<Type> CODEC;

        private Type(String name) {
            this.name = name;
        }

        @Override
        public String func_176610_l() {
            return this.name;
        }

        public static Type byName(String name) {
            return (Type)EnumHelper.byName((Enum[])Type.values(), (String)name);
        }

        static {
            CODEC = ExtraCodecs.enumIgnoreCase((Enum[])Type.values());
        }
    }

    public static class Dynamic
    extends ScalingFormula {
        public static final Codec<Dynamic> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Type.CODEC.fieldOf("scaling").forGetter(ScalingFormula::getType), (App)Codec.DOUBLE.fieldOf("factor").forGetter(s -> s.factor), (App)Codec.DOUBLE.fieldOf("max").forGetter(s -> s.max)).apply((Applicative)instance, Dynamic::new));
        double factor;
        double max;

        public Dynamic(Type scaling, double factor, double max) {
            super(scaling);
            this.factor = factor;
            this.max = max;
        }

        @Override
        public int getSlots(EquipmentSlotType slot, ItemStack stack) {
            double protection = stack.func_111283_C(slot).get((Object)Attributes.field_233826_i_).stream().findFirst().map(mod -> mod.func_111164_d()).orElse(0.0);
            switch (this.scaling) {
                case LINEAR: {
                    return (int)CSMath.clamp(Math.floor(protection * this.factor), 0.0, this.max);
                }
                case EXPONENTIAL: {
                    return (int)CSMath.clamp(Math.floor(Math.pow(protection, this.factor)), 0.0, this.max);
                }
                case LOGARITHMIC: {
                    return (int)CSMath.clamp(Math.floor(Math.sqrt(protection) * this.factor), 0.0, this.max);
                }
            }
            return 0;
        }

        @Override
        public List<? extends Number> getValues() {
            return Arrays.asList(this.factor, this.max);
        }
    }

    public static class Static
    extends ScalingFormula {
        public static final Codec<Static> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("head").forGetter(s -> s.slots.getOrDefault(EquipmentSlotType.HEAD, 0)), (App)Codec.INT.fieldOf("body").forGetter(s -> s.slots.getOrDefault(EquipmentSlotType.CHEST, 0)), (App)Codec.INT.fieldOf("legs").forGetter(s -> s.slots.getOrDefault(EquipmentSlotType.LEGS, 0)), (App)Codec.INT.fieldOf("feet").forGetter(s -> s.slots.getOrDefault(EquipmentSlotType.FEET, 0))).apply((Applicative)instance, Static::new));
        Map<EquipmentSlotType, Integer> slots = new EnumMap<EquipmentSlotType, Integer>(EquipmentSlotType.class);

        public Static(int head, int body, int legs, int feet) {
            super(Type.STATIC);
            this.slots.put(EquipmentSlotType.HEAD, head);
            this.slots.put(EquipmentSlotType.CHEST, body);
            this.slots.put(EquipmentSlotType.LEGS, legs);
            this.slots.put(EquipmentSlotType.FEET, feet);
        }

        @Override
        public int getSlots(EquipmentSlotType slot, ItemStack stack) {
            return this.slots.getOrDefault(slot, 0);
        }

        @Override
        public List<? extends Number> getValues() {
            return Arrays.asList(this.slots.get(EquipmentSlotType.HEAD), this.slots.get(EquipmentSlotType.CHEST), this.slots.get(EquipmentSlotType.LEGS), this.slots.get(EquipmentSlotType.FEET));
        }
    }
}

