/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.effect.player;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.momosoftworks.coldsweat.api.event.vanilla.RenderHeartEvent;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffect;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffectType;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class FreezeHeartsEffect
extends TempEffect {
    private static final ResourceLocation HEART_TEXTURE = new ResourceLocation("cold_sweat", "textures/gui/overlay/hearts_frozen.png");
    private int heartIndex = 0;

    public FreezeHeartsEffect(TempEffectType<?> type, LivingEntity entity, IntegerBounds bounds) {
        super(type, entity, bounds);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onRenderHeart(RenderHeartEvent event) {
        int v;
        int u;
        if (!this.test((Entity)Minecraft.func_71410_x().field_71439_g)) {
            return;
        }
        if (!ConfigSettings.SHOW_FROZEN_HEALTH.get().booleanValue()) {
            return;
        }
        RenderHeartEvent.HeartType heartType = event.getHeartType();
        boolean halfHeart = event.isHalfHeart();
        int x = event.getX();
        int y = event.getY();
        if (heartType == RenderHeartEvent.HeartType.CONTAINER) {
            ++this.heartIndex;
        }
        double effect = this.getEffectFactor();
        double heartsFreezePercentage = ConfigSettings.HEARTS_FREEZING_PERCENTAGE.get();
        if (heartsFreezePercentage == 0.0) {
            return;
        }
        float maxHealth = this.entity().func_110138_aP();
        boolean isHardcore = this.entity().field_70170_p.func_72912_H().func_76093_s();
        float maxFrozenHealth = (float)((double)maxHealth * heartsFreezePercentage);
        if (maxFrozenHealth == 0.0f) {
            return;
        }
        int frozenHealth = (int)Math.round(CSMath.blend(0.0, (double)maxHealth * heartsFreezePercentage, effect, 0.0, 1.0));
        int frozenHearts = Math.round((float)frozenHealth / 2.0f);
        boolean partialFrozen = frozenHealth % 2 == 1 && this.heartIndex == frozenHearts;
        int n = u = isHardcore ? 7 : 0;
        int n2 = partialFrozen ? (halfHeart ? 21 : 14) : (v = halfHeart ? 7 : 0);
        if (this.heartIndex <= frozenHearts) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(HEART_TEXTURE);
            if (heartType == RenderHeartEvent.HeartType.CONTAINER) {
                AbstractGui.func_238463_a_((MatrixStack)event.getPoseStack(), (int)(x + 1), (int)(y + 1), (float)14.0f, (float)v, (int)7, (int)7, (int)21, (int)28);
            } else {
                AbstractGui.func_238463_a_((MatrixStack)event.getPoseStack(), (int)(x + 1), (int)(y + 1), (float)u, (float)v, (int)7, (int)7, (int)21, (int)28);
            }
            Minecraft.func_71410_x().field_71446_o.func_110577_a(AbstractGui.field_230665_h_);
        }
    }

    @SubscribeEvent
    public void resetHeartIndex(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.heartIndex = 0;
        }
    }

    @Override
    public TempEffect.Side getSide() {
        return TempEffect.Side.CLIENT;
    }
}

