/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.effect.player;

import com.momosoftworks.coldsweat.api.temperature.effect.TempEffectType;
import com.momosoftworks.coldsweat.api.temperature.effect.player.AbstractVignetteEffect;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class HeatVignetteEffect
extends AbstractVignetteEffect {
    private static final ResourceLocation TEXTURE = new ResourceLocation("cold_sweat", "textures/gui/overlay/haze.png");

    public HeatVignetteEffect(TempEffectType<?> type, LivingEntity entity, IntegerBounds bounds) {
        super(type, entity, bounds);
    }

    @Override
    protected ResourceLocation getTexture() {
        return TEXTURE;
    }

    @Override
    protected Vector4f getColor(float tickTime) {
        float vignetteBrightness = (float)(Math.sin((double)tickTime / Math.PI) / 2.0 + 0.5);
        return new Vector4f(0.231f, 0.0f, 0.0f, vignetteBrightness);
    }

    @Override
    protected void render(float opacity, float tickTime, RenderGameOverlayEvent.Pre event) {
        opacity = (float)((double)opacity * ConfigSettings.HEATSTROKE_BORDER_OPACITY.get());
        super.render(opacity, tickTime, event);
    }
}

