/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.function.Function;
import net.minecraft.entity.LivingEntity;

public class MountTempModifier
extends TempModifier {
    public MountTempModifier() {
        this(0.0, 0.0);
    }

    public MountTempModifier(double coldInsul, double heatInsul) {
        this.getNBT().func_74780_a("ColdInsulation", coldInsul);
        this.getNBT().func_74780_a("HeatInsulation", heatInsul);
    }

    @Override
    public Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        double insulationStrength = ConfigSettings.INSULATION_STRENGTH.get();
        return temp -> {
            double insulation = temp > 0.0 ? this.getNBT().func_74769_h("HeatInsulation") : this.getNBT().func_74769_h("ColdInsulation");
            return CSMath.blend(temp, 0.0, insulation * insulationStrength, 0.0, 1.0);
        };
    }
}

