/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier.compat;

import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.SeasonalTempData;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.List;
import java.util.function.Function;
import net.minecraft.entity.LivingEntity;
import net.minecraft.world.World;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.config.SeasonsConfig;

public class SereneSeasonsTempModifier
extends TempModifier {
    @Override
    public Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        if (((List)SeasonsConfig.whitelistedDimensions.get()).contains(entity.field_70170_p.func_234923_W_().func_240901_a_().toString())) {
            Pair startEndTemps;
            ISeasonState season = SeasonHelper.getSeasonState((World)entity.field_70170_p);
            SeasonalTempData springTemps = ConfigSettings.SPRING_TEMPS.get();
            SeasonalTempData summerTemps = ConfigSettings.SUMMER_TEMPS.get();
            SeasonalTempData autumnTemps = ConfigSettings.AUTUMN_TEMPS.get();
            SeasonalTempData winterTemps = ConfigSettings.WINTER_TEMPS.get();
            switch (season.getSubSeason()) {
                case EARLY_AUTUMN: {
                    startEndTemps = Pair.of((Object)autumnTemps.getStartTemp(), (Object)autumnTemps.getMiddleTemp());
                    break;
                }
                case MID_AUTUMN: {
                    startEndTemps = Pair.of((Object)autumnTemps.getMiddleTemp(), (Object)autumnTemps.getEndTemp());
                    break;
                }
                case LATE_AUTUMN: {
                    startEndTemps = Pair.of((Object)autumnTemps.getEndTemp(), (Object)winterTemps.getStartTemp());
                    break;
                }
                case EARLY_WINTER: {
                    startEndTemps = Pair.of((Object)winterTemps.getStartTemp(), (Object)winterTemps.getMiddleTemp());
                    break;
                }
                case MID_WINTER: {
                    startEndTemps = Pair.of((Object)winterTemps.getMiddleTemp(), (Object)winterTemps.getEndTemp());
                    break;
                }
                case LATE_WINTER: {
                    startEndTemps = Pair.of((Object)winterTemps.getEndTemp(), (Object)springTemps.getStartTemp());
                    break;
                }
                case EARLY_SPRING: {
                    startEndTemps = Pair.of((Object)springTemps.getStartTemp(), (Object)springTemps.getMiddleTemp());
                    break;
                }
                case MID_SPRING: {
                    startEndTemps = Pair.of((Object)springTemps.getMiddleTemp(), (Object)springTemps.getEndTemp());
                    break;
                }
                case LATE_SPRING: {
                    startEndTemps = Pair.of((Object)springTemps.getEndTemp(), (Object)summerTemps.getStartTemp());
                    break;
                }
                case EARLY_SUMMER: {
                    startEndTemps = Pair.of((Object)summerTemps.getStartTemp(), (Object)summerTemps.getMiddleTemp());
                    break;
                }
                case MID_SUMMER: {
                    startEndTemps = Pair.of((Object)summerTemps.getMiddleTemp(), (Object)summerTemps.getEndTemp());
                    break;
                }
                case LATE_SUMMER: {
                    startEndTemps = Pair.of((Object)summerTemps.getEndTemp(), (Object)autumnTemps.getStartTemp());
                    break;
                }
                default: {
                    return temp -> temp;
                }
            }
            double startValue = (Double)startEndTemps.getFirst();
            double endValue = (Double)startEndTemps.getSecond();
            return temp -> temp + (double)((float)CSMath.blend(startValue, endValue, (double)(season.getDay() % (season.getSubSeasonDuration() / season.getDayDuration())), 0.0, 8.0));
        }
        return temp -> temp;
    }
}

