/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.renderer.animation;

import com.momosoftworks.coldsweat.client.renderer.animation.Keyframe;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.model.ModelRenderer;

public class Animation {
    ArrayList<Keyframe> posKeyframes;
    ArrayList<Keyframe> rotKeyframes;
    float duration;
    float offsetAmount;
    String partName;

    public Animation(String partName, float durationSecs, List<Keyframe> posFrames, List<Keyframe> rotFrames) {
        this.partName = partName;
        this.duration = durationSecs;
        this.posKeyframes = new ArrayList<Keyframe>(posFrames);
        this.rotKeyframes = new ArrayList<Keyframe>(rotFrames);
    }

    public Animation setRotations(float time, ModelRenderer part, boolean offset) {
        if (this.rotKeyframes.isEmpty()) {
            return this;
        }
        Keyframe next = this.rotKeyframes.get(0);
        Keyframe prev = this.rotKeyframes.get(this.rotKeyframes.size() - 1);
        float animProgress = time % this.duration;
        for (int i = 0; i < this.rotKeyframes.size(); ++i) {
            Keyframe frame = this.rotKeyframes.get(i);
            if (!(frame.time >= animProgress)) continue;
            next = frame;
            prev = this.rotKeyframes.get(i == 0 ? this.rotKeyframes.size() - 1 : i - 1);
            break;
        }
        part.field_78795_f = CSMath.toRadians(CSMath.blend(prev.x, next.x, animProgress, prev.time, next.time)) + (offset ? part.field_78795_f : 0.0f);
        part.field_78796_g = CSMath.toRadians(CSMath.blend(prev.y, next.y, animProgress, prev.time, next.time)) + (offset ? part.field_78796_g : 0.0f);
        part.field_78808_h = CSMath.toRadians(CSMath.blend(prev.z, next.z, animProgress, prev.time, next.time)) + (offset ? part.field_78808_h : 0.0f);
        return this;
    }

    public Animation setPositions(float time, ModelRenderer part, boolean offset) {
        if (this.posKeyframes.isEmpty()) {
            return this;
        }
        Keyframe next = this.posKeyframes.get(0);
        Keyframe prev = this.posKeyframes.get(this.posKeyframes.size() - 1);
        float animProgress = (time + this.offsetAmount) % this.duration;
        for (int i = 0; i < this.posKeyframes.size(); ++i) {
            Keyframe frame = this.posKeyframes.get(i);
            if (!(frame.time >= animProgress)) continue;
            next = frame;
            prev = this.posKeyframes.get(i == 0 ? this.posKeyframes.size() - 1 : i - 1);
            break;
        }
        part.field_78800_c = CSMath.blend(prev.x, next.x, animProgress, prev.time, next.time) + (offset ? part.field_78800_c : 0.0f);
        part.field_78797_d = CSMath.blend(prev.y, next.y, animProgress, prev.time, next.time) + (offset ? part.field_78797_d : 0.0f);
        part.field_78798_e = CSMath.blend(prev.z, next.z, animProgress, prev.time, next.time) + (offset ? part.field_78798_e : 0.0f);
        return this;
    }

    public Animation offset(float amount) {
        this.offsetAmount = amount;
        return this;
    }

    public void addKeyframe(Keyframe keyframe, KeyframeType type) {
        if (type == KeyframeType.POSITION) {
            this.posKeyframes.add(keyframe);
        } else {
            this.rotKeyframes.add(keyframe);
        }
    }

    public String toString() {
        return String.format("Animation{ partName: %s, duration: %s, offset: %s, positions: { %s } rotations { %s } }", this.partName, Float.valueOf(this.duration), Float.valueOf(this.offsetAmount), this.posKeyframes, this.rotKeyframes);
    }

    public static enum KeyframeType {
        POSITION,
        ROTATION;

    }
}

