/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.block;

import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.itemgroup.ColdSweatGroup;
import com.momosoftworks.coldsweat.data.tag.ModBlockTags;
import com.momosoftworks.coldsweat.data.tag.ModItemTags;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModBlocks;
import com.momosoftworks.coldsweat.util.serialization.StringRepresentable;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;

@Mod.EventBusSubscriber
public class SoulStalkBlock
extends Block
implements IPlantable {
    public static final IntegerProperty AGE = BlockStateProperties.field_208171_X;
    public static final EnumProperty<Section> SECTION = EnumProperty.func_177709_a((String)"section", Section.class);
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    protected static final VoxelShape SHAPE_BUD = Block.func_208617_a((double)4.5, (double)0.0, (double)4.5, (double)11.5, (double)14.0, (double)11.5);
    public static final int MAX_HEIGHT = 6;
    public static final IDispenseItemBehavior GROWABLE_DISPENSE_BEHAVIOR = new DefaultDispenseItemBehavior(){

        protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            IPosition position;
            BlockPos pos;
            ServerWorld level = source.func_197524_h();
            BlockState state = level.func_180495_p(pos = new BlockPos(position = DispenserBlock.func_149939_a((IBlockSource)source)));
            if (state.func_203425_a(ModBlocks.SOUL_STALK)) {
                stack.func_190918_g(1);
                SoulStalkBlock.applyGrowingItem((World)level, pos);
                return stack;
            }
            return super.func_82487_b(source, stack);
        }
    };

    public SoulStalkBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0))).func_206870_a(SECTION, (Comparable)((Object)Section.BUD)));
    }

    public static AbstractBlock.Properties getProperties() {
        return AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200947_a(SoundType.field_222472_s).func_200948_a(0.0f, 0.5f).func_200944_c().func_235838_a_(state -> ((Section)((Object)state.func_177229_b(SECTION))).hasFruit() ? 4 : 0).func_226896_b_().func_200942_a();
    }

    public static Item.Properties getItemProperties() {
        return new Item.Properties().func_200916_a((ItemGroup)ColdSweatGroup.COLD_SWEAT);
    }

    @SubscribeEvent
    public static void registerDispenserBehaviors(FMLServerStartedEvent event) {
        for (Item item : ModItemTags.GROWS_SOUL_STALK.func_230236_b_()) {
            DispenserBlock.func_199774_a((IItemProvider)item, (IDispenseItemBehavior)GROWABLE_DISPENSE_BEHAVIOR);
        }
    }

    public static Section getRandomMidsection() {
        return Math.random() < 0.5 ? Section.MIDDLE_SPROUT : Section.MIDDLE;
    }

    public static int getRandomGrowth() {
        return new Random().nextInt(3) + 1;
    }

    protected void ensureProperState(IWorld level, BlockPos pos) {
        BlockState aboveState = level.func_180495_p(pos.func_177984_a());
        BlockState belowState = level.func_180495_p(pos.func_177977_b());
        if (aboveState.func_203425_a((Block)this)) {
            if (belowState.func_203425_a((Block)this)) {
                this.ensureSectionAt(level, pos, SoulStalkBlock.getRandomMidsection());
            } else {
                this.ensureSectionAt(level, pos, Section.BASE);
            }
        } else if (belowState.func_203425_a((Block)this)) {
            this.ensureSectionAt(level, pos, Section.TOP);
        } else {
            this.ensureSectionAt(level, pos, Section.BUD);
        }
    }

    private void ensureSectionAt(IWorld level, BlockPos pos, Section section) {
        BlockState oldState = level.func_180495_p(pos);
        if (!oldState.func_203425_a((Block)this)) {
            return;
        }
        Section oldSection = (Section)((Object)oldState.func_177229_b(SECTION));
        if (section.isMiddle() ? !oldSection.isMiddle() : oldSection != section) {
            level.func_180501_a(pos, (BlockState)oldState.func_206870_a(SECTION, (Comparable)((Object)section)), 3);
        }
    }

    public void func_225542_b_(BlockState state, ServerWorld level, BlockPos pos, Random rand) {
        if (level.func_175623_d(pos.func_177984_a())) {
            int baseY;
            int topY = SoulStalkBlock.getTopY((World)level, pos);
            if (topY - (baseY = SoulStalkBlock.getBaseY((World)level, pos)) + 1 >= 6) {
                return;
            }
            double minTemp = ConfigSettings.MIN_TEMP.get();
            double maxTemp = ConfigSettings.MAX_TEMP.get();
            double tempAtBase = WorldHelper.getRoughTemperatureAt((World)level, new BlockPos(pos.func_177958_n(), baseY, pos.func_177952_p()));
            if (rand.nextDouble() < 0.05 + CSMath.blend(0.0, 0.95, tempAtBase, minTemp, maxTemp) && ForgeHooks.onCropsGrowPre((World)level, (BlockPos)pos, (BlockState)state, (boolean)true)) {
                SoulStalkBlock.grow((World)level, pos, 1);
            }
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        ItemStack holding = player.func_184586_b(hand);
        if (!level.field_72995_K && ModItemTags.GROWS_SOUL_STALK.func_230235_a_((Object)holding.func_77973_b())) {
            if (SoulStalkBlock.getHeight(level, pos) >= 6) {
                return super.func_225533_a_(state, level, pos, player, hand, rayTraceResult);
            }
            boolean grew = SoulStalkBlock.applyGrowingItem(level, pos);
            if (!player.field_71075_bZ.field_75098_d) {
                holding.func_190918_g(1);
            }
            Vector3d centerPos = CSMath.getCenterPos(pos);
            player.func_226292_a_(hand, true);
            if (grew) {
                WorldHelper.spawnParticleBatch(level, (IParticleData)ParticleTypes.field_239812_C_, centerPos.field_72450_a, centerPos.field_72448_b, centerPos.field_72449_c, 0.75, 0.75, 0.75, 5.0, 0.01);
                level.func_184133_a(null, pos, SoundEvents.field_219692_lA, SoundCategory.BLOCKS, 1.0f, 0.8f);
            } else {
                level.func_184133_a(null, pos, SoundEvents.field_232755_iX_, SoundCategory.BLOCKS, 0.6f, 1.5f);
            }
            return ActionResultType.CONSUME;
        }
        return super.func_225533_a_(state, level, pos, player, hand, rayTraceResult);
    }

    public static boolean applyGrowingItem(World level, BlockPos pos) {
        int baseY;
        int topY = SoulStalkBlock.getTopY(level, pos);
        if (topY - (baseY = SoulStalkBlock.getBaseY(level, pos)) + 1 >= 6) {
            return false;
        }
        return SoulStalkBlock.grow(level, new BlockPos(pos.func_177958_n(), topY, pos.func_177952_p()), SoulStalkBlock.getRandomGrowth());
    }

    public static boolean grow(World level, BlockPos pos, int growth) {
        BlockState state = level.func_180495_p(pos);
        BlockState defaultState = state.func_177230_c().func_176223_P();
        int age = (Integer)state.func_177229_b((Property)AGE) + growth;
        Section section = (Section)((Object)state.func_177229_b(SECTION));
        if (age >= 4) {
            if (section == Section.TOP) {
                level.func_175656_a(pos, (BlockState)((BlockState)defaultState.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0))).func_206870_a(SECTION, (Comparable)((Object)SoulStalkBlock.getRandomMidsection())));
                level.func_175656_a(pos.func_177984_a(), (BlockState)((BlockState)defaultState.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0))).func_206870_a(SECTION, (Comparable)((Object)Section.TOP)));
            } else if (section == Section.BUD) {
                level.func_175656_a(pos, (BlockState)((BlockState)defaultState.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0))).func_206870_a(SECTION, (Comparable)((Object)Section.BASE)));
                level.func_175656_a(pos.func_177984_a(), (BlockState)((BlockState)defaultState.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0))).func_206870_a(SECTION, (Comparable)((Object)Section.TOP)));
            }
            return true;
        }
        level.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(age)), 2);
        return false;
    }

    public static int getHeight(World level, BlockPos pos) {
        return SoulStalkBlock.getTopY(level, pos) - SoulStalkBlock.getBaseY(level, pos) + 1;
    }

    public static int getTopY(World level, BlockPos pos) {
        int aboveHeight = 1;
        while (level.func_180495_p(pos.func_177981_b(aboveHeight)).func_203425_a(ModBlocks.SOUL_STALK)) {
            ++aboveHeight;
        }
        return pos.func_177956_o() + aboveHeight - 1;
    }

    public static int getBaseY(World level, BlockPos pos) {
        int belowHeight = 1;
        while (level.func_180495_p(pos.func_177979_c(belowHeight)).func_203425_a(ModBlocks.SOUL_STALK)) {
            ++belowHeight;
        }
        return pos.func_177956_o() - belowHeight + 1;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        return context.func_195991_k().func_180495_p(pos.func_177977_b()).func_177230_c() == this ? (BlockState)this.func_176223_P().func_206870_a(SECTION, (Comparable)((Object)Section.TOP)) : (this.func_196260_a(this.func_176223_P(), (IWorldReader)context.func_195991_k(), pos) ? this.func_176223_P() : null);
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState otherState, IWorld level, BlockPos pos, BlockPos otherPos) {
        if (level.func_201670_d()) {
            return state;
        }
        if (!this.func_196260_a(state, (IWorldReader)level, pos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (direction == Direction.UP) {
            boolean isUnderSelf = otherState.func_177230_c() == this;
            Section section = (Section)((Object)state.func_177229_b(SECTION));
            switch (section) {
                case TOP: {
                    return isUnderSelf ? (BlockState)state.func_206870_a(SECTION, (Comparable)((Object)SoulStalkBlock.getRandomMidsection())) : state;
                }
                case BUD: {
                    return isUnderSelf ? (BlockState)state.func_206870_a(SECTION, (Comparable)((Object)Section.BASE)) : state;
                }
            }
            if (!isUnderSelf) {
                return Blocks.field_150350_a.func_176223_P();
            }
        }
        this.ensureProperState(level, pos);
        return state;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader getter, BlockPos pos, ISelectionContext context) {
        return state.func_177229_b(SECTION) == Section.BUD ? SHAPE_BUD : SHAPE;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AGE, SECTION});
    }

    public BlockState getPlant(IBlockReader level, BlockPos pos) {
        return this.func_176223_P();
    }

    public boolean func_196260_a(BlockState state, IWorldReader level, BlockPos pos) {
        BlockState below = level.func_180495_p(pos.func_177977_b());
        return below.func_235714_a_(ModBlockTags.SOUL_STALK_PLACEABLE_ON) || below.func_177230_c() == this;
    }

    public static enum Section implements StringRepresentable
    {
        BASE("base"),
        MIDDLE("middle"),
        MIDDLE_SPROUT("middle_sprout"),
        TOP("top"),
        BUD("bud");

        private final String name;

        private Section(String name) {
            this.name = name;
        }

        public boolean hasFruit() {
            return this == TOP || this == MIDDLE_SPROUT || this == BUD;
        }

        public boolean isMiddle() {
            return this == MIDDLE || this == MIDDLE_SPROUT;
        }

        @Override
        public String func_176610_l() {
            return this.name;
        }
    }
}

