/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.event;

import com.momosoftworks.coldsweat.ColdSweat;
import java.lang.reflect.Field;
import javax.annotation.Nullable;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.RecipeBookContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

@Mod.EventBusSubscriber
public class BoilerRecipeOverride {
    private static final Field SLOT_CRAFT_CONTAINER = ObfuscationReflectionHelper.findField(CraftingResultSlot.class, (String)"field_75239_a");

    @SubscribeEvent
    public static void onCraftingTableOpen(PlayerContainerEvent.Open event) {
        if (event.getContainer() instanceof RecipeBookContainer && ((RecipeBookContainer)event.getContainer()).func_201770_g() == 3 && ((RecipeBookContainer)event.getContainer()).func_201772_h() == 3) {
            final RecipeBookContainer crafting = (RecipeBookContainer)event.getContainer();
            MinecraftServer server = event.getEntity().func_184102_h();
            if (server == null) {
                return;
            }
            final IRecipe boilerRecipe = server.func_199529_aN().func_215367_a(new ResourceLocation("cold_sweat", "boiler")).orElse(null);
            if (boilerRecipe == null) {
                return;
            }
            crafting.func_75132_a(new IContainerListener(){

                public void func_71111_a(Container sendingContainer, int slotId, ItemStack stack) {
                    Slot slot = sendingContainer.func_75139_a(slotId);
                    if (slot instanceof CraftingResultSlot && crafting.func_201769_a(boilerRecipe)) {
                        slot.func_75215_d(boilerRecipe.func_77572_b((IInventory)BoilerRecipeOverride.getCraftingContainer(slot)));
                    }
                }

                public void func_71112_a(Container pContainerMenu, int pDataSlotIndex, int pValue) {
                }

                public void func_71110_a(Container pContainerToSend, NonNullList<ItemStack> pItemsList) {
                }
            });
        }
    }

    @Nullable
    private static CraftingInventory getCraftingContainer(Slot slot) {
        try {
            return (CraftingInventory)SLOT_CRAFT_CONTAINER.get(slot);
        }
        catch (IllegalAccessException e) {
            ColdSweat.LOGGER.error("Failed to get crafting container from ResultSlot", (Throwable)e);
            return null;
        }
    }

    static {
        SLOT_CRAFT_CONTAINER.setAccessible(true);
    }
}

