/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.compat.kubejs;

import com.momosoftworks.coldsweat.api.event.common.insulation.InsulateItemEvent;
import com.momosoftworks.coldsweat.api.event.common.temperautre.TempModifierEvent;
import com.momosoftworks.coldsweat.api.event.common.temperautre.TemperatureChangedEvent;
import com.momosoftworks.coldsweat.api.event.core.init.DefaultTempModifiersEvent;
import com.momosoftworks.coldsweat.api.event.core.registry.LoadRegistriesEvent;
import com.momosoftworks.coldsweat.compat.kubejs.KubeEventSignatures;
import com.momosoftworks.coldsweat.compat.kubejs.event.AddModifierEventJS;
import com.momosoftworks.coldsweat.compat.kubejs.event.ApplyInsulationEventJS;
import com.momosoftworks.coldsweat.compat.kubejs.event.DefaultModifiersEventJS;
import com.momosoftworks.coldsweat.compat.kubejs.event.ModRegistriesEventJS;
import com.momosoftworks.coldsweat.compat.kubejs.event.TempChangedEventJS;
import dev.latvian.kubejs.script.ScriptType;
import me.shedaniel.architectury.event.EventResult;

public class KubeEventHandlers {
    public static final String COLD_SWEAT = "cs:";
    public static final String REGISTER = KubeEventHandlers.event("registries");
    public static final String GATHER_DEFAULT_MODIFIERS = KubeEventHandlers.event("gatherDefaultModifiers");
    public static final String TEMP_CHANGED = KubeEventHandlers.event("temperatureChanged");
    public static final String MODIFIER_ADD = KubeEventHandlers.event("addModifier");
    public static final String APPLY_INSULATION = KubeEventHandlers.event("applyInsulation");

    public static void init() {
        KubeEventSignatures.REGISTRIES.register(KubeEventHandlers::buildRegistries);
        KubeEventSignatures.GATHER_MODIFIERS.register(KubeEventHandlers::gatherDefaultModifiers);
        KubeEventSignatures.TEMPERATURE_CHANGED.register(KubeEventHandlers::onTemperatureChanged);
        KubeEventSignatures.INSULATE_ITEM.register(KubeEventHandlers::onInsulateItem);
        KubeEventSignatures.ADD_MODIFIER.register(KubeEventHandlers::onTempModifierAdd);
    }

    private static void buildRegistries(LoadRegistriesEvent.Pre event) {
        new ModRegistriesEventJS(event).post(ScriptType.SERVER, REGISTER);
    }

    private static void gatherDefaultModifiers(DefaultTempModifiersEvent event) {
        new DefaultModifiersEventJS(event).post(ScriptType.SERVER, GATHER_DEFAULT_MODIFIERS);
    }

    private static String event(String name) {
        return COLD_SWEAT + name;
    }

    static EventResult onTemperatureChanged(TemperatureChangedEvent event) {
        ScriptType scriptType = event.getEntity().field_70170_p.field_72995_K ? ScriptType.CLIENT : ScriptType.SERVER;
        return EventResult.interrupt((Boolean)(!new TempChangedEventJS(event).post(scriptType, TEMP_CHANGED) ? 1 : 0));
    }

    private static EventResult onInsulateItem(InsulateItemEvent event) {
        ScriptType scriptType = event.getPlayer().field_70170_p.field_72995_K ? ScriptType.CLIENT : ScriptType.SERVER;
        return EventResult.interrupt((Boolean)(!new ApplyInsulationEventJS(event).post(scriptType, APPLY_INSULATION) ? 1 : 0));
    }

    private static EventResult onTempModifierAdd(TempModifierEvent.Add event) {
        ScriptType scriptType = event.getEntity().field_70170_p.field_72995_K ? ScriptType.CLIENT : ScriptType.SERVER;
        return EventResult.interrupt((Boolean)(!new AddModifierEventJS(event).post(scriptType, MODIFIER_ADD) ? 1 : 0));
    }
}

