/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.config.spec;

import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.util.serialization.ListBuilder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class EntitySettingsConfig {
    private static final ForgeConfigSpec SPEC;
    private static final ForgeConfigSpec.Builder BUILDER;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> INSULATED_MOUNTS;
    public static final ForgeConfigSpec.ConfigValue<List<?>> GOAT_FUR_GROWTH_STATS;
    public static final ForgeConfigSpec.ConfigValue<List<?>> CHAMELEON_SHED_STATS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> CHAMELEON_SPAWN_BIOMES;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> GOAT_SPAWN_BIOMES;
    public static final ForgeConfigSpec.BooleanValue CHAMELEON_SHED_AUTOMATICALLY;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> ENTITY_TEMPERATURES;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> ENTITY_CLIMATES;
    public static final ForgeConfigSpec.BooleanValue ENABLE_ENTITY_CLIMATES;
    public static final ForgeConfigSpec.BooleanValue ADVANCED_ENTITY_TEMPERATURE;

    public static void setup() {
        Path configPath = FMLPaths.CONFIGDIR.get();
        Path csConfigPath = Paths.get(configPath.toAbsolutePath().toString(), "coldsweat");
        try {
            Files.createDirectory(csConfigPath, new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, SPEC, "coldsweat/entity.toml");
    }

    public static void save() {
        SPEC.save();
    }

    static {
        BUILDER = new ForgeConfigSpec.Builder();
        BUILDER.comment(new String[]{"\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Anywhere that uses entity IDs also supports:", " \u2022 Tags (e.g. \"#minecraft:skeletons\")", " \u2022 Comma-separated lists (e.g. \"minecraft:zombie,#minecraft:skeletons\")", "     Applies the setting to all listed IDs. Can use tags, regular IDs, and negation interchangeably", " \u2022 Negation (e.g. \"!minecraft:evoker\")", "     Useful with lists/tags. Excludes the listed IDs from the setting", "     i.e. \"#minecraft:raiders,!minecraft:evoker\" (all raid mobs EXCEPT evokers)", " Settings with \"//v\" will list elements vertically. Removing \"//v\" will list elements in one line", "\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500"});
        BUILDER.push("Entity Temperature");
        INSULATED_MOUNTS = BUILDER.comment(new String[]{"\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v", " List of entities that will insulate the player when riding them", " A value of 0 provides no insulation; 1 provides full insulation", " \u2514\u2500\u2500 Format: [[\"entity_id\", coldResistance, heatResistance], [...], etc]", " \u2304 "}).defineListAllowEmpty(Arrays.asList("Insulated Mounts"), () -> Arrays.asList(new List[0]), it -> {
            if (it instanceof List) {
                List list = (List)it;
                return list.size() == 3 && list.get(0) instanceof String && list.get(1) instanceof Number && list.get(2) instanceof Number;
            }
            return false;
        });
        ENTITY_TEMPERATURES = BUILDER.comment(new String[]{"\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v", " Defines temperature-emitting properties for entities", " \u251c\u2500\u2500 Format: [[\"entity_id\", temperature, range, *units, *tempLimit], [...], etc]", " \u2514\u2500\u2500 [* = optional]", " \u2022 temperature: The temperature emitted by the entity", " \u2022 range: The range of the effect, in blocks", " \u2022 units: (Optional) The units of the temperature value (MC, F, or C). Defaults to MC", " \u2022 *tempLimit: The maximum world temperature at which this entity temp will have any effect.", "   (Represents the minimum temp if the entity temp is negative)", " \u2304 "}).defineListAllowEmpty(Arrays.asList("Entity Temperatures"), () -> Arrays.asList(new List[0]), it -> {
            if (it instanceof List) {
                List list = (List)it;
                return list.size() >= 3 && list.get(0) instanceof String && list.get(1) instanceof Number && list.get(2) instanceof Number && (list.size() < 4 || list.get(3) instanceof String && (list.size() < 5 || list.get(4) instanceof Number));
            }
            return false;
        });
        ENTITY_CLIMATES = BUILDER.comment(new String[]{"\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v", " Defines entities that are affected by temperature and the climates they can live in", " \u251c\u2500\u2500 Format: [[\"entity_id\", minTemp, maxTemp, *rate, *units], [...], etc]", " \u2514\u2500\u2500 [* = optional]", " \u2022 min_temp: The minimum livable temperature, as an offset to the minimum temperature for players", " \u2022 max_temp: The maximum livable temperature, as an offset to the maximum temperature for players", " \u2022 *rate: A multiplier to the rate at which the entity overheats or freezes, based on players' rate", " \u2022 *units: The units used for the min/max temperature values (MC, F, or C). Defaults to MC", " \u2304 "}).defineListAllowEmpty(Arrays.asList("Entity Climate Settings"), () -> Arrays.asList(Arrays.asList("minecraft:chicken", 10, 10, 0.6, "F"), Arrays.asList("minecraft:pig", 0, 0, 0.5, "F"), Arrays.asList("minecraft:cow", 0, 20, 0.2, "F"), Arrays.asList("minecraft:mooshroom", 0, 20, 0.2, "F"), Arrays.asList("minecraft:sheep", -20, -10, 0.3, "F"), Arrays.asList("cold_sweat:goat", -40, -15, 0.4, "F"), Arrays.asList("minecraft:horse", -5, 10, 0.3, "F"), Arrays.asList("minecraft:donkey", -5, 10, 0.3, "F"), Arrays.asList("minecraft:mule", -5, 10, 0.3, "F"), Arrays.asList("minecraft:llama", -10, 0, 0.4, "F")), it -> !(!(it instanceof List) || ((List)it).size() < 3 || !(((List)it).get(0) instanceof String) || !(((List)it).get(1) instanceof Number) || !(((List)it).get(2) instanceof Number) || ((List)it).size() >= 4 && !(((List)it).get(3) instanceof Number) || ((List)it).size() >= 5 && !(((List)it).get(4) instanceof String)));
        ENABLE_ENTITY_CLIMATES = BUILDER.comment(new String[]{"\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Enables the temperature system for entities", " If disabled, entities will not be harmed by temperature", " \u2304 "}).define("Enable Entity Climates", false);
        ADVANCED_ENTITY_TEMPERATURE = BUILDER.comment(new String[]{"\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Enables more precise temperature calculations for entities", " This option might cause performance issues for large amounts of entities", " \u2304 "}).define("Use Advanced Entity Climates", false);
        BUILDER.pop();
        BUILDER.push("Fur Growth & Shedding");
        GOAT_FUR_GROWTH_STATS = BUILDER.comment(new String[]{"\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Defines how often a goat will try to grow its fur, the growth cooldown after shearing, and the chance of it succeeding", " \u2514\u2500\u2500 Format: [interval, cooldown, chance]", " \u2304 "}).defineList("Goat Fur Growth Timings", Arrays.asList(1200, 2400, 0.2), it -> it instanceof Number);
        CHAMELEON_SHED_STATS = BUILDER.comment(new String[]{"\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Defines how often a chameleon will try to shed its skin, the cooldown after shedding, and the chance of it succeeding", " Format: [interval, cooldown, chance]", " \u2304 "}).defineList("Chameleon Shedding Timings", Arrays.asList(400, 36000, 0.1), it -> it instanceof Number);
        CHAMELEON_SHED_AUTOMATICALLY = BUILDER.comment(new String[]{"\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " If true, chameleons will automatically shed their skin over time", " If false, chameleons will only shed when a player interacts with them", " \u2304 "}).define("Chameleons Shed Automatically", false);
        BUILDER.pop();
        BUILDER.push("Mob Spawning");
        CHAMELEON_SPAWN_BIOMES = BUILDER.comment(new String[]{"\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v", " Defines the biomes that Chameleons can spawn in", " \u2514\u2500\u2500 Format: [[\"biome_id\", weight], [...], etc]", " \u2022 biome_id: The ID of the biome, e.g. \"minecraft:jungle\"", " \u2022 weight: The likelihood for the entity to spawn compared to other entities, higher values mean more common spawns", " \u2304 "}).defineListAllowEmpty(Arrays.asList("Chameleon Spawn Biomes"), () -> ListBuilder.begin(new List[]{Arrays.asList("minecraft:bamboo_jungle", 80), Arrays.asList("minecraft:jungle", 80), Arrays.asList("minecraft:desert", 1)}).addIf(CompatManager.isBiomesOPlentyLoaded(), () -> Arrays.asList("biomesoplenty:lush_desert", 3), () -> Arrays.asList("biomesoplenty:rainforest", 40), () -> Arrays.asList("biomesoplenty:rainforest_cliffs", 15), () -> Arrays.asList("biomesoplenty:rainforest_floodplain", 7), () -> Arrays.asList("biomesoplenty:fungal_jungle", 10), () -> Arrays.asList("biomesoplenty:tropics", 8), () -> Arrays.asList("biomesoplenty:outback", 2)).addIf(CompatManager.isBiomesYoullGoLoaded(), () -> Arrays.asList("byg:tropical_rainforest", 60), () -> Arrays.asList("byg:jacaranda_forest", 3), () -> Arrays.asList("byg:guiana_shield", 10), () -> Arrays.asList("byg:guiana_clearing", 3), () -> Arrays.asList("byg:crag_gardens", 8), () -> Arrays.asList("byg:lush_red_desert", 3), () -> Arrays.asList("byg:red_desert", 2), () -> Arrays.asList("byg:red_rock_mountains", 2), () -> Arrays.asList("byg:mojave_desert", 1)).addIf(CompatManager.isAtmosphericLoaded(), () -> Arrays.asList("atmospheric:dunes", 0.75), () -> Arrays.asList("atmospheric:flourishing_dunes", 1.5), () -> Arrays.asList("atmospheric:rocky_dunes", 0.75), () -> Arrays.asList("atmospheric:petrified_dunes", 0.5), () -> Arrays.asList("atmospheric:rainforest", 70), () -> Arrays.asList("atmospheric:rainforest_mountains", 70), () -> Arrays.asList("atmospheric:rainforest_plateau", 70), () -> Arrays.asList("atmospheric:rainforest_basin", 50), () -> Arrays.asList("atmospheric:sparse_rainforest_plateau", 40), () -> Arrays.asList("atmospheric:sparse_rainforest_basin", 30)).build(), it -> {
            if (it instanceof List) {
                List list = (List)it;
                return list.size() == 2 && list.get(0) instanceof String && list.get(1) instanceof Number;
            }
            return false;
        });
        GOAT_SPAWN_BIOMES = BUILDER.comment(new String[]{"\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v", " Defines the biomes that Chameleons can spawn in", " \u2514\u2500\u2500 Format: [[\"biome_id\", weight], [...], etc]", " \u2022 biome_id: The ID of the biome, e.g. \"minecraft:jungle\"", " \u2022 weight: The likelihood for the entity to spawn compared to other entities, higher values mean more common spawns", " \u2304 "}).defineListAllowEmpty(Arrays.asList("Goat Spawn Biomes"), () -> ListBuilder.begin(new List[]{Arrays.asList("minecraft:mountains", 10), Arrays.asList("minecraft:wooded_mountains", 12), Arrays.asList("minecraft:snowy_taiga_mountains", 12), Arrays.asList("minecraft:taiga_mountains", 10), Arrays.asList("minecraft:gravelly_mountains", 8)}).addIf(CompatManager.isBiomesOPlentyLoaded(), () -> Arrays.asList("biomesoplenty:boreal_forest", 5), () -> Arrays.asList("biomesoplenty:snowy_coniferous_forest", 5), () -> Arrays.asList("biomesoplenty:jade_cliffs", 4)).addIf(CompatManager.isBiomesYoullGoLoaded(), () -> Arrays.asList("byg:alps", 16), () -> Arrays.asList("byg:bluff_steeps", 8), () -> Arrays.asList("byg:bluff_peaks", 8), () -> Arrays.asList("byg:grassland_plateau", 4), () -> Arrays.asList("byg:guiana_clearing", 3), () -> Arrays.asList("byg:stone_forest", 128), () -> Arrays.asList("byg:shattered_glacier", 6), () -> Arrays.asList("byg:skyris_highlands", 6), () -> Arrays.asList("byg:dover_mountains", 5)).build(), it -> {
            if (it instanceof List) {
                List list = (List)it;
                return list.size() == 2 && list.get(0) instanceof String && list.get(1) instanceof Number;
            }
            return false;
        });
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

