/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.network.message;

import com.momosoftworks.coldsweat.core.network.BufferHelper;
import com.momosoftworks.coldsweat.core.network.ColdSweatPacketHandler;
import com.momosoftworks.coldsweat.core.network.message.SyncConfigSettingsMessage;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class ClientConfigAskMessage {
    UUID openerUUID;

    public ClientConfigAskMessage(UUID openerUUID) {
        this.openerUUID = openerUUID;
    }

    public ClientConfigAskMessage() {
        this(null);
    }

    public static void encode(ClientConfigAskMessage message, PacketBuffer buffer) {
        BufferHelper.writeOptional(buffer, Optional.ofNullable(message.openerUUID), PacketBuffer::func_179252_a);
    }

    public static ClientConfigAskMessage decode(PacketBuffer buffer) {
        return new ClientConfigAskMessage(BufferHelper.readOptional(buffer, PacketBuffer::func_179253_g).orElse(null));
    }

    public static void handle(ClientConfigAskMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (context.getDirection().getReceptionSide().isServer()) {
                ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> ((NetworkEvent.Context)context).getSender()), (Object)new SyncConfigSettingsMessage(message.openerUUID, context.getSender().field_70170_p.func_241828_r()));
            }
        });
        context.setPacketHandled(true);
    }
}

