/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.network.message;

import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.core.network.ColdSweatPacketHandler;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ParticleBatchMessage {
    private static final BinaryOperator<Vector3d> MIN_POS_COMPARATOR = (a, b) -> new Vector3d(Math.min(a.field_72450_a, b.field_72450_a), Math.min(a.field_72448_b, b.field_72448_b), Math.min(a.field_72449_c, b.field_72449_c));
    private static final BinaryOperator<Vector3d> MAX_POS_COMPARATOR = (a, b) -> new Vector3d(Math.max(a.field_72450_a, b.field_72450_a), Math.max(a.field_72448_b, b.field_72448_b), Math.max(a.field_72449_c, b.field_72449_c));
    Set<Pair<IParticleData, ParticlePlacement>> particles = new HashSet<Pair<IParticleData, ParticlePlacement>>();
    int minSetting;

    public ParticleBatchMessage(int minSetting) {
        this.minSetting = minSetting;
    }

    public ParticleBatchMessage() {
        this(-1);
    }

    public ParticleBatchMessage addParticle(IParticleData particle, ParticlePlacement placement) {
        this.particles.add((Pair<IParticleData, ParticlePlacement>)Pair.of((Object)particle, (Object)placement));
        return this;
    }

    public ParticleBatchMessage addParticle(IParticleData particle, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this.addParticle(particle, new ParticlePlacement(x, y, z, xSpeed, ySpeed, zSpeed));
        return this;
    }

    public void sendEntity(Entity entity) {
        if (this.particles.isEmpty() || entity.field_70170_p.func_201670_d()) {
            return;
        }
        ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)this);
    }

    public void sendWorld(World level) {
        if (this.particles.isEmpty() || level.func_201670_d()) {
            return;
        }
        Vector3d minPos = this.particles.stream().map(Pair::getSecond).map(p -> new Vector3d(p.x, p.y, p.z)).reduce(MIN_POS_COMPARATOR).get();
        Vector3d maxPos = this.particles.stream().map(Pair::getSecond).map(p -> new Vector3d(p.x, p.y, p.z)).reduce(MAX_POS_COMPARATOR).get();
        Vector3d midPos = minPos.func_178787_e(maxPos).func_186678_a(0.5);
        PacketDistributor.TargetPoint target = new PacketDistributor.TargetPoint(midPos.field_72450_a, midPos.field_72448_b, midPos.field_72449_c, minPos.func_72438_d(maxPos) + 32.0, level.func_234923_W_());
        ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> target), (Object)this);
    }

    public static void encode(ParticleBatchMessage message, PacketBuffer buffer) {
        buffer.writeInt(message.minSetting);
        buffer.writeInt(message.particles.size());
        for (Pair<IParticleData, ParticlePlacement> entry : message.particles) {
            String particleID = ForgeRegistries.PARTICLE_TYPES.getKey((IForgeRegistryEntry)((IParticleData)entry.getFirst()).func_197554_b()).toString();
            buffer.writeInt(particleID.length());
            buffer.writeCharSequence((CharSequence)particleID, StandardCharsets.UTF_8);
            ((IParticleData)entry.getFirst()).func_197553_a(buffer);
            buffer.func_150786_a(((ParticlePlacement)entry.getSecond()).toNBT());
        }
    }

    public static ParticleBatchMessage decode(PacketBuffer buffer) {
        ParticleBatchMessage message = new ParticleBatchMessage(buffer.readInt());
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            int particleIDLength = buffer.readInt();
            ParticleType type = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(new ResourceLocation(buffer.readCharSequence(particleIDLength, StandardCharsets.UTF_8).toString()));
            IParticleData particle = type.func_197571_g().func_197543_b(type, buffer);
            ParticlePlacement placement = ParticlePlacement.fromNBT(buffer.func_150793_b());
            message.addParticle(particle, placement);
        }
        return message;
    }

    public static void handle(ParticleBatchMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> {
                for (Pair<IParticleData, ParticlePlacement> entry : message.particles) {
                    IParticleData particle = (IParticleData)entry.getFirst();
                    ParticlePlacement placement = (ParticlePlacement)entry.getSecond();
                    if (message.minSetting != -1 && Minecraft.func_71410_x().field_71474_y.field_74362_aa.func_216832_b() > message.minSetting) continue;
                    Minecraft.func_71410_x().field_71441_e.func_195594_a(particle, placement.x, placement.y, placement.z, placement.vx, placement.vy, placement.vz);
                }
            });
        }
        context.setPacketHandled(true);
    }

    public static class ParticlePlacement {
        double x;
        double y;
        double z;
        double vx;
        double vy;
        double vz;

        public ParticlePlacement(double x, double y, double z, double vx, double vy, double vz) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.vx = vx;
            this.vy = vy;
            this.vz = vz;
        }

        public CompoundNBT toNBT() {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74780_a("x", this.x);
            tag.func_74780_a("y", this.y);
            tag.func_74780_a("z", this.z);
            tag.func_74780_a("vx", this.vx);
            tag.func_74780_a("vy", this.vy);
            tag.func_74780_a("vz", this.vz);
            return tag;
        }

        public static ParticlePlacement fromNBT(CompoundNBT tag) {
            return new ParticlePlacement(tag.func_74769_h("x"), tag.func_74769_h("y"), tag.func_74769_h("z"), tag.func_74769_h("vx"), tag.func_74769_h("vy"), tag.func_74769_h("vz"));
        }
    }
}

