/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.impl.RequirementHolder;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityRequirement;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.tags.ITag;

public class EntityClimateData
extends ConfigData
implements RequirementHolder {
    final NegatableList<EntityRequirement> entity;
    final double minTemp;
    final double maxTemp;
    final double rate;
    final Temperature.Units units;
    public static final Codec<EntityClimateData> CODEC = EntityClimateData.createCodec(RecordCodecBuilder.mapCodec(instance -> instance.group((App)NegatableList.codec(EntityRequirement.getCodec()).optionalFieldOf("entity", new NegatableList()).forGetter(EntityClimateData::entity), (App)Codec.DOUBLE.fieldOf("min_temp_offset").forGetter(EntityClimateData::minTempOffset), (App)Codec.DOUBLE.fieldOf("max_temp_offset").forGetter(EntityClimateData::maxTempOffset), (App)Codec.DOUBLE.optionalFieldOf("rate", (Object)1.0).forGetter(EntityClimateData::rate), (App)Temperature.Units.CODEC.optionalFieldOf("units", (Object)Temperature.Units.MC).forGetter(EntityClimateData::units)).apply((Applicative)instance, EntityClimateData::new)));

    public EntityClimateData(NegatableList<EntityRequirement> entity, double minTemp, double maxTemp, double rate, Temperature.Units units, NegatableList<String> requiredMods) {
        super(requiredMods);
        this.entity = entity;
        this.minTemp = minTemp;
        this.maxTemp = maxTemp;
        this.rate = rate;
        this.units = units;
    }

    public EntityClimateData(NegatableList<EntityRequirement> entity, double minTemp, double maxTemp, double rate, Temperature.Units units) {
        this(entity, minTemp, maxTemp, rate, units, new NegatableList<String>());
    }

    public NegatableList<EntityRequirement> entity() {
        return this.entity;
    }

    public double minTempOffset() {
        return this.minTemp;
    }

    public double maxTempOffset() {
        return this.maxTemp;
    }

    public double rate() {
        return this.rate;
    }

    public Temperature.Units units() {
        return this.units;
    }

    public double getMinOffset() {
        return Temperature.convert(this.minTemp, this.units, Temperature.Units.MC, false);
    }

    public double getMaxOffset() {
        return Temperature.convert(this.maxTemp, this.units, Temperature.Units.MC, false);
    }

    @Nullable
    public static EntityClimateData fromToml(List<?> entry) {
        Temperature.Units units;
        if (entry.size() < 3) {
            ColdSweat.LOGGER.error("Error parsing entity temp config: not enough arguments");
            return null;
        }
        NegatableList<Either<ITag<EntityType<?>>, EntityType<?>>> entities = ConfigHelper.getEntityTypes((String)entry.get(0));
        if (entities.isEmpty()) {
            return null;
        }
        double minTemp = ((Number)entry.get(1)).doubleValue();
        double maxTemp = ((Number)entry.get(2)).doubleValue();
        double rate = entry.size() > 3 ? ((Number)entry.get(3)).doubleValue() : 1.0;
        Temperature.Units units2 = units = entry.size() > 4 ? Temperature.Units.fromID(((String)entry.get(4)).toLowerCase(Locale.ROOT)) : Temperature.Units.MC;
        if (units == null) {
            ColdSweat.LOGGER.error("Error parsing temperature-affected entity config {}: invalid temperature units", entry);
            return null;
        }
        return new EntityClimateData(new NegatableList<EntityRequirement>(new EntityRequirement(entities)), minTemp, maxTemp, rate, units);
    }

    @Override
    public boolean test(Entity entity) {
        return this.entity.test((T req) -> req.test(entity));
    }

    public Codec<EntityClimateData> getCodec() {
        return CODEC;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EntityClimateData that = (EntityClimateData)obj;
        return super.equals(obj) && this.entity.equals(that.entity) && Objects.equals(this.minTemp, that.minTemp) && Objects.equals(this.maxTemp, that.maxTemp) && Objects.equals(this.rate, that.rate) && this.units == that.units;
    }
}

