/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.registry.Registry;

public class EffectsRequirement {
    private final Map<Effect, Instance> effects;
    public static final Codec<EffectsRequirement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Registry.field_212631_t, Instance.CODEC).fieldOf("effects").forGetter(predicate -> predicate.effects)).apply((Applicative)instance, EffectsRequirement::new));

    public EffectsRequirement(Map<Effect, Instance> effects) {
        this.effects = effects;
    }

    public Map<Effect, Instance> effects() {
        return this.effects;
    }

    public boolean test(Entity entity) {
        return !(entity instanceof LivingEntity) || this.test(((LivingEntity)entity).func_70651_bq());
    }

    public boolean test(Collection<EffectInstance> effects) {
        for (Map.Entry<Effect, Instance> entry : this.effects.entrySet()) {
            Effect effect = entry.getKey();
            Instance instance = entry.getValue();
            int amplifier = 0;
            int duration = 0;
            boolean ambient = true;
            boolean visible = true;
            for (EffectInstance effectInstance : effects) {
                if (effectInstance.func_188419_a() != effect) continue;
                amplifier = effectInstance.func_76458_c();
                duration = effectInstance.func_76459_b();
                ambient = effectInstance.func_82720_e();
                visible = effectInstance.func_188418_e();
                break;
            }
            if (!instance.amplifier.test(amplifier) || !instance.duration.test(duration)) {
                return false;
            }
            if (instance.ambient.isPresent() && (Boolean)instance.ambient.get() != ambient) {
                return false;
            }
            if (!instance.visible.isPresent() || (Boolean)instance.visible.get() == visible) continue;
            return false;
        }
        return true;
    }

    public boolean test(EffectInstance effect) {
        Instance instance = this.effects.get(effect.func_188419_a());
        if (instance == null) {
            return true;
        }
        return !(!instance.amplifier.test(effect.func_76458_c()) || !instance.duration.test(effect.func_76459_b()) || instance.ambient.isPresent() && ((Boolean)instance.ambient.get()).booleanValue() != effect.func_82720_e() || instance.visible.isPresent() && ((Boolean)instance.visible.get()).booleanValue() != effect.func_188418_e());
    }

    public String toString() {
        return CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("serialize_failed");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EffectsRequirement that = (EffectsRequirement)obj;
        return this.effects.equals(that.effects);
    }

    public static class Instance {
        private final IntegerBounds amplifier;
        private final IntegerBounds duration;
        private final Optional<Boolean> ambient;
        private final Optional<Boolean> visible;
        public static final Codec<Instance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IntegerBounds.CODEC.fieldOf("amplifier").forGetter(effect -> effect.amplifier), (App)IntegerBounds.CODEC.fieldOf("duration").forGetter(effect -> effect.duration), (App)Codec.BOOL.optionalFieldOf("ambient").forGetter(effect -> effect.ambient), (App)Codec.BOOL.optionalFieldOf("visible").forGetter(effect -> effect.visible)).apply((Applicative)instance, Instance::new));

        public Instance(IntegerBounds amplifier, IntegerBounds duration, Optional<Boolean> ambient, Optional<Boolean> visible) {
            this.amplifier = amplifier;
            this.duration = duration;
            this.ambient = ambient;
            this.visible = visible;
        }

        public String toString() {
            return CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("serialize_failed");
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Instance that = (Instance)obj;
            return this.amplifier.equals(that.amplifier) && this.duration.equals(that.duration) && this.ambient.equals(that.ambient) && this.visible.equals(that.visible);
        }
    }
}

