/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.impl.RequirementHolder;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.sub_type.EntitySubRequirement;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.entity.EntityHelper;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.GameType;
import net.minecraft.world.World;

public class PlayerDataRequirement
implements EntitySubRequirement,
RequirementHolder {
    private final Optional<GameType> gameType;
    private final NegatableList<StatRequirement> stats;
    private final Optional<Map<ResourceLocation, Boolean>> recipes;
    private final Optional<Map<ResourceLocation, Either<AdvancementCompletionRequirement, AdvancementCriteriaRequirement>>> advancements;
    private final EntityRequirement lookingAt;

    @Override
    public MapCodec<? extends EntitySubRequirement> getCodec() {
        return PlayerDataRequirement.getCodec(EntityRequirement.getCodec());
    }

    public static MapCodec<PlayerDataRequirement> getCodec(Codec<EntityRequirement> lastCodec) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.xmap(GameType::func_77142_a, GameType::func_77149_b).optionalFieldOf("game_mode").forGetter(PlayerDataRequirement::gameType), (App)NegatableList.listCodec(StatRequirement.CODEC).optionalFieldOf("stats", new NegatableList()).forGetter(PlayerDataRequirement::stats), (App)Codec.unboundedMap((Codec)ResourceLocation.field_240908_a_, (Codec)Codec.BOOL).optionalFieldOf("recipes").forGetter(PlayerDataRequirement::recipes), (App)Codec.unboundedMap((Codec)ResourceLocation.field_240908_a_, (Codec)Codec.either(AdvancementCompletionRequirement.CODEC, AdvancementCriteriaRequirement.CODEC)).optionalFieldOf("advancements").forGetter(PlayerDataRequirement::advancements), (App)lastCodec.optionalFieldOf("looking_at", (Object)EntityRequirement.NONE).forGetter(PlayerDataRequirement::lookingAt)).apply((Applicative)instance, PlayerDataRequirement::new));
    }

    public PlayerDataRequirement(Optional<GameType> gameType, NegatableList<StatRequirement> stats, Optional<Map<ResourceLocation, Boolean>> recipes, Optional<Map<ResourceLocation, Either<AdvancementCompletionRequirement, AdvancementCriteriaRequirement>>> advancements, EntityRequirement lookingAt) {
        this.gameType = gameType;
        this.stats = stats;
        this.recipes = recipes;
        this.advancements = advancements;
        this.lookingAt = lookingAt;
    }

    public Optional<GameType> gameType() {
        return this.gameType;
    }

    public NegatableList<StatRequirement> stats() {
        return this.stats;
    }

    public Optional<Map<ResourceLocation, Boolean>> recipes() {
        return this.recipes;
    }

    public Optional<Map<ResourceLocation, Either<AdvancementCompletionRequirement, AdvancementCriteriaRequirement>>> advancements() {
        return this.advancements;
    }

    public EntityRequirement lookingAt() {
        return this.lookingAt;
    }

    @Override
    public boolean test(Entity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        ServerPlayerEntity serverPlayer = EntityHelper.getServerPlayer(player);
        if (this.gameType.isPresent() && EntityHelper.getGameModeForPlayer(player) != this.gameType.get()) {
            return false;
        }
        if (!this.stats.test((T stat) -> stat.test(stat.stat(), serverPlayer.func_147099_x().func_77444_a(stat.stat())))) {
            return false;
        }
        if (this.recipes.isPresent()) {
            for (Map.Entry<ResourceLocation, Boolean> entry : this.recipes.get().entrySet()) {
                if (serverPlayer.func_192037_E().func_226144_b_(entry.getKey()) == entry.getValue().booleanValue()) continue;
                return false;
            }
        }
        if (this.advancements.isPresent()) {
            for (Map.Entry<ResourceLocation, Boolean> entry : this.advancements.get().entrySet()) {
                AdvancementProgress progress = serverPlayer.func_192039_O().func_192747_a(serverPlayer.func_184102_h().func_191949_aK().func_192778_a(entry.getKey()));
                if (!((Boolean)((Either)entry.getValue()).map(complete -> complete.test(progress), criteria -> criteria.test(progress))).booleanValue()) continue;
                return false;
            }
        }
        if (this.lookingAt != EntityRequirement.NONE) {
            Vector3d vec3 = player.func_174824_e(0.0f);
            Vector3d vector3d = player.func_70676_i(1.0f);
            Vector3d vec32 = vec3.func_72441_c(vector3d.field_72450_a * 100.0, vector3d.field_72448_b * 100.0, vector3d.field_72449_c * 100.0);
            EntityRayTraceResult entityhitresult = ProjectileHelper.func_221269_a((World)player.field_70170_p, (Entity)player, (Vector3d)vec3, (Vector3d)vec32, (AxisAlignedBB)new AxisAlignedBB(vec3, vec32).func_186662_g(1.0), ent -> !ent.func_175149_v());
            if (entityhitresult == null || entityhitresult.func_216346_c() != RayTraceResult.Type.ENTITY) {
                return false;
            }
            Entity hitEntity = entityhitresult.func_216348_a();
            if (!this.lookingAt.test(hitEntity)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean test(Entity entity, World level, Vector3d position) {
        return this.test(entity);
    }

    public String toString() {
        return CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("serialize_failed");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PlayerDataRequirement that = (PlayerDataRequirement)obj;
        return this.gameType.equals(that.gameType) && this.stats.equals(that.stats) && this.recipes.equals(that.recipes) && this.advancements.equals(that.advancements) && this.lookingAt.equals(that.lookingAt);
    }

    public static class AdvancementCriteriaRequirement {
        private final Map<String, Boolean> criteria;
        public static final Codec<AdvancementCriteriaRequirement> CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.BOOL).xmap(AdvancementCriteriaRequirement::new, req -> req.criteria);

        public AdvancementCriteriaRequirement(Map<String, Boolean> criteria) {
            this.criteria = criteria;
        }

        public boolean test(AdvancementProgress progress) {
            for (Map.Entry<String, Boolean> entry : this.criteria.entrySet()) {
                CriterionProgress criterionprogress = progress.func_192106_c(entry.getKey());
                if (criterionprogress != null && criterionprogress.func_192151_a() == entry.getValue().booleanValue()) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("serialize_failed");
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            AdvancementCriteriaRequirement that = (AdvancementCriteriaRequirement)obj;
            return this.criteria.equals(that.criteria);
        }
    }

    public static class AdvancementCompletionRequirement {
        private final Boolean complete;
        public static final Codec<AdvancementCompletionRequirement> CODEC = Codec.BOOL.xmap(AdvancementCompletionRequirement::new, req -> req.complete);

        public AdvancementCompletionRequirement(Boolean complete) {
            this.complete = complete;
        }

        public boolean test(AdvancementProgress progress) {
            return progress.func_192105_a() == this.complete.booleanValue();
        }

        public String toString() {
            return CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("serialize_failed");
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            AdvancementCompletionRequirement that = (AdvancementCompletionRequirement)obj;
            return this.complete.equals(that.complete);
        }
    }

    public static class StatRequirement {
        private final StatType<?> type;
        private ResourceLocation statId;
        private final Stat<?> stat;
        private final IntegerBounds value;
        public static final Codec<StatRequirement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Registry.field_212634_w.fieldOf("type").forGetter(stat -> stat.type), (App)ResourceLocation.field_240908_a_.fieldOf("stat").forGetter(stat -> stat.statId), (App)IntegerBounds.CODEC.fieldOf("value").forGetter(stat -> stat.value)).apply((Applicative)instance, StatRequirement::new));

        public StatRequirement(StatType<?> type, ResourceLocation statId, IntegerBounds value) {
            this(type, statId, (Stat)type.func_199080_a().func_82594_a(statId), value);
        }

        public StatRequirement(StatType<?> type, ResourceLocation statId, Stat<?> stat, IntegerBounds value) {
            this.type = type;
            this.statId = statId;
            this.stat = stat;
            this.value = value;
        }

        public StatType<?> type() {
            return this.type;
        }

        public Stat<?> stat() {
            return this.stat;
        }

        public IntegerBounds value() {
            return this.value;
        }

        public boolean test(Stat<?> stat, int value) {
            return stat.func_197921_a() == this.type && this.stat.equals(stat) && this.value.test(value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            StatRequirement that = (StatRequirement)obj;
            return this.type.equals(that.type) && this.statId.equals((Object)that.statId) && this.value.equals(that.value);
        }

        public String toString() {
            return CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("serialize_failed");
        }
    }
}

