/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement.sub_type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.requirement.sub_type.EntitySubRequirement;
import com.momosoftworks.coldsweat.data.codec.util.DoubleBounds;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.raid.Raid;

public final class RaiderRequirement
implements EntitySubRequirement {
    private final Optional<Boolean> hasRaid;
    private final Optional<Boolean> isCaptain;
    private final Optional<RaidData> raid;
    public static final MapCodec<RaiderRequirement> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("has_raid").forGetter(RaiderRequirement::hasRaid), (App)Codec.BOOL.optionalFieldOf("is_captain").forGetter(RaiderRequirement::isCaptain), (App)RaidData.CODEC.optionalFieldOf("raid").forGetter(RaiderRequirement::raid)).apply((Applicative)instance, RaiderRequirement::new));

    public RaiderRequirement(Optional<Boolean> hasRaid, Optional<Boolean> isCaptain, Optional<RaidData> raid) {
        this.hasRaid = hasRaid;
        this.isCaptain = isCaptain;
        this.raid = raid;
    }

    public Optional<Boolean> hasRaid() {
        return this.hasRaid;
    }

    public Optional<Boolean> isCaptain() {
        return this.isCaptain;
    }

    public Optional<RaidData> raid() {
        return this.raid;
    }

    @Override
    public MapCodec<? extends EntitySubRequirement> getCodec() {
        return CODEC;
    }

    @Override
    public boolean test(Entity entity, World level, @Nullable Vector3d position) {
        return entity instanceof AbstractRaiderEntity && this.hasRaid.map(bool -> bool.booleanValue() == ((AbstractRaiderEntity)entity).func_213657_el()).orElse(true) != false && this.isCaptain.map(bool -> bool == RaiderRequirement.isCaptain((AbstractRaiderEntity)entity)).orElse(true) != false && this.raid.map(raidData -> raidData.test(((AbstractRaiderEntity)entity).func_213663_ek())).orElse(true) != false;
    }

    private static boolean isCaptain(AbstractRaiderEntity raider) {
        ItemStack itemstack = raider.func_184582_a(EquipmentSlotType.HEAD);
        boolean wearingBanner = !itemstack.func_190926_b() && ItemStack.func_77989_b((ItemStack)itemstack, (ItemStack)Raid.func_221312_H());
        return wearingBanner && raider.func_213630_eb();
    }

    public static final class RaidData {
        public static final Codec<RaidData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("is_over").forGetter(RaidData::isOver), (App)Codec.BOOL.optionalFieldOf("between_waves").forGetter(RaidData::isBetweenWaves), (App)Codec.BOOL.optionalFieldOf("first_wave_spawned").forGetter(RaidData::isFirstWaveSpawned), (App)Codec.BOOL.optionalFieldOf("is_victory").forGetter(RaidData::isVictory), (App)Codec.BOOL.optionalFieldOf("is_loss").forGetter(RaidData::isLoss), (App)Codec.BOOL.optionalFieldOf("is_started").forGetter(RaidData::isStarted), (App)Codec.BOOL.optionalFieldOf("is_stopped").forGetter(RaidData::isStopped), (App)DoubleBounds.CODEC.optionalFieldOf("total_health").forGetter(RaidData::totalHealth), (App)DoubleBounds.CODEC.optionalFieldOf("bad_omen_level").forGetter(RaidData::badOmenLevel), (App)IntegerBounds.CODEC.optionalFieldOf("current_wave").forGetter(RaidData::currentWave)).apply((Applicative)instance, RaidData::new));
        private final Optional<Boolean> isOver;
        private final Optional<Boolean> isBetweenWaves;
        private final Optional<Boolean> isFirstWaveSpawned;
        private final Optional<Boolean> isVictory;
        private final Optional<Boolean> isLoss;
        private final Optional<Boolean> isStarted;
        private final Optional<Boolean> isStopped;
        private final Optional<DoubleBounds> totalHealth;
        private final Optional<DoubleBounds> badOmenLevel;
        private final Optional<IntegerBounds> currentWave;

        public RaidData(Optional<Boolean> isOver, Optional<Boolean> isBetweenWaves, Optional<Boolean> isFirstWaveSpawned, Optional<Boolean> isVictory, Optional<Boolean> isLoss, Optional<Boolean> isStarted, Optional<Boolean> isStopped, Optional<DoubleBounds> totalHealth, Optional<DoubleBounds> badOmenLevel, Optional<IntegerBounds> currentWave) {
            this.isOver = isOver;
            this.isBetweenWaves = isBetweenWaves;
            this.isFirstWaveSpawned = isFirstWaveSpawned;
            this.isVictory = isVictory;
            this.isLoss = isLoss;
            this.isStarted = isStarted;
            this.isStopped = isStopped;
            this.totalHealth = totalHealth;
            this.badOmenLevel = badOmenLevel;
            this.currentWave = currentWave;
        }

        public boolean test(Raid raid) {
            return this.isOver.map(bool -> bool.booleanValue() == raid.func_221319_a()).orElse(true) != false && this.isBetweenWaves.map(bool -> bool.booleanValue() == raid.func_221334_b()).orElse(true) != false && this.isFirstWaveSpawned.map(bool -> bool.booleanValue() == raid.func_221297_c()).orElse(true) != false && this.isVictory.map(bool -> bool.booleanValue() == raid.func_221321_e()).orElse(true) != false && this.isLoss.map(bool -> bool.booleanValue() == raid.func_221336_f()).orElse(true) != false && this.isStarted.map(bool -> bool.booleanValue() == raid.func_221301_k()).orElse(true) != false && this.isStopped.map(bool -> bool.booleanValue() == raid.func_221310_d()).orElse(true) != false && this.totalHealth.map(val -> val.test(raid.func_221290_r())).orElse(true) != false && this.badOmenLevel.map(val -> val.test(raid.func_221291_n())).orElse(true) != false && this.currentWave.map(val -> val.test(raid.func_221315_l())).orElse(true) != false;
        }

        public Optional<Boolean> isOver() {
            return this.isOver;
        }

        public Optional<Boolean> isBetweenWaves() {
            return this.isBetweenWaves;
        }

        public Optional<Boolean> isFirstWaveSpawned() {
            return this.isFirstWaveSpawned;
        }

        public Optional<Boolean> isVictory() {
            return this.isVictory;
        }

        public Optional<Boolean> isLoss() {
            return this.isLoss;
        }

        public Optional<Boolean> isStarted() {
            return this.isStarted;
        }

        public Optional<Boolean> isStopped() {
            return this.isStopped;
        }

        public Optional<DoubleBounds> totalHealth() {
            return this.totalHealth;
        }

        public Optional<DoubleBounds> badOmenLevel() {
            return this.badOmenLevel;
        }

        public Optional<IntegerBounds> currentWave() {
            return this.currentWave;
        }
    }
}

