/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.util;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;

public class BlockInWorld {
    private final IWorldReader level;
    private final BlockPos pos;
    private final boolean loadChunks;
    @Nullable
    private BlockState state;
    @Nullable
    private TileEntity entity;
    private boolean cachedEntity;

    public BlockInWorld(IWorldReader pLevel, BlockPos pPos, boolean pLoadChunks) {
        this.level = pLevel;
        this.pos = pPos.func_185334_h();
        this.loadChunks = pLoadChunks;
    }

    public BlockState getState() {
        if (this.state == null && (this.loadChunks || this.level.func_175667_e(this.pos))) {
            this.state = this.level.func_180495_p(this.pos);
        }
        return this.state;
    }

    @Nullable
    public TileEntity getEntity() {
        if (this.entity == null && !this.cachedEntity) {
            this.entity = this.level.func_175625_s(this.pos);
            this.cachedEntity = true;
        }
        return this.entity;
    }

    public IWorldReader getLevel() {
        return this.level;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public static Predicate<BlockInWorld> hasState(Predicate<BlockState> pState) {
        return block -> block != null && pState.test(block.getState());
    }
}

