/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.mixin;

import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.tag.ModBlockTags;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.CampfireTileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CampfireTileEntity.class})
public class MixinCampfire {
    CampfireTileEntity self = (CampfireTileEntity)this;

    @Inject(method={"cook"}, at={@At(value="HEAD")})
    private void onItemCook(CallbackInfo ci) {
        double maxStrength = (double)ConfigSettings.WATERSKIN_CONSUME_STRENGTH.get().intValue() * 0.6;
        double tempRate = ConfigSettings.TEMP_RATE.get();
        BlockState state = this.self.func_195044_w();
        for (int i = 0; i < this.self.func_213985_c().size(); ++i) {
            ItemStack stack = (ItemStack)this.self.func_213985_c().get(i);
            if (stack.func_77973_b() != ModItems.FILLED_WATERSKIN || (this.self.func_145831_w().func_82737_E() & 4L) != 0L) continue;
            CompoundNBT tag = stack.func_196082_o();
            double temperature = tag.func_74769_h("Temperature");
            if (!state.func_235714_a_((ITag)BlockTags.field_232882_ax_) || !CSMath.betweenExclusive(tag.func_74769_h("Temperature"), -maxStrength, maxStrength)) continue;
            double delta = tempRate * 0.1;
            if (state.func_235714_a_(ModBlockTags.SOUL_FIRE) && ConfigSettings.COLD_SOUL_FIRE.get().booleanValue()) {
                delta *= -1.0;
            }
            tag.func_74780_a("Temperature", temperature + delta);
        }
    }

    @ModifyArg(method={"cook"}, at=@At(value="INVOKE", target="Lnet/minecraft/inventory/InventoryHelper;dropItemStack(Lnet/minecraft/world/World;DDDLnet/minecraft/item/ItemStack;)V"), index=4)
    private ItemStack onItemFinishedCooking(World level, double x, double y, double z, ItemStack result) {
        if (result.func_77973_b() == ModItems.FILLED_WATERSKIN) {
            double maxStrength = (double)ConfigSettings.WATERSKIN_CONSUME_STRENGTH.get().intValue() * 0.6;
            CompoundNBT tag = result.func_196082_o();
            BlockState state = level.func_180495_p(new BlockPos(x, y, z));
            if (state.func_235714_a_((ITag)BlockTags.field_232882_ax_)) {
                double newTemp = maxStrength;
                if (state.func_235714_a_(ModBlockTags.SOUL_FIRE) && ConfigSettings.COLD_SOUL_FIRE.get().booleanValue()) {
                    newTemp *= -1.0;
                }
                tag.func_74780_a("Temperature", newTemp);
            }
        }
        return result;
    }
}

